/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.gui;

import com.puzzletimer.Internationalization;
import com.puzzletimer.gui.CategoryEditorListener;
import com.puzzletimer.models.Category;
import com.puzzletimer.models.PuzzleInfo;
import com.puzzletimer.models.ScramblerInfo;
import com.puzzletimer.puzzles.Puzzle;
import com.puzzletimer.scramblers.Scrambler;
import com.puzzletimer.tips.Tip;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import net.miginfocom.swing.MigLayout;

class CategoryEditorDialog
extends JDialog {
    private JTextField textFieldDescription;
    private JComboBox comboBoxPuzzle;
    private JComboBox comboBoxScrambler;
    private JComboBox comboBoxTips;
    private JButton buttonAdd;
    private JList listTips;
    private JButton buttonUp;
    private JButton buttonDown;
    private JButton buttonRemove;
    private JButton buttonOk;
    private JButton buttonCancel;

    public CategoryEditorDialog(JFrame owner, boolean modal, Puzzle[] puzzles, final Scrambler[] scramblers, final Tip[] tips, final Category category, boolean isEditable, final CategoryEditorListener listener) {
        super((Frame)owner, modal);
        this.setTitle(Internationalization._("category_editor.category_editor"));
        this.setMinimumSize(new Dimension(480, 300));
        this.setPreferredSize(this.getMinimumSize());
        this.createComponents();
        this.textFieldDescription.setText(category.getDescription());
        Puzzle[] puzzleArray = puzzles;
        int n = puzzles.length;
        int n2 = 0;
        while (n2 < n) {
            Puzzle puzzle = puzzleArray[n2];
            this.comboBoxPuzzle.addItem(puzzle.getPuzzleInfo());
            ++n2;
        }
        this.comboBoxPuzzle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PuzzleInfo selectedPuzzle = (PuzzleInfo)CategoryEditorDialog.this.comboBoxPuzzle.getSelectedItem();
                CategoryEditorDialog.this.comboBoxScrambler.removeAllItems();
                Object[] objectArray = scramblers;
                int n = scramblers.length;
                int n2 = 0;
                while (n2 < n) {
                    Scrambler scrambler = objectArray[n2];
                    ScramblerInfo scramblerInfo = scrambler.getScramblerInfo();
                    if (scramblerInfo.getPuzzleId().equals(selectedPuzzle.getPuzzleId())) {
                        CategoryEditorDialog.this.comboBoxScrambler.addItem(scramblerInfo);
                    }
                    ++n2;
                }
                CategoryEditorDialog.this.comboBoxTips.removeAllItems();
                objectArray = tips;
                n = tips.length;
                n2 = 0;
                while (n2 < n) {
                    Object tip = objectArray[n2];
                    if (tip.getPuzzleId().equals(selectedPuzzle.getPuzzleId())) {
                        CategoryEditorDialog.this.comboBoxTips.addItem(tip);
                    }
                    ++n2;
                }
                DefaultListModel listModel = (DefaultListModel)CategoryEditorDialog.this.listTips.getModel();
                listModel.removeAllElements();
                String[] stringArray = category.getTipIds();
                int n3 = stringArray.length;
                n = 0;
                while (n < n3) {
                    String categoryTipId = stringArray[n];
                    Tip[] tipArray = tips;
                    int n4 = tips.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        Tip tip = tipArray[n5];
                        if (categoryTipId.equals(tip.getTipId())) {
                            listModel.addElement(tip);
                            break;
                        }
                        ++n5;
                    }
                    ++n;
                }
            }
        });
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Tip selectedTip = (Tip)CategoryEditorDialog.this.comboBoxTips.getSelectedItem();
                if (selectedTip == null) {
                    return;
                }
                DefaultListModel listModel = (DefaultListModel)CategoryEditorDialog.this.listTips.getModel();
                if (!listModel.contains(selectedTip)) {
                    listModel.addElement(selectedTip);
                }
            }
        });
        this.buttonUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JList listTips = CategoryEditorDialog.this.listTips;
                DefaultListModel model = (DefaultListModel)listTips.getModel();
                int selectedIndex = listTips.getSelectedIndex();
                if (selectedIndex > 0) {
                    Object selectedValue = model.getElementAt(selectedIndex);
                    model.insertElementAt(selectedValue, selectedIndex - 1);
                    model.removeElementAt(selectedIndex + 1);
                    listTips.addSelectionInterval(selectedIndex - 1, selectedIndex - 1);
                }
            }
        });
        this.buttonDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JList listTips = CategoryEditorDialog.this.listTips;
                DefaultListModel model = (DefaultListModel)listTips.getModel();
                int selectedIndex = listTips.getSelectedIndex();
                if (selectedIndex >= 0 && selectedIndex < model.getSize() - 1) {
                    Object selectedValue = model.getElementAt(selectedIndex);
                    model.insertElementAt(selectedValue, selectedIndex + 2);
                    model.removeElementAt(selectedIndex);
                    listTips.addSelectionInterval(selectedIndex + 1, selectedIndex + 1);
                }
            }
        });
        this.buttonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DefaultListModel model = (DefaultListModel)CategoryEditorDialog.this.listTips.getModel();
                int selectedIndex = CategoryEditorDialog.this.listTips.getSelectedIndex();
                if (selectedIndex >= 0) {
                    model.removeElementAt(selectedIndex);
                }
            }
        });
        this.comboBoxPuzzle.setEnabled(isEditable);
        this.comboBoxScrambler.setEnabled(isEditable);
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String scramblerId = ((ScramblerInfo)CategoryEditorDialog.this.comboBoxScrambler.getSelectedItem()).getScramblerId();
                String description = CategoryEditorDialog.this.textFieldDescription.getText();
                ListModel listModel = CategoryEditorDialog.this.listTips.getModel();
                String[] tipIds = new String[listModel.getSize()];
                int i = 0;
                while (i < tipIds.length) {
                    tipIds[i] = ((Tip)listModel.getElementAt(i)).getTipId();
                    ++i;
                }
                listener.categoryEdited(category.setScramblerId(scramblerId).setDescription(description).setTipIds(tipIds));
                CategoryEditorDialog.this.dispose();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CategoryEditorDialog.this.dispose();
            }
        });
        ScramblerInfo categoryScramblerInfo = null;
        Scrambler[] scramblerArray = scramblers;
        int n3 = scramblers.length;
        n = 0;
        while (n < n3) {
            Scrambler scrambler = scramblerArray[n];
            ScramblerInfo scramblerInfo = scrambler.getScramblerInfo();
            if (scramblerInfo.getScramblerId().equals(category.getScramblerId())) {
                categoryScramblerInfo = scramblerInfo;
                break;
            }
            ++n;
        }
        int i = 0;
        while (i < this.comboBoxPuzzle.getItemCount()) {
            PuzzleInfo puzzleInfo = (PuzzleInfo)this.comboBoxPuzzle.getItemAt(i);
            if (puzzleInfo.getPuzzleId().equals(categoryScramblerInfo.getPuzzleId())) {
                this.comboBoxPuzzle.setSelectedIndex(i);
                break;
            }
            ++i;
        }
        i = 0;
        while (i < this.comboBoxScrambler.getItemCount()) {
            ScramblerInfo scramblerInfo = (ScramblerInfo)this.comboBoxScrambler.getItemAt(i);
            if (scramblerInfo.getScramblerId().equals(categoryScramblerInfo.getScramblerId())) {
                this.comboBoxScrambler.setSelectedIndex(i);
                break;
            }
            ++i;
        }
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CategoryEditorDialog.this.setVisible(false);
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    private void createComponents() {
        this.setLayout(new MigLayout("fill", "[pref!][fill][pref!]", "[pref!]8[pref!]8[pref!]8[pref!][grow]16[pref!]"));
        this.add(new JLabel(Internationalization._("category_editor.description")));
        this.textFieldDescription = new JTextField();
        this.add((Component)this.textFieldDescription, "span 2, wrap");
        this.add(new JLabel(Internationalization._("category_editor.puzzle")));
        this.comboBoxPuzzle = new JComboBox();
        this.add((Component)this.comboBoxPuzzle, "span 2, wrap");
        this.add(new JLabel(Internationalization._("category_editor.scrambler")));
        this.comboBoxScrambler = new JComboBox();
        this.add((Component)this.comboBoxScrambler, "span 2, wrap");
        this.add(new JLabel(Internationalization._("category_editor.tips")));
        this.comboBoxTips = new JComboBox();
        this.add(this.comboBoxTips);
        this.buttonAdd = new JButton(Internationalization._("category_editor.add"));
        this.add((Component)this.buttonAdd, "sizegroup button, wrap");
        this.listTips = new JList(new DefaultListModel());
        this.listTips.setSelectionMode(0);
        JScrollPane scrollPane = new JScrollPane(this.listTips);
        this.add((Component)scrollPane, "grow, skip");
        this.buttonUp = new JButton(Internationalization._("category_editor.up"));
        this.add((Component)this.buttonUp, "sizegroup button, top, split 3, flowy");
        this.buttonDown = new JButton(Internationalization._("category_editor.down"));
        this.add((Component)this.buttonDown, "sizegroup button");
        this.buttonRemove = new JButton(Internationalization._("category_editor.remove"));
        this.add((Component)this.buttonRemove, "sizegroup button, wrap");
        this.buttonOk = new JButton(Internationalization._("category_editor.ok"));
        this.add((Component)this.buttonOk, "tag ok, span 3, split");
        this.buttonCancel = new JButton(Internationalization._("category_editor.cancel"));
        this.add((Component)this.buttonCancel, "tag cancel");
    }
}

