/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.gui;

import com.puzzletimer.Internationalization;
import com.puzzletimer.gui.CategoryEditorDialog;
import com.puzzletimer.gui.CategoryEditorListener;
import com.puzzletimer.models.Category;
import com.puzzletimer.models.PuzzleInfo;
import com.puzzletimer.models.ScramblerInfo;
import com.puzzletimer.puzzles.PuzzleProvider;
import com.puzzletimer.scramblers.ScramblerProvider;
import com.puzzletimer.state.CategoryManager;
import com.puzzletimer.tips.TipProvider;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.UUID;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import net.miginfocom.swing.MigLayout;

public class CategoryManagerFrame
extends JFrame {
    private JTable table;
    private JButton buttonAdd;
    private JButton buttonEdit;
    private JButton buttonRemove;
    private JButton buttonOk;

    public CategoryManagerFrame(final PuzzleProvider puzzleProvider, final ScramblerProvider scramblerProvider, final CategoryManager categoryManager, final TipProvider tipProvider) {
        this.setTitle(Internationalization._("category_manager.category_manager"));
        this.setMinimumSize(new Dimension(640, 480));
        this.setPreferredSize(this.getMinimumSize());
        this.createComponents();
        categoryManager.addListener(new CategoryManager.Listener(){

            @Override
            public void categoriesUpdated(Category[] categories, Category currentCategory) {
                DefaultTableModel tableModel = new DefaultTableModel(){

                    @Override
                    public boolean isCellEditable(int row, int column) {
                        return false;
                    }
                };
                tableModel.addColumn(Internationalization._("category_manager.description"));
                tableModel.addColumn(Internationalization._("category_manager.puzzle"));
                tableModel.addColumn(Internationalization._("category_manager.scrambler"));
                Category[] categoryArray = categories;
                int n = categories.length;
                int n2 = 0;
                while (n2 < n) {
                    Category category = categoryArray[n2];
                    ScramblerInfo scramblerInfo = scramblerProvider.get(category.getScramblerId()).getScramblerInfo();
                    PuzzleInfo puzzleInfo = puzzleProvider.get(scramblerInfo.getPuzzleId()).getPuzzleInfo();
                    tableModel.addRow(new Object[]{category.getDescription(), puzzleInfo.getDescription(), scramblerInfo.getDescription()});
                    ++n2;
                }
                CategoryManagerFrame.this.table.setModel(tableModel);
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                int selectedIndex = CategoryManagerFrame.this.table.getSelectedRow();
                if (selectedIndex < 0) {
                    CategoryManagerFrame.this.buttonEdit.setEnabled(false);
                    CategoryManagerFrame.this.buttonRemove.setEnabled(false);
                } else {
                    Category category = categoryManager.getCategories()[selectedIndex];
                    Category currentCategory = categoryManager.getCurrentCategory();
                    CategoryManagerFrame.this.buttonEdit.setEnabled(category != currentCategory);
                    CategoryManagerFrame.this.buttonRemove.setEnabled(category != currentCategory && category.isUserDefined());
                }
            }
        });
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Category category = new Category(UUID.randomUUID(), "RUBIKS-CUBE-RANDOM", Internationalization._("category_manager.new_category"), true, new String[0]);
                CategoryEditorListener listener = new CategoryEditorListener(){

                    @Override
                    public void categoryEdited(Category category) {
                        categoryManager.addCategory(category);
                    }
                };
                CategoryEditorDialog dialog = new CategoryEditorDialog(CategoryManagerFrame.this, true, puzzleProvider.getAll(), scramblerProvider.getAll(), tipProvider.getAll(), category, true, listener);
                dialog.setLocationRelativeTo(null);
                dialog.setVisible(true);
            }
        });
        this.buttonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int selectedIndex = CategoryManagerFrame.this.table.getSelectedRow();
                Category category = categoryManager.getCategories()[selectedIndex];
                CategoryEditorListener listener = new CategoryEditorListener(){

                    @Override
                    public void categoryEdited(Category category) {
                        categoryManager.updateCategory(category);
                    }
                };
                CategoryEditorDialog dialog = new CategoryEditorDialog(CategoryManagerFrame.this, true, puzzleProvider.getAll(), scramblerProvider.getAll(), tipProvider.getAll(), category, false, listener);
                dialog.setLocationRelativeTo(null);
                dialog.setVisible(true);
            }
        });
        this.buttonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int result = JOptionPane.showConfirmDialog(CategoryManagerFrame.this, Internationalization._("category_manager.category_removal_confirmation_message"), Internationalization._("category_manager.remove_category"), 1);
                if (result != 0) {
                    return;
                }
                int selectedIndex = CategoryManagerFrame.this.table.getSelectedRow();
                Category category = categoryManager.getCategories()[selectedIndex];
                categoryManager.removeCategory(category);
            }
        });
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CategoryManagerFrame.this.setVisible(false);
            }
        });
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CategoryManagerFrame.this.setVisible(false);
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    private void createComponents() {
        this.setLayout(new MigLayout("fill", "[grow][pref!]", "[pref!]8[grow]16[pref!]"));
        JLabel labelCategories = new JLabel(Internationalization._("category_manager.categories"));
        this.add((Component)labelCategories, "span 2, wrap");
        this.table = new JTable();
        this.table.setShowVerticalLines(false);
        this.table.setSelectionMode(0);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.table.setFillsViewportHeight(true);
        this.add((Component)scrollPane, "grow");
        this.buttonAdd = new JButton(Internationalization._("category_manager.add"));
        this.add((Component)this.buttonAdd, "top, growx, split, flowy");
        this.buttonEdit = new JButton(Internationalization._("category_manager.edit"));
        this.buttonEdit.setEnabled(false);
        this.add((Component)this.buttonEdit, "growx");
        this.buttonRemove = new JButton(Internationalization._("category_manager.remove"));
        this.buttonRemove.setEnabled(false);
        this.add((Component)this.buttonRemove, "growx, wrap");
        this.buttonOk = new JButton(Internationalization._("category_manager.ok"));
        this.add((Component)this.buttonOk, "tag ok, span 2");
    }
}

