/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.gui;

import com.puzzletimer.Internationalization;
import com.puzzletimer.graphics.Panel3D;
import com.puzzletimer.graphics.Vector3;
import com.puzzletimer.models.ColorScheme;
import com.puzzletimer.puzzles.Puzzle;
import com.puzzletimer.puzzles.PuzzleProvider;
import com.puzzletimer.state.ColorManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import net.miginfocom.swing.MigLayout;

public class ColorSchemeFrame
extends JFrame {
    private JComboBox comboBoxPuzzle;
    private Panel3D panel3D;
    private JTable table;
    private JButton buttonEdit;
    private JButton buttonDefault;
    private JButton buttonOk;

    public ColorSchemeFrame(PuzzleProvider puzzleProvider, final ColorManager colorManager) {
        this.setMinimumSize(new Dimension(480, 600));
        this.setPreferredSize(this.getMinimumSize());
        this.setTitle(Internationalization._("color_scheme.color_scheme"));
        this.createComponents();
        Puzzle defaultPuzzle = null;
        Puzzle[] puzzleArray = puzzleProvider.getAll();
        int n = puzzleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Puzzle puzzle = puzzleArray[n2];
            if (puzzle.getPuzzleInfo().getPuzzleId().equals("RUBIKS-CUBE")) {
                defaultPuzzle = puzzle;
            }
            this.comboBoxPuzzle.addItem(puzzle);
            ++n2;
        }
        this.comboBoxPuzzle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Puzzle puzzle = (Puzzle)ColorSchemeFrame.this.comboBoxPuzzle.getSelectedItem();
                ColorScheme colorScheme = colorManager.getColorScheme(puzzle.getPuzzleInfo().getPuzzleId());
                ColorSchemeFrame.this.update(puzzle, colorScheme);
            }
        });
        this.comboBoxPuzzle.setSelectedItem(defaultPuzzle);
        this.buttonEdit.setEnabled(false);
        this.buttonDefault.setEnabled(false);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                int nSelected = ColorSchemeFrame.this.table.getSelectedRowCount();
                ColorSchemeFrame.this.buttonEdit.setEnabled(nSelected == 1);
                ColorSchemeFrame.this.buttonDefault.setEnabled(nSelected > 0);
            }
        });
        this.buttonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Puzzle puzzle = (Puzzle)ColorSchemeFrame.this.comboBoxPuzzle.getSelectedItem();
                ColorScheme colorScheme = colorManager.getColorScheme(puzzle.getPuzzleInfo().getPuzzleId());
                ColorScheme.FaceColor faceColor = colorScheme.getFaceColors()[ColorSchemeFrame.this.table.getSelectedRow()];
                Color color = JColorChooser.showDialog(ColorSchemeFrame.this, String.format(Internationalization._("color_scheme.face_color"), faceColor.getFaceDescription()), faceColor.getColor());
                if (color != null) {
                    colorManager.setColorScheme(colorScheme.setFaceColor(faceColor.setColor(color)));
                }
            }
        });
        this.buttonDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Puzzle puzzle = (Puzzle)ColorSchemeFrame.this.comboBoxPuzzle.getSelectedItem();
                ColorScheme colorScheme = colorManager.getColorScheme(puzzle.getPuzzleInfo().getPuzzleId());
                int[] nArray = ColorSchemeFrame.this.table.getSelectedRows();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int index = nArray[n2];
                    ColorScheme.FaceColor faceColor = colorScheme.getFaceColors()[index];
                    colorScheme = colorScheme.setFaceColor(faceColor.setColorToDefault());
                    ++n2;
                }
                colorManager.setColorScheme(colorScheme);
            }
        });
        this.setDefaultCloseOperation(1);
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ColorSchemeFrame.this.setVisible(false);
            }
        });
        colorManager.addListener(new ColorManager.Listener(){

            @Override
            public void colorSchemeUpdated(ColorScheme colorScheme) {
                Puzzle puzzle = (Puzzle)ColorSchemeFrame.this.comboBoxPuzzle.getSelectedItem();
                if (puzzle.getPuzzleInfo().getPuzzleId().equals(colorScheme.getPuzzleId())) {
                    ColorSchemeFrame.this.update(puzzle, colorScheme);
                }
            }
        });
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ColorSchemeFrame.this.setVisible(false);
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    private void createComponents() {
        this.setLayout(new MigLayout("fill", "[grow][pref!]", "[pref!][pref!][pref!]12[pref!][]16[pref!]"));
        this.add((Component)new JLabel(Internationalization._("color_scheme.puzzle")), "growx, span, wrap");
        this.comboBoxPuzzle = new JComboBox();
        this.add((Component)this.comboBoxPuzzle, "growx, span, wrap");
        this.panel3D = new Panel3D();
        this.panel3D.setMinimumSize(new Dimension(300, 300));
        this.panel3D.setPreferredSize(this.panel3D.getMinimumSize());
        this.panel3D.setCameraPosition(new Vector3(0.0, 0.0, -2.0));
        this.add((Component)this.panel3D, "growx, span, wrap");
        this.add((Component)new JLabel(Internationalization._("color_scheme.colors")), "growx, span, wrap");
        this.table = new JTable();
        this.table.setShowVerticalLines(false);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.table.setFillsViewportHeight(true);
        this.add((Component)scrollPane, "grow");
        this.buttonEdit = new JButton(Internationalization._("color_scheme.edit"));
        this.add((Component)this.buttonEdit, "growx, top, split, flowy");
        this.buttonDefault = new JButton(Internationalization._("color_scheme.default"));
        this.add((Component)this.buttonDefault, "growx, top, wrap");
        this.buttonOk = new JButton(Internationalization._("color_scheme.ok"));
        this.add((Component)this.buttonOk, "tag ok, span");
    }

    private void update(Puzzle puzzle, ColorScheme colorScheme) {
        this.panel3D.setMesh(puzzle.getScrambledPuzzleMesh(colorScheme, new String[0]));
        this.table.setDefaultRenderer(Color.class, new ColorRenderer());
        DefaultTableModel tableModel = new DefaultTableModel(){

            @Override
            public Class<?> getColumnClass(int c) {
                return this.getValueAt(0, c).getClass();
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        tableModel.addColumn(Internationalization._("color_scheme.face"));
        tableModel.addColumn(Internationalization._("color_scheme.color"));
        ColorScheme.FaceColor[] faceColorArray = colorScheme.getFaceColors();
        int n = faceColorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColorScheme.FaceColor faceColor = faceColorArray[n2];
            tableModel.addRow(new Object[]{faceColor.getFaceDescription(), faceColor.getColor()});
            ++n2;
        }
        this.table.setModel(tableModel);
    }

    private class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        public ColorRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBackground((Color)color);
            Color backgroundColor = isSelected ? table.getSelectionBackground() : table.getBackground();
            this.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, backgroundColor));
            return this;
        }
    }
}

