/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.gui;

import com.puzzletimer.models.Solution;
import com.puzzletimer.util.SolutionUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.swing.JPanel;

public class GraphPanel
extends JPanel {
    ArrayList<Long> solutionTimes;
    private long solutionIntervalStart;
    private long solutionIntervalEnd;
    ArrayList<Long> startTimes;
    long startIntervalStart;
    long startIntervalEnd;

    public GraphPanel(Solution[] solutions) {
        this.setBackground(Color.WHITE);
        this.setSolutions(solutions);
    }

    public void setSolutions(Solution[] solutions) {
        this.solutionTimes = new ArrayList();
        this.startTimes = new ArrayList();
        Solution[] solutionArray = solutions;
        int n = solutions.length;
        int n2 = 0;
        while (n2 < n) {
            Solution solution = solutionArray[n2];
            long time = SolutionUtils.realTime(solution);
            if (time != Long.MAX_VALUE) {
                this.solutionTimes.add(time);
                this.startTimes.add(solution.getTiming().getStart().getTime());
            }
            ++n2;
        }
        if (this.solutionTimes.size() == 0) {
            this.solutionIntervalStart = 17000L;
            this.solutionIntervalEnd = 23000L;
        } else {
            long mean = 0L;
            int i = 0;
            while (i < this.solutionTimes.size()) {
                mean += this.solutionTimes.get(i).longValue();
                ++i;
            }
            mean /= (long)this.solutionTimes.size();
            long variance = 0L;
            int i2 = 0;
            while (i2 < this.solutionTimes.size()) {
                variance = (long)((double)variance + Math.pow(this.solutionTimes.get(i2) - mean, 2.0));
                ++i2;
            }
            long standardDeviation = (long)Math.sqrt(variance /= (long)this.solutionTimes.size());
            this.solutionIntervalStart = mean - 3L * Math.max(50L, standardDeviation);
            this.solutionIntervalEnd = mean + 3L * Math.max(50L, standardDeviation);
        }
        if (this.solutionTimes.size() == 0) {
            Date now = new Date();
            this.startIntervalStart = now.getTime() - 5000L;
            this.startIntervalEnd = now.getTime() + 5000L;
        } else if (this.solutionTimes.size() == 1) {
            this.startIntervalStart = this.startTimes.get(0) - 5000L;
            this.startIntervalEnd = this.startTimes.get(0) + 5000L;
        } else {
            this.startIntervalStart = this.startTimes.get(this.startTimes.size() - 1);
            this.startIntervalEnd = this.startTimes.get(0);
            if (this.startIntervalStart == this.startIntervalEnd) {
                this.startIntervalStart = this.startTimes.get(0) - 5000L;
                this.startIntervalEnd = this.startTimes.get(0) + 5000L;
            }
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setFont(new Font("Arial", 1, 10));
        int hBase = 16;
        int wBase = 45;
        g2.drawLine(wBase, this.getHeight() - hBase, this.getWidth() - 1, this.getHeight() - hBase);
        int nVerticalTicks = 5;
        int i = 0;
        while (i < nVerticalTicks) {
            int x = wBase;
            int y = (int)((double)(this.getHeight() - hBase) - ((double)i + 0.5) * (double)(this.getHeight() - hBase) / (double)nVerticalTicks);
            g2.drawLine(x - 2, y, x + 2, y);
            ++i;
        }
        double vTickInterval = (this.solutionIntervalEnd - this.solutionIntervalStart) / (long)nVerticalTicks;
        int i2 = 0;
        while (i2 < nVerticalTicks) {
            long value = (long)((double)this.solutionIntervalStart + ((double)i2 + 0.5) * vTickInterval);
            String label = SolutionUtils.format(value);
            FontMetrics fontMetrics = g2.getFontMetrics();
            int width = fontMetrics.stringWidth(label);
            int height = fontMetrics.getAscent();
            int x = wBase - width - 4;
            int y = (int)((double)(this.getHeight() - hBase) - ((double)i2 + 0.5) * (double)(this.getHeight() - hBase) / (double)nVerticalTicks + (double)(height / 2) - 1.0);
            g2.drawString(label, x, y);
            ++i2;
        }
        g2.drawLine(wBase, 0, wBase, this.getHeight() - hBase - 1);
        int nHorizontalTicks = 11;
        int i3 = 0;
        while (i3 < nHorizontalTicks) {
            int x = (int)((double)wBase + ((double)i3 + 0.5) * (double)(this.getWidth() - wBase) / (double)nHorizontalTicks);
            int y = this.getHeight() - hBase;
            g2.drawLine(x, y - 2, x, y + 2);
            ++i3;
        }
        double hTickInterval = (double)(this.startIntervalEnd - this.startIntervalStart) / (double)nHorizontalTicks;
        int i4 = 0;
        while (i4 < nHorizontalTicks) {
            long value = (long)((double)this.startIntervalStart + ((double)i4 + 0.5) * hTickInterval);
            String label = this.startIntervalEnd - this.startIntervalStart < 86400000L ? DateFormat.getTimeInstance(2).format(value) : DateFormat.getDateInstance(2).format(value);
            FontMetrics fontMetrics = g2.getFontMetrics();
            int width = fontMetrics.stringWidth(label);
            int height = fontMetrics.getAscent();
            int x = (int)((double)wBase + ((double)i4 + 0.5) * (double)(this.getWidth() - wBase) / (double)nHorizontalTicks - (double)(width / 2));
            int y = this.getHeight() - (hBase - height) / 2;
            g2.drawString(label, x, y);
            ++i4;
        }
        int nBins = this.getWidth() - wBase;
        ArrayList bins = new ArrayList(nBins);
        int i5 = 0;
        while (i5 < nBins) {
            bins.add(new ArrayList());
            ++i5;
        }
        i5 = 0;
        while (i5 < this.solutionTimes.size()) {
            int bin = (int)((long)(nBins - 1) * (this.startTimes.get(i5) - this.startIntervalStart) / (this.startIntervalEnd - this.startIntervalStart));
            ((ArrayList)bins.get(bin)).add(this.solutionTimes.get(i5));
            ++i5;
        }
        i5 = 0;
        while (i5 < nBins) {
            if (((ArrayList)bins.get(i5)).size() > 0) {
                long mean = 0L;
                Iterator iterator = ((ArrayList)bins.get(i5)).iterator();
                while (iterator.hasNext()) {
                    long time = (Long)iterator.next();
                    mean += time;
                }
                if ((mean /= (long)((ArrayList)bins.get(i5)).size()) >= this.solutionIntervalStart && mean < this.solutionIntervalEnd) {
                    int x = wBase + i5;
                    int y = (int)((long)(this.getHeight() - hBase) - (long)(this.getHeight() - hBase) * (mean - this.solutionIntervalStart) / (this.solutionIntervalEnd - this.solutionIntervalStart));
                    g2.fillRect(x - 2, y - 2, 5, 5);
                }
            }
            ++i5;
        }
    }
}

