/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.gui;

import com.puzzletimer.Internationalization;
import com.puzzletimer.gui.GraphPanel;
import com.puzzletimer.gui.HistogramPanel;
import com.puzzletimer.gui.SolutionEditingDialog;
import com.puzzletimer.models.Category;
import com.puzzletimer.models.Scramble;
import com.puzzletimer.models.Solution;
import com.puzzletimer.models.Timing;
import com.puzzletimer.parsers.ScrambleParser;
import com.puzzletimer.parsers.ScrambleParserProvider;
import com.puzzletimer.scramblers.Scrambler;
import com.puzzletimer.scramblers.ScramblerProvider;
import com.puzzletimer.state.CategoryManager;
import com.puzzletimer.state.ScrambleManager;
import com.puzzletimer.state.SessionManager;
import com.puzzletimer.state.SolutionManager;
import com.puzzletimer.statistics.Average;
import com.puzzletimer.statistics.Best;
import com.puzzletimer.statistics.BestAverage;
import com.puzzletimer.statistics.BestMean;
import com.puzzletimer.statistics.InterquartileMean;
import com.puzzletimer.statistics.Mean;
import com.puzzletimer.statistics.Percentile;
import com.puzzletimer.statistics.StandardDeviation;
import com.puzzletimer.statistics.StatisticalMeasure;
import com.puzzletimer.statistics.Worst;
import com.puzzletimer.util.SolutionUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;

public class HistoryFrame
extends JFrame {
    private HistogramPanel histogramPanel;
    private GraphPanel graphPanel;
    private JLabel labelNumberOfSolutions;
    private JLabel labelMean;
    private JLabel labelBest;
    private JLabel labelMeanOf3;
    private JLabel labelBestMeanOf3;
    private JLabel labelAverage;
    private JLabel labelLowerQuartile;
    private JLabel labelMeanOf10;
    private JLabel labelBestMeanOf10;
    private JLabel labelInterquartileMean;
    private JLabel labelMedian;
    private JLabel labelMeanOf100;
    private JLabel labelBestMeanOf100;
    private JLabel labelUpperQuartile;
    private JLabel labelAverageOf5;
    private JLabel labelBestAverageOf5;
    private JLabel labelStandardDeviation;
    private JLabel labelWorst;
    private JLabel labelAverageOf12;
    private JLabel labelBestAverageOf12;
    private JTable table;
    private JButton buttonAddSolutions;
    private JButton buttonEdit;
    private JButton buttonRemove;
    private JButton buttonSelectSession;
    private JButton buttonSelectNone;
    private JButton buttonOk;

    public HistoryFrame(final ScramblerProvider scramblerProvider, final ScrambleParserProvider scrambleParserProvider, final CategoryManager categoryManager, ScrambleManager scrambleManager, final SolutionManager solutionManager, final SessionManager sessionManager) {
        this.setMinimumSize(new Dimension(800, 600));
        this.setPreferredSize(this.getMinimumSize());
        this.createComponents();
        categoryManager.addListener(new CategoryManager.Listener(){

            @Override
            public void categoriesUpdated(Category[] categories, Category currentCategory) {
                HistoryFrame.this.setTitle(String.format(Internationalization._("history.history_category"), currentCategory.getDescription()));
            }
        });
        categoryManager.notifyListeners();
        solutionManager.addListener(new SolutionManager.Listener(){

            @Override
            public void solutionsUpdated(Solution[] solutions) {
                int[] selectedRows = new int[solutions.length];
                int i = 0;
                while (i < selectedRows.length) {
                    selectedRows[i] = i;
                    ++i;
                }
                HistoryFrame.this.histogramPanel.setSolutions(solutions);
                HistoryFrame.this.graphPanel.setSolutions(solutions);
                HistoryFrame.this.updateStatistics(solutions, selectedRows);
                HistoryFrame.this.updateTable(solutions);
            }
        });
        solutionManager.notifyListeners();
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                Solution[] selectedSolutions;
                Solution[] solutions = solutionManager.getSolutions();
                int[] selectedRows = HistoryFrame.this.table.getSelectedRows();
                if (selectedRows.length <= 0) {
                    selectedRows = new int[HistoryFrame.this.table.getRowCount()];
                    int i = 0;
                    while (i < selectedRows.length) {
                        selectedRows[i] = i;
                        ++i;
                    }
                    selectedSolutions = solutions;
                } else {
                    selectedSolutions = new Solution[selectedRows.length];
                    int i = 0;
                    while (i < selectedSolutions.length) {
                        selectedSolutions[i] = solutions[selectedRows[i]];
                        ++i;
                    }
                }
                HistoryFrame.this.histogramPanel.setSolutions(selectedSolutions);
                HistoryFrame.this.graphPanel.setSolutions(selectedSolutions);
                HistoryFrame.this.updateStatistics(selectedSolutions, selectedRows);
                HistoryFrame.this.buttonEdit.setEnabled(HistoryFrame.this.table.getSelectedRowCount() == 1);
                HistoryFrame.this.buttonRemove.setEnabled(HistoryFrame.this.table.getSelectedRowCount() > 0);
            }
        });
        this.buttonAddSolutions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SolutionImporterDialog.SolutionImporterListener listener = new SolutionImporterDialog.SolutionImporterListener(){

                    @Override
                    public void solutionsImported(Solution[] solutions) {
                        solutionManager.addSolutions(solutions);
                    }
                };
                Category currentCategory = categoryManager.getCurrentCategory();
                Scrambler currentScrambler = scramblerProvider.get(currentCategory.getScramblerId());
                String puzzleId = currentScrambler.getScramblerInfo().getPuzzleId();
                ScrambleParser scrambleParser = scrambleParserProvider.get(puzzleId);
                SolutionImporterDialog solutionEditingDialog = new SolutionImporterDialog(HistoryFrame.this, true, currentCategory.getCategoryId(), currentCategory.getScramblerId(), scrambleParser, listener);
                solutionEditingDialog.setLocationRelativeTo(null);
                solutionEditingDialog.setVisible(true);
            }
        });
        this.buttonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Solution[] solutions = solutionManager.getSolutions();
                Solution solution = solutions[HistoryFrame.this.table.getSelectedRow()];
                SolutionEditingDialog.SolutionEditingDialogListener listener = new SolutionEditingDialog.SolutionEditingDialogListener(){

                    @Override
                    public void solutionEdited(Solution solution) {
                        solutionManager.updateSolution(solution);
                    }
                };
                SolutionEditingDialog solutionEditingDialog = new SolutionEditingDialog(HistoryFrame.this, true, solution, listener);
                solutionEditingDialog.setLocationRelativeTo(null);
                solutionEditingDialog.setVisible(true);
            }
        });
        this.buttonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result;
                if (HistoryFrame.this.table.getSelectedRows().length > 5 && (result = JOptionPane.showConfirmDialog(HistoryFrame.this, Internationalization._("history.solution_removal_confirmation_message"), Internationalization._("history.remove_solutions"), 1)) != 0) {
                    return;
                }
                Solution[] solutions = solutionManager.getSolutions();
                int[] selectedRows = HistoryFrame.this.table.getSelectedRows();
                int i = 0;
                while (i < selectedRows.length) {
                    solutionManager.removeSolution(solutions[selectedRows[i]]);
                    ++i;
                }
                HistoryFrame.this.buttonRemove.requestFocusInWindow();
            }
        });
        this.buttonSelectSession.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (HistoryFrame.this.table.getRowCount() > 0) {
                    HistoryFrame.this.table.removeRowSelectionInterval(0, HistoryFrame.this.table.getRowCount() - 1);
                }
                Solution[] solutions = solutionManager.getSolutions();
                Solution[] sessionSolutions = sessionManager.getSolutions();
                int i = 0;
                int j = 0;
                while (i < solutions.length && j < sessionSolutions.length) {
                    if (solutions[i].getSolutionId().equals(sessionSolutions[j].getSolutionId())) {
                        HistoryFrame.this.table.addRowSelectionInterval(i, i);
                        ++j;
                    }
                    ++i;
                }
            }
        });
        this.buttonSelectNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (HistoryFrame.this.table.getRowCount() > 0) {
                    HistoryFrame.this.table.removeRowSelectionInterval(0, HistoryFrame.this.table.getRowCount() - 1);
                }
            }
        });
        this.setDefaultCloseOperation(1);
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                HistoryFrame.this.setVisible(false);
            }
        });
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                HistoryFrame.this.setVisible(false);
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    private void createComponents() {
        this.setLayout(new MigLayout("fill", "[][pref!]", "[pref!][pref!]12[pref!][pref!]12[pref!][pref!]12[pref!][]16[pref!]"));
        this.add((Component)new JLabel(Internationalization._("history.histogram")), "span, wrap");
        this.histogramPanel = new HistogramPanel(new Solution[0], 17);
        this.add((Component)this.histogramPanel, "growx, height 90, span, wrap");
        this.add((Component)new JLabel(Internationalization._("history.graph")), "span, wrap");
        this.graphPanel = new GraphPanel(new Solution[0]);
        this.add((Component)this.graphPanel, "growx, height 90, span, wrap");
        this.add((Component)new JLabel(Internationalization._("history.statistics")), "span, wrap");
        JPanel panelStatistics = new JPanel(new MigLayout("fill, insets 0 n 0 n", "[][pref!]32[][pref!]32[][pref!]32[][pref!]", "[pref!]1[pref!]1[pref!]1[pref!]1[pref!]"));
        this.add((Component)panelStatistics, "growx, span, wrap");
        panelStatistics.add((Component)new JLabel(Internationalization._("history.number_of_solutions")), "");
        this.labelNumberOfSolutions = new JLabel("");
        panelStatistics.add((Component)this.labelNumberOfSolutions, "right");
        panelStatistics.add((Component)new JLabel(Internationalization._("history.best")), "");
        this.labelBest = new JLabel("XX:XX.XX");
        panelStatistics.add((Component)this.labelBest, "right");
        panelStatistics.add((Component)new JLabel(Internationalization._("history.mean_of_3")), "");
        this.labelMeanOf3 = new JLabel("XX:XX.XX");
        panelStatistics.add((Component)this.labelMeanOf3, "right");
        panelStatistics.add((Component)new JLabel(Internationalization._("history.best_mean_of_3")), "");
        this.labelBestMeanOf3 = new JLabel("XX:XX.XX");
        panelStatistics.add((Component)this.labelBestMeanOf3, "right, wrap");
        panelStatistics.add((Component)new JLabel(Internationalization._("history.mean")), "");
        this.labelMean = new JLabel("XX:XX.XX");
        panelStatistics.add((Component)this.labelMean, "right");
        panelStatistics.add((Component)new JLabel(Internationalization._("history.lower_quartile")), "");
        this.labelLowerQuartile = new JLabel("XX:XX.XX");
        panelStatistics.add((Component)this.labelLowerQuartile, "right");
        panelStatistics.add((Component)new JLabel(Internationalization._("history.mean_of_10")), "");
        this.labelMeanOf10 = new JLabel("XX:XX.XX");
        panelStatistics.add((Component)this.labelMeanOf10, "right");
        panelStatistics.add((Component)new JLabel(Internationalization._("history.best_mean_of_10")), "");
        this.labelBestMeanOf10 = new JLabel("XX:XX.XX");
        panelStatistics.add((Component)this.labelBestMeanOf10, "right, wrap");
        panelStatistics.add((Component)new JLabel(Internationalization._("history.average")), "");
        this.labelAverage = new JLabel("XX:XX.XX");
        panelStatistics.add((Component)this.labelAverage, "right");
        panelStatistics.add((Component)new JLabel(Internationalization._("history.median")), "");
        this.labelMedian = new JLabel("XX:XX.XX");
        panelStatistics.add((Component)this.labelMedian, "right");
        panelStatistics.add((Component)new JLabel(Internationalization._("history.mean_of_100")), "");
        this.labelMeanOf100 = new JLabel("XX:XX.XX");
        panelStatistics.add((Component)this.labelMeanOf100, "right");
        panelStatistics.add((Component)new JLabel(Internationalization._("history.best_mean_of_100")), "");
        this.labelBestMeanOf100 = new JLabel("XX:XX.XX");
        panelStatistics.add((Component)this.labelBestMeanOf100, "right, wrap");
        panelStatistics.add((Component)new JLabel(Internationalization._("history.interquartile_mean")), "");
        this.labelInterquartileMean = new JLabel("XX:XX.XX");
        panelStatistics.add((Component)this.labelInterquartileMean, "right");
        panelStatistics.add((Component)new JLabel(Internationalization._("history.upper_quartile")), "");
        this.labelUpperQuartile = new JLabel("XX:XX.XX");
        panelStatistics.add((Component)this.labelUpperQuartile, "right");
        panelStatistics.add((Component)new JLabel(Internationalization._("history.average_of_5")), "");
        this.labelAverageOf5 = new JLabel("XX:XX.XX");
        panelStatistics.add((Component)this.labelAverageOf5, "right");
        panelStatistics.add((Component)new JLabel(Internationalization._("history.best_average_of_5")), "");
        this.labelBestAverageOf5 = new JLabel("XX:XX.XX");
        panelStatistics.add((Component)this.labelBestAverageOf5, "right, wrap");
        panelStatistics.add((Component)new JLabel(Internationalization._("history.standard_deviation")), "");
        this.labelStandardDeviation = new JLabel("XX:XX.XX");
        panelStatistics.add((Component)this.labelStandardDeviation, "right");
        panelStatistics.add((Component)new JLabel(Internationalization._("history.worst")), "");
        this.labelWorst = new JLabel("XX:XX.XX");
        panelStatistics.add((Component)this.labelWorst, "right");
        panelStatistics.add((Component)new JLabel(Internationalization._("history.average_of_12")), "");
        this.labelAverageOf12 = new JLabel("XX:XX.XX");
        panelStatistics.add((Component)this.labelAverageOf12, "right");
        panelStatistics.add((Component)new JLabel(Internationalization._("history.best_average_of_12")), "");
        this.labelBestAverageOf12 = new JLabel("XX:XX.XX");
        panelStatistics.add((Component)this.labelBestAverageOf12, "right");
        JLabel labelTimes = new JLabel(Internationalization._("history.solutions"));
        this.add((Component)labelTimes, "span, wrap");
        this.table = new JTable();
        this.table.setShowVerticalLines(false);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.table.setFillsViewportHeight(true);
        this.add((Component)scrollPane, "grow");
        this.buttonAddSolutions = new JButton(Internationalization._("history.add_solutions"));
        this.add((Component)this.buttonAddSolutions, "growx, top, split 5, flowy");
        this.buttonEdit = new JButton(Internationalization._("history.edit"));
        this.buttonEdit.setEnabled(false);
        this.add((Component)this.buttonEdit, "growx, top");
        this.buttonRemove = new JButton(Internationalization._("history.remove"));
        this.buttonRemove.setEnabled(false);
        this.add((Component)this.buttonRemove, "growx, top");
        this.buttonSelectSession = new JButton(Internationalization._("history.select_session"));
        this.add((Component)this.buttonSelectSession, "growx, top, gaptop 16");
        this.buttonSelectNone = new JButton(Internationalization._("history.select_none"));
        this.add((Component)this.buttonSelectNone, "growx, top, wrap");
        this.buttonOk = new JButton(Internationalization._("history.ok"));
        this.add((Component)this.buttonOk, "tag ok, span");
    }

    private void updateStatistics(Solution[] solutions, final int[] selectedRows) {
        this.labelNumberOfSolutions.setText(Integer.toString(solutions.length));
        JLabel[] labels = new JLabel[]{this.labelBest, this.labelMeanOf3, this.labelBestMeanOf3, this.labelMean, this.labelLowerQuartile, this.labelMeanOf10, this.labelBestMeanOf10, this.labelAverage, this.labelMedian, this.labelMeanOf100, this.labelBestMeanOf100, this.labelInterquartileMean, this.labelUpperQuartile, this.labelAverageOf5, this.labelBestAverageOf5, this.labelStandardDeviation, this.labelWorst, this.labelAverageOf12, this.labelBestAverageOf12};
        StatisticalMeasure[] measures = new StatisticalMeasure[]{new Best(1, Integer.MAX_VALUE), new Mean(3, 3), new BestMean(3, Integer.MAX_VALUE), new Mean(1, Integer.MAX_VALUE), new Percentile(1, Integer.MAX_VALUE, 0.25), new Mean(10, 10), new BestMean(10, Integer.MAX_VALUE), new Average(3, Integer.MAX_VALUE), new Percentile(1, Integer.MAX_VALUE, 0.5), new Mean(100, 100), new BestMean(100, Integer.MAX_VALUE), new InterquartileMean(3, Integer.MAX_VALUE), new Percentile(1, Integer.MAX_VALUE, 0.75), new Average(5, 5), new BestAverage(5, Integer.MAX_VALUE), new StandardDeviation(1, Integer.MAX_VALUE), new Worst(1, Integer.MAX_VALUE), new Average(12, 12), new BestAverage(12, Integer.MAX_VALUE)};
        boolean[] blArray = new boolean[19];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[5] = true;
        blArray[6] = true;
        blArray[9] = true;
        blArray[10] = true;
        blArray[13] = true;
        blArray[14] = true;
        blArray[16] = true;
        blArray[17] = true;
        blArray[18] = true;
        boolean[] clickable = blArray;
        int i = 0;
        while (i < labels.length) {
            int j;
            if (solutions.length >= measures[i].getMinimumWindowSize()) {
                int size = Math.min(solutions.length, measures[i].getMaximumWindowSize());
                Solution[] window = new Solution[size];
                j = 0;
                while (j < size) {
                    window[j] = solutions[j];
                    ++j;
                }
                measures[i].setSolutions(window);
                labels[i].setText(SolutionUtils.formatMinutes(measures[i].getValue()));
            } else {
                labels[i].setText("XX:XX.XX");
            }
            if (clickable[i]) {
                MouseListener[] mouseListeners;
                MouseListener[] mouseListenerArray = mouseListeners = labels[i].getMouseListeners();
                int n = mouseListeners.length;
                j = 0;
                while (j < n) {
                    MouseListener mouseListener = mouseListenerArray[j];
                    labels[i].removeMouseListener(mouseListener);
                    ++j;
                }
                labels[i].setCursor(new Cursor(0));
                if (solutions.length >= measures[i].getMinimumWindowSize()) {
                    labels[i].setCursor(new Cursor(12));
                    final int windowSize = measures[i].getMinimumWindowSize();
                    final int windowPosition = measures[i].getWindowPosition();
                    labels[i].addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            if (HistoryFrame.this.table.getRowCount() > 0) {
                                HistoryFrame.this.table.removeRowSelectionInterval(0, HistoryFrame.this.table.getRowCount() - 1);
                            }
                            int i = 0;
                            while (i < windowSize) {
                                HistoryFrame.this.table.addRowSelectionInterval(selectedRows[windowPosition + i], selectedRows[windowPosition + i]);
                                ++i;
                            }
                        }
                    });
                }
            }
            ++i;
        }
    }

    private void updateTable(Solution[] solutions) {
        DefaultTableModel tableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        tableModel.addColumn(Internationalization._("history.#"));
        tableModel.addColumn(Internationalization._("history.start"));
        tableModel.addColumn(Internationalization._("history.time"));
        tableModel.addColumn(Internationalization._("history.penalty"));
        tableModel.addColumn(Internationalization._("history.scramble"));
        this.table.setModel(tableModel);
        this.table.setAutoResizeMode(3);
        int[] columnsWidth = new int[]{100, 400, 200, 200, 1000};
        int i = 0;
        while (i < columnsWidth.length) {
            TableColumn indexColumn = this.table.getColumnModel().getColumn(i);
            indexColumn.setPreferredWidth(columnsWidth[i]);
            ++i;
        }
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
        int i2 = 0;
        while (i2 < solutions.length) {
            String sStart = dateFormat.format(solutions[i2].getTiming().getStart());
            String sTime = SolutionUtils.formatMinutes(solutions[i2].getTiming().getElapsedTime());
            tableModel.addRow(new Object[]{solutions.length - i2, sStart, sTime, solutions[i2].getPenalty(), solutions[i2].getScramble().getRawSequence()});
            ++i2;
        }
    }

    private static class SolutionImporterDialog
    extends JDialog {
        private JTextArea textAreaContents;
        private JButton buttonOk;
        private JButton buttonCancel;

        public SolutionImporterDialog(JFrame owner, boolean modal, final UUID categoryId, final String scramblerId, final ScrambleParser scrambleParser, final SolutionImporterListener listener) {
            super((Frame)owner, modal);
            this.setTitle(Internationalization._("solution_importer.solution_importer"));
            this.setMinimumSize(new Dimension(640, 480));
            this.setPreferredSize(this.getMinimumSize());
            this.createComponents();
            this.buttonOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    String contents = SolutionImporterDialog.this.textAreaContents.getText();
                    Date start = new Date();
                    ArrayList<Solution> solutions = new ArrayList<Solution>();
                    String[] stringArray = contents.split("\n");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        if ((line = line.trim()).length() != 0 && !line.startsWith("#")) {
                            String[] parts = line.split("\\s+", 2);
                            long time = SolutionUtils.parseTime(parts[0]);
                            Timing timing = new Timing(start, new Date(start.getTime() + time));
                            Scramble scramble = new Scramble(scramblerId, new String[0]);
                            if (parts.length > 1) {
                                scramble = new Scramble(scramblerId, scrambleParser.parse(parts[1]));
                            }
                            solutions.add(new Solution(UUID.randomUUID(), categoryId, scramble, timing, ""));
                            start = new Date(start.getTime() + time);
                        }
                        ++n2;
                    }
                    Solution[] solutionsArray = new Solution[solutions.size()];
                    solutions.toArray(solutionsArray);
                    listener.solutionsImported(solutionsArray);
                    SolutionImporterDialog.this.dispose();
                }
            });
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    SolutionImporterDialog.this.dispose();
                }
            });
            this.getRootPane().registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    SolutionImporterDialog.this.dispose();
                }
            }, KeyStroke.getKeyStroke(27, 0), 2);
        }

        private void createComponents() {
            this.setLayout(new MigLayout("fill", "", "[pref!][fill]16[pref!]"));
            this.add((Component)new JLabel(Internationalization._("solution_importer.solutions")), "wrap");
            this.textAreaContents = new JTextArea(Internationalization._("solution_importer.default_contents"));
            JScrollPane scrollPane = new JScrollPane(this.textAreaContents);
            this.add((Component)scrollPane, "growx, wrap");
            this.buttonOk = new JButton(Internationalization._("solution_importer.ok"));
            this.add((Component)this.buttonOk, "right, width 100, span 2, split");
            this.buttonCancel = new JButton(Internationalization._("solution_importer.cancel"));
            this.add((Component)this.buttonCancel, "width 100");
        }

        public static class SolutionImporterListener {
            public void solutionsImported(Solution[] solutions) {
            }
        }
    }
}

