/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.gui;

import com.puzzletimer.Internationalization;
import com.puzzletimer.graphics.Panel3D;
import com.puzzletimer.gui.AboutDialog;
import com.puzzletimer.gui.CategoryManagerFrame;
import com.puzzletimer.gui.ColorSchemeFrame;
import com.puzzletimer.gui.HandImage;
import com.puzzletimer.gui.HistoryFrame;
import com.puzzletimer.gui.ScrambleQueueFrame;
import com.puzzletimer.gui.SessionSummaryFrame;
import com.puzzletimer.gui.SolutionEditingDialog;
import com.puzzletimer.gui.TimeLabel;
import com.puzzletimer.gui.TipsFrame;
import com.puzzletimer.gui.WrapLayout;
import com.puzzletimer.models.Category;
import com.puzzletimer.models.ColorScheme;
import com.puzzletimer.models.Scramble;
import com.puzzletimer.models.Solution;
import com.puzzletimer.models.Timing;
import com.puzzletimer.parsers.ScrambleParserProvider;
import com.puzzletimer.puzzles.Puzzle;
import com.puzzletimer.puzzles.PuzzleProvider;
import com.puzzletimer.scramblers.Scrambler;
import com.puzzletimer.scramblers.ScramblerProvider;
import com.puzzletimer.state.CategoryManager;
import com.puzzletimer.state.ColorManager;
import com.puzzletimer.state.ConfigurationManager;
import com.puzzletimer.state.MessageManager;
import com.puzzletimer.state.ScrambleManager;
import com.puzzletimer.state.SessionManager;
import com.puzzletimer.state.SolutionManager;
import com.puzzletimer.state.TimerManager;
import com.puzzletimer.statistics.Average;
import com.puzzletimer.statistics.Best;
import com.puzzletimer.statistics.BestAverage;
import com.puzzletimer.statistics.BestMean;
import com.puzzletimer.statistics.Mean;
import com.puzzletimer.statistics.Percentile;
import com.puzzletimer.statistics.StandardDeviation;
import com.puzzletimer.statistics.StatisticalMeasure;
import com.puzzletimer.statistics.Worst;
import com.puzzletimer.timer.ControlKeysTimer;
import com.puzzletimer.timer.SpaceKeyTimer;
import com.puzzletimer.timer.StackmatTimer;
import com.puzzletimer.tips.TipProvider;
import com.puzzletimer.util.SolutionUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Date;
import java.util.UUID;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;

public class MainFrame
extends JFrame {
    private MessageManager messageManager;
    private ConfigurationManager configurationManager;
    private TimerManager timerManager;
    private PuzzleProvider puzzleProvider;
    private ColorManager colorManager;
    private ScrambleParserProvider scrambleParserProvider;
    private ScramblerProvider scramblerProvider;
    private TipProvider tipProvider;
    private CategoryManager categoryManager;
    private ScrambleManager scrambleManager;
    private SolutionManager solutionManager;
    private SessionManager sessionManager;
    private JMenu menuFile;
    private JMenuItem menuItemAddSolution;
    private JMenuItem menuItemExit;
    private JMenuItem menuItemTips;
    private JMenuItem menuItemScrambleQueue;
    private JMenuItem menuItemHistory;
    private JMenuItem menuItemSessionSummary;
    private JMenu menuCategory;
    private JMenuItem menuItemColorScheme;
    private JCheckBoxMenuItem menuItemInspectionTime;
    private JMenu stackmatTimerInputDevice;
    private ButtonGroup stackmatTimerInputDeviceGroup;
    private JRadioButtonMenuItem menuItemCtrlKeys;
    private JRadioButtonMenuItem menuItemSpaceKey;
    private JRadioButtonMenuItem menuItemStackmatTimer;
    private JMenuItem menuItemAbout;
    private JLabel labelMessage;
    private ScramblePanel scramblePanel;
    private TimerPanel timerPanel;
    private TimesScrollPane timesScrollPane;
    private StatisticsPanel statisticsPanel;
    private ScrambleViewerPanel scrambleViewerPanel;
    private TipsFrame tipsFrame;
    private ScrambleQueueFrame scrambleQueueFrame;
    private HistoryFrame historyFrame;
    private SessionSummaryFrame sessionSummaryFrame;
    private CategoryManagerFrame categoryManagerDialog;
    private ColorSchemeFrame colorSchemeFrame;
    private AudioFormat audioFormat;
    private Mixer.Info mixerInfo;

    public MainFrame(MessageManager messageManager, ConfigurationManager configurationManager, TimerManager timerManager, PuzzleProvider puzzleProvider, ColorManager colorManager, ScrambleParserProvider scrambleParserProvider, ScramblerProvider scramblerProvider, TipProvider tipProvider, CategoryManager categoryManager, ScrambleManager scrambleManager, SolutionManager solutionManager, SessionManager sessionManager) {
        Mixer.Info mixerInfo;
        this.messageManager = messageManager;
        this.puzzleProvider = puzzleProvider;
        this.scrambleParserProvider = scrambleParserProvider;
        this.scramblerProvider = scramblerProvider;
        this.tipProvider = tipProvider;
        this.configurationManager = configurationManager;
        this.timerManager = timerManager;
        this.categoryManager = categoryManager;
        this.scrambleManager = scrambleManager;
        this.solutionManager = solutionManager;
        this.sessionManager = sessionManager;
        this.colorManager = colorManager;
        this.setMinimumSize(new Dimension(800, 600));
        this.setPreferredSize(this.getMinimumSize());
        this.createComponents();
        this.audioFormat = new AudioFormat(8000.0f, 8, 1, true, false);
        this.mixerInfo = null;
        String stackmatTimerInputDeviceName = this.configurationManager.getConfiguration("STACKMAT-TIMER-INPUT-DEVICE");
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        int n = infoArray.length;
        int n2 = 0;
        while (n2 < n) {
            mixerInfo = infoArray[n2];
            if (stackmatTimerInputDeviceName.equals(mixerInfo.getName())) {
                this.mixerInfo = mixerInfo;
                break;
            }
            ++n2;
        }
        this.setTimerTrigger(this.configurationManager.getConfiguration("TIMER-TRIGGER"));
        try {
            final Clip[] inspectionClips = new Clip[4];
            String[] fileNames = new String[]{"eight_seconds.wav", "go.wav", "plus_two.wav", "dnf.wav"};
            int i = 0;
            while (i < inspectionClips.length) {
                inspectionClips[i] = AudioSystem.getClip();
                inspectionClips[i].open(AudioSystem.getAudioInputStream(MainFrame.class.getResourceAsStream("/com/puzzletimer/resources/inspection/" + fileNames[i])));
                ++i;
            }
            this.timerManager.addListener(new TimerManager.Listener(){
                private int next;

                @Override
                public void inspectionStarted() {
                    this.next = 0;
                }

                @Override
                public void inspectionRunning(long remainingTime) {
                    int[] nArray = new int[5];
                    nArray[0] = 7000;
                    nArray[1] = 3000;
                    nArray[3] = -2000;
                    nArray[4] = Integer.MIN_VALUE;
                    int[] soundStartTimes = nArray;
                    if (remainingTime <= (long)soundStartTimes[this.next]) {
                        inspectionClips[this.next].setFramePosition(0);
                        inspectionClips[this.next].start();
                        ++this.next;
                    }
                }
            });
        }
        catch (Exception inspectionClips) {
            // empty catch block
        }
        this.categoryManager.addListener(new CategoryManager.Listener(){

            @Override
            public void categoriesUpdated(Category[] categories, Category currentCategory) {
                MainFrame.this.setTitle(String.format(Internationalization._("main.prisma_puzzle_time_category"), currentCategory.getDescription()));
            }
        });
        this.menuItemAddSolution.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Date now = new Date();
                Solution solution = new Solution(UUID.randomUUID(), MainFrame.this.categoryManager.getCurrentCategory().getCategoryId(), MainFrame.this.scrambleManager.getCurrentScramble(), new Timing(now, now), "");
                SolutionEditingDialog.SolutionEditingDialogListener listener = new SolutionEditingDialog.SolutionEditingDialogListener(){

                    @Override
                    public void solutionEdited(Solution solution) {
                        MainFrame.this.solutionManager.addSolution(solution);
                        MainFrame.this.scrambleManager.changeScramble();
                    }
                };
                SolutionEditingDialog solutionEditingDialog = new SolutionEditingDialog(MainFrame.this, true, solution, listener);
                solutionEditingDialog.setTitle(Internationalization._("main.add_solution_title"));
                solutionEditingDialog.setLocationRelativeTo(null);
                solutionEditingDialog.setVisible(true);
            }
        });
        this.menuItemExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        this.menuItemTips.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.tipsFrame.setVisible(true);
            }
        });
        this.menuItemScrambleQueue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.scrambleQueueFrame.setVisible(true);
            }
        });
        this.menuItemHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.historyFrame.setVisible(true);
            }
        });
        this.menuItemSessionSummary.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.sessionSummaryFrame.setVisible(true);
            }
        });
        this.categoryManager.addListener(new CategoryManager.Listener(){

            @Override
            public void categoriesUpdated(Category[] categories, Category currentCategory) {
                JRadioButtonMenuItem menuItemCategory;
                int menuShortcutKey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
                MainFrame.this.menuCategory.removeAll();
                JMenuItem menuItemCategoryManager = new JMenuItem(Internationalization._("main.category_manager"));
                menuItemCategoryManager.setMnemonic(77);
                menuItemCategoryManager.setAccelerator(KeyStroke.getKeyStroke(67, menuShortcutKey | 8));
                menuItemCategoryManager.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        MainFrame.this.categoryManagerDialog.setVisible(true);
                    }
                });
                MainFrame.this.menuCategory.add(menuItemCategoryManager);
                MainFrame.this.menuCategory.addSeparator();
                ButtonGroup categoryGroup = new ButtonGroup();
                class BuiltInCategory {
                    public final Category category;
                    public final char mnemonic;
                    public final char accelerator;

                    public BuiltInCategory(Category category, char mnemonic, char accelerator) {
                        this.category = category;
                        this.mnemonic = mnemonic;
                        this.accelerator = accelerator;
                    }
                }
                BuiltInCategory[] builtInCategories = new BuiltInCategory[]{new BuiltInCategory(categories[0], '2', '2'), new BuiltInCategory(categories[1], 'R', '3'), new BuiltInCategory(categories[2], 'O', 'O'), new BuiltInCategory(categories[3], 'B', 'B'), new BuiltInCategory(categories[4], 'F', 'F'), new BuiltInCategory(categories[5], '4', '4'), new BuiltInCategory(categories[6], 'B', '\u0000'), new BuiltInCategory(categories[7], '5', '5'), new BuiltInCategory(categories[8], 'B', '\u0000'), new BuiltInCategory(categories[9], '6', '6'), new BuiltInCategory(categories[10], '7', '7'), new BuiltInCategory(categories[11], 'C', 'K'), new BuiltInCategory(categories[12], 'M', 'M'), new BuiltInCategory(categories[13], 'P', 'P'), new BuiltInCategory(categories[14], 'S', '1'), new BuiltInCategory(categories[15], 'M', 'G'), new BuiltInCategory(categories[16], 'M', 'A')};
                Object[] objectArray = builtInCategories;
                int n = builtInCategories.length;
                int n2 = 0;
                while (n2 < n) {
                    final BuiltInCategory builtInCategory = objectArray[n2];
                    menuItemCategory = new JRadioButtonMenuItem(builtInCategory.category.getDescription());
                    menuItemCategory.setMnemonic(builtInCategory.mnemonic);
                    if (builtInCategory.accelerator != '\u0000') {
                        menuItemCategory.setAccelerator(KeyStroke.getKeyStroke((int)builtInCategory.accelerator, menuShortcutKey));
                    }
                    menuItemCategory.setSelected(builtInCategory.category == currentCategory);
                    menuItemCategory.addActionListener(new ActionListener(){
                        {
                        }

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            MainFrame.this.categoryManager.setCurrentCategory(builtInCategory.category);
                        }
                    });
                    MainFrame.this.menuCategory.add(menuItemCategory);
                    categoryGroup.add(menuItemCategory);
                    ++n2;
                }
                MainFrame.this.menuCategory.addSeparator();
                objectArray = categories;
                n = categories.length;
                n2 = 0;
                while (n2 < n) {
                    Object category = objectArray[n2];
                    if (((Category)category).isUserDefined()) {
                        menuItemCategory = new JRadioButtonMenuItem(((Category)category).getDescription());
                        menuItemCategory.setSelected(category == currentCategory);
                        menuItemCategory.addActionListener(new ActionListener((Category)category){
                            private final /* synthetic */ Category val$category;
                            {
                                this.val$category = category;
                            }

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                MainFrame.this.categoryManager.setCurrentCategory(this.val$category);
                            }
                        });
                        MainFrame.this.menuCategory.add(menuItemCategory);
                        categoryGroup.add(menuItemCategory);
                    }
                    ++n2;
                }
            }
        });
        this.menuItemColorScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.colorSchemeFrame.setVisible(true);
            }
        });
        this.menuItemInspectionTime.setSelected(timerManager.isInspectionEnabled());
        this.menuItemInspectionTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.timerManager.setInspectionEnabled(MainFrame.this.menuItemInspectionTime.isSelected());
            }
        });
        this.menuItemCtrlKeys.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.setTimerTrigger("KEYBOARD-TIMER-CONTROL");
            }
        });
        this.menuItemSpaceKey.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.setTimerTrigger("KEYBOARD-TIMER-SPACE");
            }
        });
        this.menuItemStackmatTimer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.setTimerTrigger("STACKMAT-TIMER");
            }
        });
        infoArray = AudioSystem.getMixerInfo();
        n = infoArray.length;
        int n3 = 0;
        while (n3 < n) {
            mixerInfo = infoArray[n3];
            Line.Info[] targetLinesInfo = AudioSystem.getTargetLineInfo(new DataLine.Info(TargetDataLine.class, this.audioFormat));
            boolean validMixer = false;
            Line.Info[] infoArray2 = targetLinesInfo;
            int n4 = targetLinesInfo.length;
            int n5 = 0;
            while (n5 < n4) {
                Line.Info lineInfo = infoArray2[n5];
                if (AudioSystem.getMixer(mixerInfo).isLineSupported(lineInfo)) {
                    validMixer = true;
                    break;
                }
                ++n5;
            }
            if (validMixer) {
                JRadioButtonMenuItem menuItemDevice = new JRadioButtonMenuItem(mixerInfo.getName());
                menuItemDevice.setSelected(stackmatTimerInputDeviceName.equals(mixerInfo.getName()));
                menuItemDevice.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        MainFrame.this.mixerInfo = mixerInfo;
                        MainFrame.this.configurationManager.setConfiguration("STACKMAT-TIMER-INPUT-DEVICE", mixerInfo.getName());
                        String timerTrigger = MainFrame.this.configurationManager.getConfiguration("TIMER-TRIGGER");
                        if (timerTrigger.equals("STACKMAT-TIMER")) {
                            MainFrame.this.setTimerTrigger("STACKMAT-TIMER");
                        }
                    }
                });
                this.stackmatTimerInputDevice.add(menuItemDevice);
                this.stackmatTimerInputDeviceGroup.add(menuItemDevice);
                if (this.mixerInfo == null) {
                    menuItemDevice.setSelected(true);
                    this.mixerInfo = mixerInfo;
                    this.configurationManager.setConfiguration("STACKMAT-TIMER-INPUT-DEVICE", mixerInfo.getName());
                }
            }
            ++n3;
        }
        this.menuItemAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog aboutDialog = new AboutDialog(MainFrame.this, true);
                aboutDialog.setLocationRelativeTo(null);
                aboutDialog.setVisible(true);
            }
        });
        this.messageManager.addListener(new MessageManager.Listener(){

            @Override
            public void messagesCleared() {
                MainFrame.this.labelMessage.setPreferredSize(new Dimension());
                MainFrame.this.labelMessage.setVisible(false);
            }

            @Override
            public void messageReceived(MessageManager.MessageType messageType, String message) {
                MainFrame.this.labelMessage.setPreferredSize(new Dimension(10000, 30));
                if (messageType == MessageManager.MessageType.INFORMATION) {
                    MainFrame.this.labelMessage.setBackground(new Color(69, 115, 213));
                } else if (messageType == MessageManager.MessageType.ERROR) {
                    MainFrame.this.labelMessage.setBackground(new Color(255, 64, 64));
                }
                MainFrame.this.labelMessage.setText(message);
                MainFrame.this.labelMessage.setVisible(true);
            }
        });
    }

    private void setTimerTrigger(String timerTriggerId) {
        if (timerTriggerId.equals("KEYBOARD-TIMER-CONTROL")) {
            this.menuItemCtrlKeys.setSelected(true);
            this.timerManager.setTimer(new ControlKeysTimer(this, this.timerManager));
        } else if (timerTriggerId.equals("KEYBOARD-TIMER-SPACE")) {
            this.menuItemSpaceKey.setSelected(true);
            this.timerManager.setTimer(new SpaceKeyTimer(this, this.timerManager));
        } else if (timerTriggerId.equals("STACKMAT-TIMER")) {
            if (this.mixerInfo != null) {
                TargetDataLine targetDataLine = null;
                try {
                    targetDataLine = AudioSystem.getTargetDataLine(this.audioFormat, this.mixerInfo);
                    targetDataLine.open(this.audioFormat);
                    this.menuItemStackmatTimer.setSelected(true);
                    this.timerManager.setTimer(new StackmatTimer(targetDataLine, this.timerManager));
                }
                catch (LineUnavailableException e) {
                    this.menuItemSpaceKey.setSelected(true);
                    this.timerManager.setTimer(new SpaceKeyTimer(this, this.timerManager));
                    this.messageManager.enqueueMessage(MessageManager.MessageType.ERROR, Internationalization._("main.stackmat_timer_error_message"));
                }
            } else {
                this.menuItemSpaceKey.setSelected(true);
                this.timerManager.setTimer(new SpaceKeyTimer(this, this.timerManager));
                this.messageManager.enqueueMessage(MessageManager.MessageType.ERROR, Internationalization._("main.stackmat_timer_error_message"));
            }
        }
    }

    private void createComponents() {
        int menuShortcutKey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        this.menuFile = new JMenu(Internationalization._("main.file"));
        this.menuFile.setMnemonic(70);
        menuBar.add(this.menuFile);
        this.menuItemAddSolution = new JMenuItem(Internationalization._("main.add_solution"));
        this.menuItemAddSolution.setMnemonic(65);
        this.menuItemAddSolution.setAccelerator(KeyStroke.getKeyStroke(65, menuShortcutKey));
        this.menuFile.add(this.menuItemAddSolution);
        this.menuFile.addSeparator();
        this.menuItemExit = new JMenuItem(Internationalization._("main.exit"));
        this.menuItemExit.setMnemonic(88);
        this.menuFile.add(this.menuItemExit);
        JMenu menuView = new JMenu(Internationalization._("main.view"));
        menuView.setMnemonic(86);
        menuBar.add(menuView);
        this.menuItemTips = new JMenuItem(Internationalization._("main.tips"));
        this.menuItemTips.setMnemonic(84);
        this.menuItemTips.setAccelerator(KeyStroke.getKeyStroke(84, menuShortcutKey | 8));
        menuView.add(this.menuItemTips);
        this.menuItemScrambleQueue = new JMenuItem(Internationalization._("main.scramble_queue"));
        this.menuItemScrambleQueue.setMnemonic(81);
        this.menuItemScrambleQueue.setAccelerator(KeyStroke.getKeyStroke(81, menuShortcutKey | 8));
        menuView.add(this.menuItemScrambleQueue);
        this.menuItemHistory = new JMenuItem(Internationalization._("main.history"));
        this.menuItemHistory.setMnemonic(72);
        this.menuItemHistory.setAccelerator(KeyStroke.getKeyStroke(72, menuShortcutKey | 8));
        menuView.add(this.menuItemHistory);
        this.menuItemSessionSummary = new JMenuItem(Internationalization._("main.session_summary"));
        this.menuItemSessionSummary.setMnemonic(83);
        this.menuItemSessionSummary.setAccelerator(KeyStroke.getKeyStroke(83, menuShortcutKey | 8));
        menuView.add(this.menuItemSessionSummary);
        this.menuCategory = new JMenu(Internationalization._("main.category"));
        this.menuCategory.setMnemonic(67);
        menuBar.add(this.menuCategory);
        JMenu menuOptions = new JMenu(Internationalization._("main.options"));
        menuOptions.setMnemonic(79);
        menuBar.add(menuOptions);
        this.menuItemColorScheme = new JMenuItem(Internationalization._("main.color_scheme"));
        this.menuItemColorScheme.setMnemonic(67);
        this.menuItemColorScheme.setAccelerator(KeyStroke.getKeyStroke(75, menuShortcutKey | 8));
        menuOptions.add(this.menuItemColorScheme);
        this.menuItemInspectionTime = new JCheckBoxMenuItem(Internationalization._("main.inspection_time"));
        this.menuItemInspectionTime.setMnemonic(73);
        this.menuItemInspectionTime.setAccelerator(KeyStroke.getKeyStroke(73, menuShortcutKey | 8));
        menuOptions.add(this.menuItemInspectionTime);
        JMenu menuTimerTrigger = new JMenu(Internationalization._("main.timer_trigger"));
        menuTimerTrigger.setMnemonic(84);
        menuOptions.add(menuTimerTrigger);
        ButtonGroup timerTriggerGroup = new ButtonGroup();
        this.menuItemCtrlKeys = new JRadioButtonMenuItem(Internationalization._("main.ctrl_keys"));
        this.menuItemCtrlKeys.setMnemonic(67);
        this.menuItemCtrlKeys.setAccelerator(KeyStroke.getKeyStroke(67, menuShortcutKey));
        menuTimerTrigger.add(this.menuItemCtrlKeys);
        timerTriggerGroup.add(this.menuItemCtrlKeys);
        this.menuItemSpaceKey = new JRadioButtonMenuItem(Internationalization._("main.space_key"));
        this.menuItemSpaceKey.setMnemonic(83);
        this.menuItemSpaceKey.setAccelerator(KeyStroke.getKeyStroke(32, menuShortcutKey));
        menuTimerTrigger.add(this.menuItemSpaceKey);
        timerTriggerGroup.add(this.menuItemSpaceKey);
        this.menuItemStackmatTimer = new JRadioButtonMenuItem(Internationalization._("main.stackmat_timer"));
        this.menuItemStackmatTimer.setMnemonic(84);
        this.menuItemStackmatTimer.setAccelerator(KeyStroke.getKeyStroke(84, menuShortcutKey));
        menuTimerTrigger.add(this.menuItemStackmatTimer);
        timerTriggerGroup.add(this.menuItemStackmatTimer);
        this.stackmatTimerInputDevice = new JMenu(Internationalization._("main.stackmat_timer_input_device"));
        menuTimerTrigger.setMnemonic(83);
        menuOptions.add(this.stackmatTimerInputDevice);
        this.stackmatTimerInputDeviceGroup = new ButtonGroup();
        JMenu menuHelp = new JMenu(Internationalization._("main.help"));
        menuHelp.setMnemonic(72);
        menuBar.add(menuHelp);
        this.menuItemAbout = new JMenuItem(Internationalization._("main.about"));
        this.menuItemAbout.setMnemonic(65);
        menuHelp.add(this.menuItemAbout);
        JPanel panelMain = new JPanel(new MigLayout("fill, hidemode 1, insets 2 3 2 3", "[fill]", "[pref!][pref!][fill, growprio 200][pref!]"));
        this.add(panelMain);
        this.labelMessage = new JLabel();
        this.labelMessage.setPreferredSize(new Dimension());
        this.labelMessage.setOpaque(true);
        this.labelMessage.setHorizontalAlignment(0);
        this.labelMessage.setForeground(new Color(255, 255, 255));
        this.labelMessage.setVisible(false);
        panelMain.add((Component)this.labelMessage, "wrap");
        this.scramblePanel = new ScramblePanel(this.scrambleManager);
        panelMain.add((Component)this.scramblePanel, "wrap");
        this.timerPanel = new TimerPanel(this.timerManager);
        panelMain.add((Component)this.timerPanel, "wrap");
        this.timesScrollPane = new TimesScrollPane(this.solutionManager, this.sessionManager);
        this.timesScrollPane.setBorder(BorderFactory.createTitledBorder(Internationalization._("main.times")));
        this.timesScrollPane.setVerticalScrollBarPolicy(22);
        panelMain.add((Component)this.timesScrollPane, "w 30%, growy, gapright 0, split 3");
        this.statisticsPanel = new StatisticsPanel(this.sessionManager);
        this.statisticsPanel.setBorder(BorderFactory.createTitledBorder(Internationalization._("main.session_statistics")));
        panelMain.add((Component)this.statisticsPanel, "w 40%, growy, gapright 0");
        this.scrambleViewerPanel = new ScrambleViewerPanel(this.puzzleProvider, this.colorManager, this.scramblerProvider, this.scrambleManager);
        this.scrambleViewerPanel.setBorder(BorderFactory.createTitledBorder(Internationalization._("main.scramble")));
        panelMain.add((Component)this.scrambleViewerPanel, "w 30%, growy");
        this.scramblePanel.setScrambleViewerPanel(this.scrambleViewerPanel);
        Image icon = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/com/puzzletimer/resources/icon.png"));
        this.tipsFrame = new TipsFrame(this.puzzleProvider, this.tipProvider, this.scramblerProvider, this.categoryManager, this.scrambleManager);
        this.tipsFrame.setLocationRelativeTo(null);
        this.tipsFrame.setIconImage(icon);
        this.scrambleQueueFrame = new ScrambleQueueFrame(this.scrambleParserProvider, this.scramblerProvider, this.categoryManager, this.scrambleManager);
        this.scrambleQueueFrame.setLocationRelativeTo(null);
        this.scrambleQueueFrame.setIconImage(icon);
        this.historyFrame = new HistoryFrame(this.scramblerProvider, this.scrambleParserProvider, this.categoryManager, this.scrambleManager, this.solutionManager, this.sessionManager);
        this.historyFrame.setLocationRelativeTo(null);
        this.historyFrame.setIconImage(icon);
        this.sessionSummaryFrame = new SessionSummaryFrame(this.categoryManager, this.sessionManager);
        this.sessionSummaryFrame.setLocationRelativeTo(null);
        this.sessionSummaryFrame.setIconImage(icon);
        this.categoryManagerDialog = new CategoryManagerFrame(this.puzzleProvider, this.scramblerProvider, this.categoryManager, this.tipProvider);
        this.categoryManagerDialog.setLocationRelativeTo(null);
        this.categoryManagerDialog.setIconImage(icon);
        this.colorSchemeFrame = new ColorSchemeFrame(this.puzzleProvider, this.colorManager);
        this.colorSchemeFrame.setLocationRelativeTo(null);
        this.colorSchemeFrame.setIconImage(icon);
    }

    private class ScramblePanel
    extends JPanel {
        private ScrambleViewerPanel scrambleViewerPanel;

        public ScramblePanel(ScrambleManager scrambleManager) {
            this.createComponents();
            scrambleManager.addListener(new ScrambleManager.Listener(){

                @Override
                public void scrambleChanged(Scramble scramble) {
                    ScramblePanel.this.setScramble(scramble);
                }
            });
        }

        public void setScrambleViewerPanel(ScrambleViewerPanel scrambleViewerPanel) {
            this.scrambleViewerPanel = scrambleViewerPanel;
        }

        private void createComponents() {
            this.setLayout(new WrapLayout(10, 3));
        }

        private void setScramble(final Scramble scramble) {
            this.removeAll();
            final JLabel[] labels = new JLabel[scramble.getSequence().length];
            int i = 0;
            while (i < labels.length) {
                labels[i] = new JLabel(scramble.getSequence()[i]);
                labels[i].setFont(new Font("Arial", 0, 18));
                labels[i].setCursor(new Cursor(12));
                final int index = i;
                labels[i].addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        int i = 0;
                        while (i < labels.length) {
                            labels[i].setForeground(i <= index ? Color.BLACK : Color.LIGHT_GRAY);
                            ++i;
                        }
                        ScramblePanel.this.scrambleViewerPanel.setScramble(new Scramble(scramble.getScramblerId(), Arrays.copyOf(scramble.getSequence(), index + 1)));
                    }
                });
                this.add((Component)labels[i], "gap 10");
                ++i;
            }
            this.revalidate();
            this.repaint();
        }
    }

    private class ScrambleViewerPanel
    extends JPanel {
        private PuzzleProvider puzzleProvider;
        private ColorManager colorManager;
        private ScramblerProvider scramblerProvider;
        private Panel3D panel3D;

        public ScrambleViewerPanel(PuzzleProvider puzzleProvider, ColorManager colorManager, ScramblerProvider scramblerProvider, ScrambleManager scrambleManager) {
            this.puzzleProvider = puzzleProvider;
            this.colorManager = colorManager;
            this.scramblerProvider = scramblerProvider;
            this.createComponents();
            scrambleManager.addListener(new ScrambleManager.Listener(){

                @Override
                public void scrambleChanged(Scramble scramble) {
                    ScrambleViewerPanel.this.setScramble(scramble);
                }
            });
        }

        private void createComponents() {
            this.setLayout(new MigLayout("fill", "0[fill]0", "0[fill]0"));
            this.panel3D = new Panel3D();
            this.panel3D.setFocusable(false);
            this.add(this.panel3D);
        }

        public void setScramble(Scramble scramble) {
            Scrambler scrambler = this.scramblerProvider.get(scramble.getScramblerId());
            Puzzle puzzle = this.puzzleProvider.get(scrambler.getScramblerInfo().getPuzzleId());
            ColorScheme colorScheme = this.colorManager.getColorScheme(puzzle.getPuzzleInfo().getPuzzleId());
            this.panel3D.setMesh(puzzle.getScrambledPuzzleMesh(colorScheme, scramble.getSequence()));
        }
    }

    private class StatisticsPanel
    extends JPanel {
        private JLabel labelMean;
        private JLabel labelAverage;
        private JLabel labelBestTime;
        private JLabel labelMedian;
        private JLabel labelWorstTime;
        private JLabel labelStandardDeviation;
        private JLabel labelMeanOf3;
        private JLabel labelBestMeanOf3;
        private JLabel labelAverageOf5;
        private JLabel labelBestAverageOf5;
        private JLabel labelAverageOf12;
        private JLabel labelBestAverageOf12;

        private StatisticsPanel(SessionManager sessionManager) {
            this.createComponents();
            final JLabel[] labels = new JLabel[]{this.labelMean, this.labelAverage, this.labelBestTime, this.labelMedian, this.labelWorstTime, this.labelStandardDeviation, this.labelMeanOf3, this.labelBestMeanOf3, this.labelAverageOf5, this.labelBestAverageOf5, this.labelAverageOf12, this.labelBestAverageOf12};
            final StatisticalMeasure[] measures = new StatisticalMeasure[]{new Mean(1, Integer.MAX_VALUE), new Average(3, Integer.MAX_VALUE), new Best(1, Integer.MAX_VALUE), new Percentile(1, Integer.MAX_VALUE, 0.5), new Worst(1, Integer.MAX_VALUE), new StandardDeviation(1, Integer.MAX_VALUE), new Mean(3, 3), new BestMean(3, Integer.MAX_VALUE), new Average(5, 5), new BestAverage(5, Integer.MAX_VALUE), new Average(12, 12), new BestAverage(12, Integer.MAX_VALUE)};
            sessionManager.addListener(new SessionManager.Listener(){

                @Override
                public void solutionsUpdated(Solution[] solutions) {
                    int i = 0;
                    while (i < labels.length) {
                        if (solutions.length >= measures[i].getMinimumWindowSize()) {
                            int size = Math.min(solutions.length, measures[i].getMaximumWindowSize());
                            Solution[] window = new Solution[size];
                            int j = 0;
                            while (j < size) {
                                window[j] = solutions[j];
                                ++j;
                            }
                            measures[i].setSolutions(window);
                            labels[i].setText(SolutionUtils.formatMinutes(measures[i].getValue()));
                        } else {
                            labels[i].setText("XX:XX.XX");
                        }
                        ++i;
                    }
                }
            });
        }

        private void createComponents() {
            this.setLayout(new MigLayout("center", "[pref!,right]8[pref!]", "1[pref!]1[pref!]1[pref!]1[pref!]1[pref!]1[pref!]6[pref!]1[pref!]6[pref!]1[pref!]6[pref!]1[pref!]1"));
            JLabel labelMeanDescription = new JLabel(Internationalization._("statistics.mean"));
            labelMeanDescription.setFont(new Font("Tahoma", 1, 11));
            this.add(labelMeanDescription);
            this.labelMean = new JLabel("XX:XX.XX");
            this.add((Component)this.labelMean, "wrap");
            JLabel labelAverageDescription = new JLabel(Internationalization._("statistics.average"));
            labelAverageDescription.setFont(new Font("Tahoma", 1, 11));
            this.add(labelAverageDescription);
            this.labelAverage = new JLabel("XX:XX.XX");
            this.add((Component)this.labelAverage, "wrap");
            JLabel labelBestTimeDescription = new JLabel(Internationalization._("statistics.best_time"));
            labelBestTimeDescription.setFont(new Font("Tahoma", 1, 11));
            this.add(labelBestTimeDescription);
            this.labelBestTime = new JLabel("XX:XX.XX");
            this.add((Component)this.labelBestTime, "wrap");
            JLabel labelMedianDescription = new JLabel(Internationalization._("statistics.median"));
            labelMedianDescription.setFont(new Font("Tahoma", 1, 11));
            this.add(labelMedianDescription);
            this.labelMedian = new JLabel("XX:XX.XX");
            this.add((Component)this.labelMedian, "wrap");
            JLabel labelWorstTimeDescription = new JLabel(Internationalization._("statistics.worst_time"));
            labelWorstTimeDescription.setFont(new Font("Tahoma", 1, 11));
            this.add(labelWorstTimeDescription);
            this.labelWorstTime = new JLabel("XX:XX.XX");
            this.add((Component)this.labelWorstTime, "wrap");
            JLabel labelStandardDeviationDescription = new JLabel(Internationalization._("statistics.standard_deviation"));
            labelStandardDeviationDescription.setFont(new Font("Tahoma", 1, 11));
            this.add(labelStandardDeviationDescription);
            this.labelStandardDeviation = new JLabel("XX:XX.XX");
            this.add((Component)this.labelStandardDeviation, "wrap");
            JLabel labelMeanOf3Description = new JLabel(Internationalization._("statistics.mean_of_3"));
            labelMeanOf3Description.setFont(new Font("Tahoma", 1, 11));
            this.add(labelMeanOf3Description);
            this.labelMeanOf3 = new JLabel("XX:XX.XX");
            this.add((Component)this.labelMeanOf3, "wrap");
            JLabel labelBestMeanOf3Description = new JLabel(Internationalization._("statistics.best_mean_of_3"));
            labelBestMeanOf3Description.setFont(new Font("Tahoma", 1, 11));
            this.add(labelBestMeanOf3Description);
            this.labelBestMeanOf3 = new JLabel("XX:XX.XX");
            this.add((Component)this.labelBestMeanOf3, "wrap");
            JLabel labelAverageOf5Description = new JLabel(Internationalization._("statistics.average_of_5"));
            labelAverageOf5Description.setFont(new Font("Tahoma", 1, 11));
            this.add(labelAverageOf5Description);
            this.labelAverageOf5 = new JLabel("XX:XX.XX");
            this.add((Component)this.labelAverageOf5, "wrap");
            JLabel labelBestAverageOf5Description = new JLabel(Internationalization._("statistics.best_average_of_5"));
            labelBestAverageOf5Description.setFont(new Font("Tahoma", 1, 11));
            this.add(labelBestAverageOf5Description);
            this.labelBestAverageOf5 = new JLabel("XX:XX.XX");
            this.add((Component)this.labelBestAverageOf5, "wrap");
            JLabel labelAverageOf12Description = new JLabel(Internationalization._("statistics.average_of_12"));
            labelAverageOf12Description.setFont(new Font("Tahoma", 1, 11));
            this.add(labelAverageOf12Description);
            this.labelAverageOf12 = new JLabel("XX:XX.XX");
            this.add((Component)this.labelAverageOf12, "wrap");
            JLabel labelBestAverageOf12Description = new JLabel(Internationalization._("statistics.best_average_of_12"));
            labelBestAverageOf12Description.setFont(new Font("Tahoma", 1, 11));
            this.add(labelBestAverageOf12Description);
            this.labelBestAverageOf12 = new JLabel("XX:XX.XX");
            this.add((Component)this.labelBestAverageOf12, "wrap");
        }
    }

    private class TimerPanel
    extends JPanel {
        private HandImage leftHand;
        private TimeLabel timeLabel;
        private HandImage rightHand;

        public TimerPanel(TimerManager timerManager) {
            this.createComponents();
            timerManager.addListener(new TimerManager.Listener(){

                @Override
                public void timerReset() {
                    TimerPanel.this.timeLabel.setForeground(Color.BLACK);
                    TimerPanel.this.timeLabel.setText(SolutionUtils.formatMinutes(0L));
                }

                @Override
                public void leftHandPressed() {
                    TimerPanel.this.leftHand.setPressed(true);
                }

                @Override
                public void leftHandReleased() {
                    TimerPanel.this.leftHand.setPressed(false);
                }

                @Override
                public void rightHandPressed() {
                    TimerPanel.this.rightHand.setPressed(true);
                }

                @Override
                public void rightHandReleased() {
                    TimerPanel.this.rightHand.setPressed(false);
                }

                @Override
                public void inspectionRunning(long remainingTime) {
                    Color color;
                    Color startColor = Color.BLACK;
                    Color endColor = new Color(212, 17, 17);
                    if (remainingTime > 7000L) {
                        color = startColor;
                    } else if (remainingTime > 0L) {
                        double x = (double)remainingTime / 7000.0;
                        color = new Color((int)(x * (double)startColor.getRed() + (1.0 - x) * (double)endColor.getRed()), (int)(x * (double)startColor.getGreen() + (1.0 - x) * (double)endColor.getGreen()), (int)(x * (double)startColor.getBlue() + (1.0 - x) * (double)endColor.getBlue()));
                    } else {
                        color = endColor;
                        remainingTime = 0L;
                    }
                    TimerPanel.this.timeLabel.setForeground(color);
                    TimerPanel.this.timeLabel.setText(Long.toString((long)Math.ceil((double)remainingTime / 1000.0)));
                }

                @Override
                public void solutionRunning(Timing timing) {
                    TimerPanel.this.timeLabel.setForeground(Color.BLACK);
                    TimerPanel.this.timeLabel.setText(SolutionUtils.formatMinutes(timing.getElapsedTime()));
                }

                @Override
                public void solutionFinished(Timing timing, String penalty) {
                    TimerPanel.this.timeLabel.setForeground(Color.BLACK);
                    TimerPanel.this.timeLabel.setText(SolutionUtils.formatMinutes(timing.getElapsedTime()));
                }
            });
        }

        private void createComponents() {
            this.setLayout(new MigLayout("fill", "2%[19%]1%[56%]1%[19%]2%"));
            this.leftHand = new HandImage(false);
            this.add((Component)this.leftHand, "grow");
            this.timeLabel = new TimeLabel("00:00.00");
            this.timeLabel.setFont(new Font("Arial", 1, 108));
            this.add((Component)this.timeLabel, "grow");
            this.rightHand = new HandImage(true);
            this.add((Component)this.rightHand, "grow");
        }
    }

    private class TimesScrollPane
    extends JScrollPane {
        private SolutionManager solutionManager;
        private JPanel panel;

        public TimesScrollPane(SolutionManager solutionManager, SessionManager sessionManager) {
            this.solutionManager = solutionManager;
            this.createComponents();
            sessionManager.addListener(new SessionManager.Listener(){

                @Override
                public void solutionsUpdated(Solution[] solutions) {
                    TimesScrollPane.this.setSolutions(solutions);
                }
            });
        }

        private void createComponents() {
            this.setPreferredSize(new Dimension(0, 0));
            this.panel = new JPanel(new MigLayout("center", "0[right]8[pref!]16[pref!]8[pref!]16[pref!]0", ""));
        }

        private void setSolutions(Solution[] solutions) {
            this.panel.removeAll();
            int i = 0;
            while (i < solutions.length) {
                final Solution solution = solutions[i];
                JLabel labelIndex = new JLabel(String.valueOf(Integer.toString(solutions.length - i)) + ".");
                labelIndex.setFont(new Font("Tahoma", 1, 13));
                this.panel.add(labelIndex);
                JLabel labelTime = new JLabel(SolutionUtils.formatMinutes(solutions[i].getTiming().getElapsedTime()));
                labelTime.setFont(new Font("Tahoma", 0, 13));
                this.panel.add(labelTime);
                JLabel labelPlus2 = new JLabel("+2");
                labelPlus2.setFont(new Font("Tahoma", 0, 13));
                if (!solution.getPenalty().equals("+2")) {
                    labelPlus2.setForeground(Color.LIGHT_GRAY);
                }
                labelPlus2.setCursor(new Cursor(12));
                labelPlus2.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (!solution.getPenalty().equals("+2")) {
                            TimesScrollPane.this.solutionManager.updateSolution(solution.setPenalty("+2"));
                        } else if (solution.getPenalty().equals("+2")) {
                            TimesScrollPane.this.solutionManager.updateSolution(solution.setPenalty(""));
                        }
                    }
                });
                this.panel.add(labelPlus2);
                JLabel labelDNF = new JLabel("DNF");
                labelDNF.setFont(new Font("Tahoma", 0, 13));
                if (!solution.getPenalty().equals("DNF")) {
                    labelDNF.setForeground(Color.LIGHT_GRAY);
                }
                labelDNF.setCursor(new Cursor(12));
                labelDNF.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (!solution.getPenalty().equals("DNF")) {
                            TimesScrollPane.this.solutionManager.updateSolution(solution.setPenalty("DNF"));
                        } else if (solution.getPenalty().equals("DNF")) {
                            TimesScrollPane.this.solutionManager.updateSolution(solution.setPenalty(""));
                        }
                    }
                });
                this.panel.add(labelDNF);
                JLabel labelX = new JLabel();
                labelX.setIcon(new ImageIcon(this.getClass().getResource("/com/puzzletimer/resources/x.png")));
                labelX.setCursor(new Cursor(12));
                labelX.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        TimesScrollPane.this.solutionManager.removeSolution(solution);
                    }
                });
                this.panel.add((Component)labelX, "wrap");
                ++i;
            }
            this.setViewportView(this.panel);
        }
    }
}

