/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.gui;

import com.puzzletimer.Internationalization;
import com.puzzletimer.models.Category;
import com.puzzletimer.models.Scramble;
import com.puzzletimer.parsers.ScrambleParser;
import com.puzzletimer.parsers.ScrambleParserProvider;
import com.puzzletimer.scramblers.Scrambler;
import com.puzzletimer.scramblers.ScramblerProvider;
import com.puzzletimer.state.CategoryManager;
import com.puzzletimer.state.ScrambleManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Scanner;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;

public class ScrambleQueueFrame
extends JFrame {
    private JTable table;
    private JButton buttonUp;
    private JButton buttonDown;
    private JButton buttonRemove;
    private JButton buttonImportFromFile;
    private JButton buttonExport;
    private JComboBox comboBoxScrambler;
    private JSpinner spinnerNumberOfScrambles;
    private JButton buttonImportFromScrambler;
    private JButton buttonOk;

    public ScrambleQueueFrame(final ScrambleParserProvider scrambleParserProvider, final ScramblerProvider scramblerProvider, final CategoryManager categoryManager, final ScrambleManager scrambleManager) {
        this.setMinimumSize(new Dimension(640, 480));
        this.setPreferredSize(this.getMinimumSize());
        this.createComponents();
        categoryManager.addListener(new CategoryManager.Listener(){

            @Override
            public void categoriesUpdated(Category[] categories, Category currentCategory) {
                ScrambleQueueFrame.this.setTitle(String.format(Internationalization._("scramble_queue.scramble_queue-category"), currentCategory.getDescription()));
                ScrambleQueueFrame.this.comboBoxScrambler.removeAllItems();
                Scrambler currentScrambler = scramblerProvider.get(categoryManager.getCurrentCategory().getScramblerId());
                String puzzleId = currentScrambler.getScramblerInfo().getPuzzleId();
                Scrambler[] scramblerArray = scramblerProvider.getAll();
                int n = scramblerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Scrambler scrambler = scramblerArray[n2];
                    if (scrambler.getScramblerInfo().getPuzzleId().equals(puzzleId)) {
                        ScrambleQueueFrame.this.comboBoxScrambler.addItem(scrambler);
                    }
                    ++n2;
                }
            }
        });
        categoryManager.notifyListeners();
        scrambleManager.addListener(new ScrambleManager.Listener(){

            @Override
            public void scrambleQueueUpdated(Scramble[] queue) {
                ScrambleQueueFrame.this.updateTable(queue);
                ScrambleQueueFrame.this.updateButtons(ScrambleQueueFrame.this.table);
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                ScrambleQueueFrame.this.updateButtons(ScrambleQueueFrame.this.table);
            }
        });
        this.buttonUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JTable table = ScrambleQueueFrame.this.table;
                int[] selectedRows = table.getSelectedRows();
                scrambleManager.moveScramblesUp(selectedRows);
                table.removeRowSelectionInterval(0, selectedRows.length - 1);
                int[] nArray = selectedRows;
                int n = selectedRows.length;
                int n2 = 0;
                while (n2 < n) {
                    int selectedRow = nArray[n2];
                    table.addRowSelectionInterval(selectedRow - 1, selectedRow - 1);
                    ++n2;
                }
                ScrambleQueueFrame.this.buttonUp.requestFocusInWindow();
            }
        });
        this.buttonDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JTable table = ScrambleQueueFrame.this.table;
                int[] selectedRows = table.getSelectedRows();
                scrambleManager.moveScramblesDown(selectedRows);
                table.removeRowSelectionInterval(0, selectedRows.length - 1);
                int[] nArray = selectedRows;
                int n = selectedRows.length;
                int n2 = 0;
                while (n2 < n) {
                    int selectedRow = nArray[n2];
                    table.addRowSelectionInterval(selectedRow + 1, selectedRow + 1);
                    ++n2;
                }
                ScrambleQueueFrame.this.buttonDown.requestFocusInWindow();
            }
        });
        this.buttonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                scrambleManager.removeScrambles(ScrambleQueueFrame.this.table.getSelectedRows());
                ScrambleQueueFrame.this.buttonRemove.requestFocusInWindow();
            }
        });
        this.buttonImportFromFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Scramble[] scrambles;
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setFileFilter(new FileNameExtensionFilter(Internationalization._("scramble_queue.scramble_file_description"), "txt"));
                int action = fileChooser.showOpenDialog(ScrambleQueueFrame.this);
                if (action != 0) {
                    return;
                }
                Category category = categoryManager.getCurrentCategory();
                Scrambler scrambler = scramblerProvider.get(category.getScramblerId());
                String puzzleId = scrambler.getScramblerInfo().getPuzzleId();
                ScrambleParser scrambleParser = scrambleParserProvider.get(puzzleId);
                try {
                    scrambles = ScrambleQueueFrame.this.loadScramblesFromFile(fileChooser.getSelectedFile(), String.valueOf(puzzleId) + "-IMPORTER", scrambleParser);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(ScrambleQueueFrame.this, String.format(Internationalization._("scramble_queue.file_opening_error"), fileChooser.getSelectedFile().getAbsolutePath()), Internationalization._("scramble_queue.error"), 0);
                    return;
                }
                scrambleManager.addScrambles(scrambles);
            }
        });
        this.buttonExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Scramble[] selectedScrambles;
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setSelectedFile(new File(Internationalization._("scramble_queue.default_file_name")));
                fileChooser.setFileFilter(new FileNameExtensionFilter(Internationalization._("scramble_queue.scramble_file_description"), "txt"));
                int action = fileChooser.showSaveDialog(ScrambleQueueFrame.this);
                if (action != 0) {
                    return;
                }
                Scramble[] scrambles = scrambleManager.getQueue();
                int[] selectedRows = ScrambleQueueFrame.this.table.getSelectedRows();
                if (selectedRows.length <= 0) {
                    selectedScrambles = scrambles;
                } else {
                    selectedScrambles = new Scramble[selectedRows.length];
                    int i = 0;
                    while (i < selectedScrambles.length) {
                        selectedScrambles[i] = scrambles[selectedRows[i]];
                        ++i;
                    }
                }
                try {
                    ScrambleQueueFrame.this.saveScramblesToFile(selectedScrambles, fileChooser.getSelectedFile());
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(ScrambleQueueFrame.this, String.format(Internationalization._("scramble_queue.file_opening_error"), fileChooser.getSelectedFile().getAbsolutePath()), Internationalization._("scramble_queue.error"), 0);
                    return;
                }
            }
        });
        this.buttonImportFromScrambler.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Scrambler scrambler = (Scrambler)ScrambleQueueFrame.this.comboBoxScrambler.getSelectedItem();
                Scramble[] scrambles = new Scramble[((Integer)ScrambleQueueFrame.this.spinnerNumberOfScrambles.getValue()).intValue()];
                int i = 0;
                while (i < scrambles.length) {
                    scrambles[i] = scrambler.getNextScramble();
                    ++i;
                }
                scrambleManager.addScrambles(scrambles);
            }
        });
        this.setDefaultCloseOperation(1);
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ScrambleQueueFrame.this.setVisible(false);
            }
        });
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ScrambleQueueFrame.this.setVisible(false);
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    private void createComponents() {
        this.setLayout(new MigLayout("fill", "[fill][pref!]", "[pref!][]12[pref!][pref!]16[pref!]"));
        this.add((Component)new JLabel(Internationalization._("scramble_queue.queue")), "span, wrap");
        this.table = new JTable();
        this.table.setShowVerticalLines(false);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.table.setFillsViewportHeight(true);
        this.add((Component)scrollPane, "grow");
        this.buttonUp = new JButton(Internationalization._("scramble_queue.up"));
        this.buttonUp.setEnabled(false);
        this.add((Component)this.buttonUp, "top, growx, split 5, flowy");
        this.buttonDown = new JButton(Internationalization._("scramble_queue.down"));
        this.buttonDown.setEnabled(false);
        this.add((Component)this.buttonDown, "top, growx");
        this.buttonRemove = new JButton(Internationalization._("scramble_queue.remove"));
        this.buttonRemove.setEnabled(false);
        this.add((Component)this.buttonRemove, "top, growx");
        this.buttonImportFromFile = new JButton(Internationalization._("scramble_queue.import_from_file"));
        this.add((Component)this.buttonImportFromFile, "gaptop 20, top, growx");
        this.buttonExport = new JButton(Internationalization._("scramble_queue.export_to_file"));
        this.buttonExport.setEnabled(false);
        this.add((Component)this.buttonExport, "top, growx, wrap");
        this.add((Component)new JLabel(Internationalization._("scramble_queue.import_from_scrambler")), "span, wrap");
        this.comboBoxScrambler = new JComboBox();
        this.add((Component)this.comboBoxScrambler, "growx, span, split 3");
        this.spinnerNumberOfScrambles = new JSpinner(new SpinnerNumberModel(12, 1, 1000, 1));
        this.add((Component)this.spinnerNumberOfScrambles, "");
        this.buttonImportFromScrambler = new JButton(Internationalization._("scramble_queue.import"));
        this.add((Component)this.buttonImportFromScrambler, "wrap");
        this.buttonOk = new JButton(Internationalization._("scramble_queue.ok"));
        this.add((Component)this.buttonOk, "tag ok, span");
    }

    private void updateTable(Scramble[] queue) {
        DefaultTableModel tableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        tableModel.addColumn(Internationalization._("scramble_queue.#"));
        tableModel.addColumn(Internationalization._("scramble_queue.scramble"));
        this.table.setModel(tableModel);
        this.table.setAutoResizeMode(3);
        TableColumn indexColumn = this.table.getColumnModel().getColumn(0);
        indexColumn.setPreferredWidth(50);
        TableColumn scrambleColumn = this.table.getColumnModel().getColumn(1);
        scrambleColumn.setPreferredWidth(1000);
        int i = 0;
        while (i < queue.length) {
            tableModel.addRow(new Object[]{i + 1, queue[i].getRawSequence()});
            ++i;
        }
    }

    private void updateButtons(JTable table) {
        int[] selectedRows = table.getSelectedRows();
        int nRows = table.getRowCount();
        this.buttonUp.setEnabled(selectedRows.length > 0 && selectedRows[0] != 0);
        this.buttonDown.setEnabled(selectedRows.length > 0 && selectedRows[selectedRows.length - 1] != nRows - 1);
        this.buttonRemove.setEnabled(selectedRows.length > 0);
        this.buttonExport.setEnabled(nRows > 0);
    }

    private Scramble[] loadScramblesFromFile(File file, String scramblerId, ScrambleParser scrambleParser) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        Scanner scanner = new Scanner((InputStream)fileInputStream, "UTF-8");
        ArrayList<Scramble> scrambles = new ArrayList<Scramble>();
        while (scanner.hasNextLine()) {
            scrambles.add(new Scramble(scramblerId, scrambleParser.parse(scanner.nextLine().trim())));
        }
        scanner.close();
        Scramble[] scrambleArray = new Scramble[scrambles.size()];
        scrambles.toArray(scrambleArray);
        return scrambleArray;
    }

    private void saveScramblesToFile(Scramble[] scrambles, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
        Scramble[] scrambleArray = scrambles;
        int n = scrambles.length;
        int n2 = 0;
        while (n2 < n) {
            Scramble scramble = scrambleArray[n2];
            writer.append(scramble.getRawSequence());
            writer.append("\r\n");
            ++n2;
        }
        writer.close();
    }
}

