/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.gui;

import com.puzzletimer.Internationalization;
import com.puzzletimer.models.Category;
import com.puzzletimer.models.Solution;
import com.puzzletimer.state.CategoryManager;
import com.puzzletimer.state.SessionManager;
import com.puzzletimer.statistics.Average;
import com.puzzletimer.statistics.Best;
import com.puzzletimer.statistics.BestAverage;
import com.puzzletimer.statistics.Mean;
import com.puzzletimer.statistics.Percentile;
import com.puzzletimer.statistics.StandardDeviation;
import com.puzzletimer.statistics.StatisticalMeasure;
import com.puzzletimer.statistics.Worst;
import com.puzzletimer.util.SolutionUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;

public class SessionSummaryFrame
extends JFrame {
    private JTextArea textAreaSummary;
    private JButton buttonCopyToClipboard;
    private JButton buttonOk;

    public SessionSummaryFrame(final CategoryManager categoryManager, SessionManager sessionManager) {
        this.setMinimumSize(new Dimension(640, 480));
        this.setPreferredSize(this.getMinimumSize());
        this.createComponents();
        categoryManager.addListener(new CategoryManager.Listener(){

            @Override
            public void categoriesUpdated(Category[] categories, Category currentCategory) {
                SessionSummaryFrame.this.setTitle(String.format(Internationalization._("session_summary.session_sumary_category"), currentCategory.getDescription()));
            }
        });
        categoryManager.notifyListeners();
        sessionManager.addListener(new SessionManager.Listener(){

            @Override
            public void solutionsUpdated(Solution[] solutions) {
                SessionSummaryFrame.this.updateSummary(categoryManager.getCurrentCategory(), solutions);
            }
        });
        this.buttonCopyToClipboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                StringSelection contents = new StringSelection(SessionSummaryFrame.this.textAreaSummary.getText());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(contents, contents);
            }
        });
        this.setDefaultCloseOperation(1);
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SessionSummaryFrame.this.setVisible(false);
            }
        });
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SessionSummaryFrame.this.setVisible(false);
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    private void createComponents() {
        this.setLayout(new MigLayout("fill", "", "[pref!][][pref!]16[pref!]"));
        this.add((Component)new JLabel(Internationalization._("session_summary.summary")), "wrap");
        this.textAreaSummary = new JTextArea();
        JScrollPane scrollPane = new JScrollPane(this.textAreaSummary);
        this.add((Component)scrollPane, "grow, wrap");
        this.buttonCopyToClipboard = new JButton(Internationalization._("session_summary.copy_to_clipboard"));
        this.add((Component)this.buttonCopyToClipboard, "width 150, right, wrap");
        this.buttonOk = new JButton(Internationalization._("session_summary.ok"));
        this.add((Component)this.buttonOk, "tag ok");
    }

    private void updateSummary(Category currentCategory, Solution[] solutions) {
        StringBuilder summary = new StringBuilder();
        if (solutions.length >= 1) {
            summary.append(currentCategory.getDescription());
            summary.append("\n");
            Date start = solutions[solutions.length - 1].getTiming().getStart();
            Date end = solutions[0].getTiming().getEnd();
            DateFormat dateTimeFormat = DateFormat.getDateTimeInstance(2, 2);
            DateFormat timeFormat = DateFormat.getTimeInstance(2);
            summary.append(String.valueOf(dateTimeFormat.format(start)) + " - " + timeFormat.format(end));
            summary.append("\n");
            summary.append("\n");
            String[] labels = new String[]{Internationalization._("session_summary.mean"), Internationalization._("session_summary.average"), Internationalization._("session_summary.best_time"), Internationalization._("session_summary.median"), Internationalization._("session_summary.worst_time"), Internationalization._("session_summary.standard_deviation")};
            StatisticalMeasure[] statistics = new StatisticalMeasure[]{new Mean(1, Integer.MAX_VALUE), new Average(3, Integer.MAX_VALUE), new Best(1, Integer.MAX_VALUE), new Percentile(1, Integer.MAX_VALUE, 0.5), new Worst(1, Integer.MAX_VALUE), new StandardDeviation(1, Integer.MAX_VALUE)};
            int maxLabelLength = 0;
            int i = 0;
            while (i < labels.length) {
                if (labels[i].length() > maxLabelLength) {
                    maxLabelLength = labels[i].length();
                }
                ++i;
            }
            int maxStringLength = 0;
            int i2 = 0;
            while (i2 < statistics.length) {
                if (solutions.length >= statistics[i2].getMinimumWindowSize()) {
                    statistics[i2].setSolutions(solutions);
                    String s = SolutionUtils.format(statistics[i2].getValue());
                    if (s.length() > maxStringLength) {
                        maxStringLength = s.length();
                    }
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < labels.length) {
                if (solutions.length >= statistics[i2].getMinimumWindowSize()) {
                    summary.append(String.format("%-" + maxLabelLength + "s %" + maxStringLength + "s", labels[i2], SolutionUtils.format(statistics[i2].getValue())));
                    summary.append("\n");
                }
                ++i2;
            }
            summary.append("\n");
        }
        String[] labels = new String[]{Internationalization._("session_summary.best_average_of_5"), Internationalization._("session_summary.best_average_of_12")};
        StatisticalMeasure[] statistics = new StatisticalMeasure[]{new BestAverage(5, Integer.MAX_VALUE), new BestAverage(12, Integer.MAX_VALUE)};
        int i = 0;
        while (i < statistics.length) {
            int windowSize = statistics[i].getMinimumWindowSize();
            if (solutions.length >= windowSize) {
                statistics[i].setSolutions(solutions);
                int windowPosition = statistics[i].getWindowPosition();
                summary.append(String.valueOf(labels[i]) + " " + SolutionUtils.format(statistics[i].getValue()));
                summary.append("\n");
                summary.append(String.format("  %d-%d - ", solutions.length - windowPosition - windowSize + 1, solutions.length - windowPosition));
                int indexBest = 0;
                int indexWorst = 0;
                long[] times = new long[windowSize];
                int j = 0;
                while (j < windowSize) {
                    times[j] = SolutionUtils.realTime(solutions[windowPosition + j]);
                    if (times[j] < times[indexBest]) {
                        indexBest = j;
                    }
                    if (times[j] > times[indexWorst]) {
                        indexWorst = j;
                    }
                    ++j;
                }
                String sTimes = "";
                int j2 = windowSize - 1;
                while (j2 >= 0) {
                    sTimes = j2 == indexBest || j2 == indexWorst ? String.valueOf(sTimes) + "(" + SolutionUtils.format(times[j2]) + ") " : String.valueOf(sTimes) + SolutionUtils.format(times[j2]) + " ";
                    --j2;
                }
                summary.append(sTimes.trim());
                summary.append("\n");
                summary.append("\n");
            }
            ++i;
        }
        String[] sSolutions = new String[solutions.length];
        long[] realTimes = SolutionUtils.realTimes(solutions, false);
        int maxStringLength = 0;
        int i3 = 0;
        while (i3 < realTimes.length) {
            sSolutions[i3] = SolutionUtils.format(realTimes[i3]);
            if (sSolutions[i3].length() > maxStringLength) {
                maxStringLength = sSolutions[i3].length();
            }
            ++i3;
        }
        i3 = solutions.length - 1;
        while (i3 >= 0) {
            String indexFormat = "%" + ((int)Math.log10(solutions.length) + 1) + "d. ";
            summary.append(String.format(indexFormat, solutions.length - i3));
            String timeFormat = "%" + maxStringLength + "s  ";
            summary.append(String.format(timeFormat, sSolutions[i3]));
            summary.append(solutions[i3].getScramble().getRawSequence());
            summary.append("\n");
            --i3;
        }
        this.textAreaSummary.setText(summary.toString());
        this.textAreaSummary.setCaretPosition(0);
    }
}

