/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.gui;

import com.puzzletimer.Internationalization;
import com.puzzletimer.models.Solution;
import com.puzzletimer.models.Timing;
import com.puzzletimer.util.SolutionUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;

public class SolutionEditingDialog
extends JDialog {
    private JTextField textFieldStart;
    private JTextField textFieldTime;
    private JComboBox comboBoxPenalty;
    private JTextField textFieldScramble;
    private JButton buttonOk;
    private JButton buttonCancel;

    public SolutionEditingDialog(JFrame owner, boolean modal, final Solution solution, final SolutionEditingDialogListener listener) {
        super((Frame)owner, modal);
        this.setTitle(Internationalization._("solution_editing.solution_editor"));
        this.setMinimumSize(new Dimension(480, 200));
        this.setPreferredSize(this.getMinimumSize());
        this.createComponents();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
        this.textFieldStart.setText(dateFormat.format(solution.getTiming().getStart()));
        this.textFieldTime.setText(SolutionUtils.formatMinutes(solution.getTiming().getElapsedTime()));
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                SolutionEditingDialog.this.textFieldTime.setSelectionStart(0);
                SolutionEditingDialog.this.textFieldTime.setSelectionEnd(Integer.MAX_VALUE);
                SolutionEditingDialog.this.textFieldTime.requestFocusInWindow();
            }
        });
        this.comboBoxPenalty.addItem("");
        this.comboBoxPenalty.addItem("+2");
        this.comboBoxPenalty.addItem("DNF");
        this.comboBoxPenalty.setSelectedItem(solution.getPenalty());
        this.textFieldScramble.setText(solution.getScramble().getRawSequence());
        this.textFieldScramble.setCaretPosition(0);
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                long time = SolutionUtils.parseTime(SolutionEditingDialog.this.textFieldTime.getText());
                Timing timing = new Timing(solution.getTiming().getStart(), new Date(solution.getTiming().getStart().getTime() + time));
                String penalty = (String)SolutionEditingDialog.this.comboBoxPenalty.getSelectedItem();
                listener.solutionEdited(solution.setTiming(timing).setPenalty(penalty));
                SolutionEditingDialog.this.dispose();
            }
        });
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SolutionEditingDialog.this.dispose();
            }
        });
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SolutionEditingDialog.this.dispose();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    private void createComponents() {
        this.setLayout(new MigLayout("fill, wrap", "[pref!][fill]", "[pref!]8[pref!]8[pref!]8[pref!]16[bottom]"));
        this.add(new JLabel(Internationalization._("solution_editing.start")));
        this.textFieldStart = new JTextField();
        this.textFieldStart.setEditable(false);
        this.textFieldStart.setFocusable(false);
        this.add(this.textFieldStart);
        this.add(new JLabel(Internationalization._("solution_editing.time")));
        this.textFieldTime = new JTextField();
        this.add(this.textFieldTime);
        this.add(new JLabel(Internationalization._("solution_editing.penalty")));
        this.comboBoxPenalty = new JComboBox();
        this.add(this.comboBoxPenalty);
        this.add(new JLabel(Internationalization._("solution_editing.scramble")));
        this.textFieldScramble = new JTextField();
        this.textFieldScramble.setEditable(false);
        this.textFieldScramble.setFocusable(false);
        this.add(this.textFieldScramble);
        this.buttonOk = new JButton(Internationalization._("solution_editing.ok"));
        this.add((Component)this.buttonOk, "tag ok, span 2, split");
        this.buttonCancel = new JButton(Internationalization._("solution_editing.cancel"));
        this.add((Component)this.buttonCancel, "tag cancel");
    }

    public static class SolutionEditingDialogListener {
        public void solutionEdited(Solution solution) {
        }
    }
}

