/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.gui;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public class TimeLabel
extends JComponent {
    private String text;

    public TimeLabel(String text) {
        this.text = text;
    }

    public void setText(String text) {
        this.text = text;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int textWidth = g2.getFontMetrics().stringWidth("00:00.00");
        int fontSize = this.getFont().getSize() * this.getWidth() / textWidth;
        g2.setFont(this.getFont().deriveFont((float)Math.min(fontSize, this.getHeight())));
        Rectangle2D bounds = g2.getFontMetrics().getStringBounds(this.text, g2);
        g2.drawString(this.text, (int)(((double)this.getWidth() - bounds.getWidth()) / 2.0 - bounds.getX()), (int)(((double)this.getHeight() - bounds.getHeight()) / 2.0 - bounds.getY()));
    }
}

