/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.models;

import com.puzzletimer.Internationalization;
import java.awt.Color;

public class ColorScheme {
    private final String puzzleId;
    private final FaceColor[] faceColors;

    public ColorScheme(String puzzleId, FaceColor[] faceColors) {
        this.puzzleId = puzzleId;
        this.faceColors = faceColors;
    }

    public String getPuzzleId() {
        return this.puzzleId;
    }

    public FaceColor[] getFaceColors() {
        return this.faceColors;
    }

    public FaceColor getFaceColor(String faceId) {
        FaceColor[] faceColorArray = this.faceColors;
        int n = this.faceColors.length;
        int n2 = 0;
        while (n2 < n) {
            FaceColor faceColor = faceColorArray[n2];
            if (faceColor.getFaceId().equals(faceId)) {
                return faceColor;
            }
            ++n2;
        }
        return null;
    }

    public ColorScheme setFaceColor(FaceColor faceColor) {
        FaceColor[] faceColors = new FaceColor[this.faceColors.length];
        int i = 0;
        while (i < faceColors.length) {
            faceColors[i] = this.faceColors[i];
            if (this.faceColors[i].getFaceId().equals(faceColor.getFaceId())) {
                faceColors[i] = faceColor;
            }
            ++i;
        }
        return new ColorScheme(this.puzzleId, faceColors);
    }

    public static class FaceColor {
        private final String puzzleId;
        private final String faceId;
        private final Color defaultColor;
        private final Color color;

        public FaceColor(String puzzleId, String faceId, Color defaultColor, Color color) {
            this.puzzleId = puzzleId;
            this.faceId = faceId;
            this.defaultColor = defaultColor;
            this.color = color;
        }

        public String getPuzzleId() {
            return this.puzzleId;
        }

        public String getFaceId() {
            return this.faceId;
        }

        public String getFaceDescription() {
            return Internationalization._("face." + this.puzzleId + "." + this.faceId);
        }

        public Color getDefaultColor() {
            return this.defaultColor;
        }

        public FaceColor setColorToDefault() {
            return new FaceColor(this.puzzleId, this.faceId, this.defaultColor, this.defaultColor);
        }

        public Color getColor() {
            return this.color;
        }

        public FaceColor setColor(Color color) {
            return new FaceColor(this.puzzleId, this.faceId, this.defaultColor, color);
        }
    }
}

