/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.parsers;

import com.puzzletimer.parsers.Parser;
import com.puzzletimer.parsers.ScrambleParser;
import com.puzzletimer.solvers.Square1ShapeSolver;
import java.util.ArrayList;

public class Square1ScrambleParser
implements ScrambleParser {
    @Override
    public String getPuzzleId() {
        return "SQUARE-1";
    }

    @Override
    public String[] parse(String input) {
        Parser parser = new Parser(input);
        ArrayList<String> moves = new ArrayList<String>();
        while (true) {
            parser.skipSpaces();
            String twist = parser.string("/");
            if (twist != null) {
                moves.add(twist);
                continue;
            }
            String open = parser.string("(");
            if (open == null) break;
            String move = open;
            parser.skipSpaces();
            String top = parser.number();
            if (top == null) break;
            move = String.valueOf(move) + top;
            parser.skipSpaces();
            String comma = parser.string(",");
            if (comma == null) break;
            move = String.valueOf(move) + comma;
            parser.skipSpaces();
            String bottom = parser.number();
            if (bottom == null) break;
            move = String.valueOf(move) + bottom;
            parser.skipSpaces();
            String close = parser.string(")");
            if (close == null) break;
            move = String.valueOf(move) + close;
            moves.add(move);
        }
        if (!this.isValidScramble(moves = this.fixImplicitTwists(moves))) {
            return new String[0];
        }
        String[] movesArray = new String[moves.size()];
        moves.toArray(movesArray);
        return movesArray;
    }

    private ArrayList<String> fixImplicitTwists(ArrayList<String> sequence) {
        boolean implicit = true;
        for (String move : sequence) {
            if (!move.equals("/")) continue;
            implicit = false;
        }
        if (!implicit) {
            return sequence;
        }
        ArrayList<String> newSequence = new ArrayList<String>();
        for (String move : sequence) {
            newSequence.add(move);
            newSequence.add("/");
        }
        return newSequence;
    }

    private boolean isValidScramble(ArrayList<String> sequence) {
        Square1ShapeSolver.State state = Square1ShapeSolver.State.id;
        for (String move : sequence) {
            if (move.equals("/") && !state.isTwistable()) {
                return false;
            }
            state = state.applyMove(move);
        }
        return true;
    }
}

