/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.puzzles;

import com.puzzletimer.graphics.Matrix44;
import com.puzzletimer.graphics.Mesh;
import com.puzzletimer.graphics.Plane;
import com.puzzletimer.graphics.Vector3;
import com.puzzletimer.models.ColorScheme;
import com.puzzletimer.models.PuzzleInfo;
import com.puzzletimer.puzzles.Puzzle;
import java.awt.Color;
import java.util.HashMap;

public class RubiksPocketCube
implements Puzzle {
    @Override
    public PuzzleInfo getPuzzleInfo() {
        return new PuzzleInfo("2x2x2-CUBE");
    }

    public String toString() {
        return this.getPuzzleInfo().getDescription();
    }

    @Override
    public Mesh getScrambledPuzzleMesh(ColorScheme colorScheme, String[] sequence) {
        Color[] colorArray = new Color[]{colorScheme.getFaceColor("FACE-L").getColor(), colorScheme.getFaceColor("FACE-B").getColor(), colorScheme.getFaceColor("FACE-D").getColor(), colorScheme.getFaceColor("FACE-R").getColor(), colorScheme.getFaceColor("FACE-F").getColor(), colorScheme.getFaceColor("FACE-U").getColor()};
        Mesh mesh = Mesh.cube(colorArray);
        Plane planeL = new Plane(new Vector3(-0.0, 0.0, 0.0), new Vector3(-1.0, 0.0, 0.0));
        Plane planeR = new Plane(new Vector3(0.0, 0.0, 0.0), new Vector3(1.0, 0.0, 0.0));
        Plane planeD = new Plane(new Vector3(0.0, -0.0, 0.0), new Vector3(0.0, -1.0, 0.0));
        Plane planeU = new Plane(new Vector3(0.0, 0.0, 0.0), new Vector3(0.0, 1.0, 0.0));
        Plane planeF = new Plane(new Vector3(0.0, 0.0, -0.0), new Vector3(0.0, 0.0, -1.0));
        Plane planeB = new Plane(new Vector3(0.0, 0.0, 0.0), new Vector3(0.0, 0.0, 1.0));
        mesh = mesh.cut(planeR, 0.0).cut(planeU, 0.0).cut(planeF, 0.0).shortenFaces(0.04).softenFaces(0.02).softenFaces(0.01);
        HashMap<String, Twist> twists = new HashMap<String, Twist>();
        twists.put("L", new Twist(planeL, 1.5707963267948966));
        twists.put("L2", new Twist(planeL, Math.PI));
        twists.put("L'", new Twist(planeL, -1.5707963267948966));
        twists.put("R", new Twist(planeR, 1.5707963267948966));
        twists.put("R2", new Twist(planeR, Math.PI));
        twists.put("R'", new Twist(planeR, -1.5707963267948966));
        twists.put("D", new Twist(planeD, 1.5707963267948966));
        twists.put("D2", new Twist(planeD, Math.PI));
        twists.put("D'", new Twist(planeD, -1.5707963267948966));
        twists.put("U", new Twist(planeU, 1.5707963267948966));
        twists.put("U2", new Twist(planeU, Math.PI));
        twists.put("U'", new Twist(planeU, -1.5707963267948966));
        twists.put("F", new Twist(planeF, 1.5707963267948966));
        twists.put("F2", new Twist(planeF, Math.PI));
        twists.put("F'", new Twist(planeF, -1.5707963267948966));
        twists.put("B", new Twist(planeB, 1.5707963267948966));
        twists.put("B2", new Twist(planeB, Math.PI));
        twists.put("B'", new Twist(planeB, -1.5707963267948966));
        String[] stringArray = sequence;
        int n = sequence.length;
        int n2 = 0;
        while (n2 < n) {
            String move = stringArray[n2];
            Twist t = (Twist)twists.get(move);
            mesh = mesh.rotateHalfspace(t.plane, t.angle);
            ++n2;
        }
        return mesh.transform(Matrix44.rotationY(-0.5235987755982988)).transform(Matrix44.rotationX(0.4487989505128276));
    }

    private class Twist {
        public Plane plane;
        public double angle;

        public Twist(Plane plane, double angle) {
            this.plane = plane;
            this.angle = angle;
        }
    }
}

