/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.puzzles;

import com.puzzletimer.graphics.Matrix44;
import com.puzzletimer.graphics.Mesh;
import com.puzzletimer.graphics.Plane;
import com.puzzletimer.graphics.Vector3;
import com.puzzletimer.models.ColorScheme;
import com.puzzletimer.models.PuzzleInfo;
import com.puzzletimer.puzzles.Puzzle;
import java.awt.Color;
import java.util.HashMap;

public class Skewb
implements Puzzle {
    @Override
    public PuzzleInfo getPuzzleInfo() {
        return new PuzzleInfo("SKEWB");
    }

    public String toString() {
        return this.getPuzzleInfo().getDescription();
    }

    @Override
    public Mesh getScrambledPuzzleMesh(ColorScheme colorScheme, String[] sequence) {
        Color[] colorArray = new Color[]{colorScheme.getFaceColor("FACE-L").getColor(), colorScheme.getFaceColor("FACE-B").getColor(), colorScheme.getFaceColor("FACE-D").getColor(), colorScheme.getFaceColor("FACE-R").getColor(), colorScheme.getFaceColor("FACE-F").getColor(), colorScheme.getFaceColor("FACE-U").getColor()};
        Mesh mesh = Mesh.cube(colorArray);
        Plane planeL = new Plane(new Vector3(0.5, 0.5, 0.0), new Vector3(0.5, 0.0, -0.5), new Vector3(0.0, -0.5, -0.5));
        Plane planeR = new Plane(new Vector3(0.5, 0.0, -0.5), new Vector3(0.0, 0.5, -0.5), new Vector3(-0.5, 0.5, 0.0));
        Plane planeD = new Plane(new Vector3(0.0, 0.5, -0.5), new Vector3(0.5, 0.5, 0.0), new Vector3(0.5, 0.0, 0.5));
        Plane planeB = new Plane(new Vector3(0.5, 0.0, 0.5), new Vector3(0.0, 0.5, 0.5), new Vector3(-0.5, 0.5, 0.0));
        mesh = mesh.cut(planeL, 0.0).cut(planeR, 0.0).cut(planeD, 0.0).cut(planeB, 0.0).shortenFaces(0.05).softenFaces(0.02).softenFaces(0.01);
        HashMap<String, Twist> twists = new HashMap<String, Twist>();
        twists.put("L", new Twist(planeL, 2.0943951023931953));
        twists.put("L'", new Twist(planeL, -2.0943951023931953));
        twists.put("R", new Twist(planeR, 2.0943951023931953));
        twists.put("R'", new Twist(planeR, -2.0943951023931953));
        twists.put("D", new Twist(planeD, 2.0943951023931953));
        twists.put("D'", new Twist(planeD, -2.0943951023931953));
        twists.put("B", new Twist(planeB, 2.0943951023931953));
        twists.put("B'", new Twist(planeB, -2.0943951023931953));
        String[] stringArray = sequence;
        int n = sequence.length;
        int n2 = 0;
        while (n2 < n) {
            String move = stringArray[n2];
            Twist t = (Twist)twists.get(move);
            mesh = mesh.rotateHalfspace(t.plane, t.angle);
            ++n2;
        }
        return mesh.transform(Matrix44.rotationY(-0.5235987755982988)).transform(Matrix44.rotationX(0.4487989505128276));
    }

    private class Twist {
        public Plane plane;
        public double angle;

        public Twist(Plane plane, double angle) {
            this.plane = plane;
            this.angle = angle;
        }
    }
}

