/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.scramblers;

import com.puzzletimer.models.Scramble;
import com.puzzletimer.models.ScramblerInfo;
import com.puzzletimer.scramblers.Scrambler;
import java.util.Random;

public class MegaminxRandomScrambler
implements Scrambler {
    private ScramblerInfo scramblerInfo;
    private Random random = new Random();

    public MegaminxRandomScrambler(ScramblerInfo scramblerInfo) {
        this.scramblerInfo = scramblerInfo;
    }

    @Override
    public ScramblerInfo getScramblerInfo() {
        return this.scramblerInfo;
    }

    @Override
    public Scramble getNextScramble() {
        String[] sequence = new String[77];
        int i = 0;
        while (i < 7) {
            int j = 0;
            while (j < 5) {
                sequence[11 * i + 2 * j] = this.random.nextInt(2) == 0 ? "R++" : "R--";
                sequence[11 * i + 2 * j + 1] = this.random.nextInt(2) == 0 ? "D++" : "D--";
                ++j;
            }
            sequence[11 * i + 10] = sequence[11 * i + 9] == "D++" ? "U" : "U'";
            ++i;
        }
        return new Scramble(this.getScramblerInfo().getScramblerId(), sequence);
    }

    public String toString() {
        return this.getScramblerInfo().getDescription();
    }
}

