/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.scramblers;

import com.puzzletimer.models.Scramble;
import com.puzzletimer.models.ScramblerInfo;
import com.puzzletimer.scramblers.RubiksCubeRandomScrambler;
import com.puzzletimer.scramblers.Scrambler;
import com.puzzletimer.solvers.RubiksCubeCrossSolver;
import com.puzzletimer.solvers.RubiksCubeSolver;
import java.util.ArrayList;

public class RubiksCubeEasyCrossScrambler
implements Scrambler {
    private ScramblerInfo scramblerInfo;
    private int maxDistance;
    private RubiksCubeRandomScrambler rubiksCubeRandomScrambler;

    public RubiksCubeEasyCrossScrambler(ScramblerInfo scramblerInfo, int maxDistance) {
        this.scramblerInfo = scramblerInfo;
        this.maxDistance = maxDistance;
        this.rubiksCubeRandomScrambler = new RubiksCubeRandomScrambler(scramblerInfo, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1});
    }

    @Override
    public ScramblerInfo getScramblerInfo() {
        return this.scramblerInfo;
    }

    @Override
    public Scramble getNextScramble() {
        RubiksCubeSolver.State state;
        ArrayList<String[]> solution;
        byte[] byArray = new byte[8];
        byArray[0] = 3;
        byArray[1] = 2;
        byArray[2] = 6;
        byArray[3] = 7;
        byArray[5] = 1;
        byArray[6] = 5;
        byArray[7] = 4;
        byte[] byArray2 = new byte[12];
        byArray2[0] = 7;
        byArray2[1] = 5;
        byArray2[2] = 9;
        byArray2[3] = 11;
        byArray2[4] = 6;
        byArray2[5] = 2;
        byArray2[6] = 10;
        byArray2[7] = 3;
        byArray2[8] = 4;
        byArray2[9] = 1;
        byArray2[10] = 8;
        byte[] byArray3 = new byte[12];
        byArray3[4] = 1;
        byArray3[6] = 1;
        byArray3[8] = 1;
        byArray3[10] = 1;
        RubiksCubeSolver.State x = new RubiksCubeSolver.State(byArray, new byte[]{2, 1, 2, 1, 1, 2, 1, 2}, byArray2, byArray3);
        do {
            state = this.rubiksCubeRandomScrambler.getRandomState();
        } while ((solution = RubiksCubeCrossSolver.solve(x.multiply(x).multiply(state).multiply(x).multiply(x))).get(0).length > this.maxDistance);
        return new Scramble(this.getScramblerInfo().getScramblerId(), RubiksCubeSolver.generate(state));
    }

    public String toString() {
        return this.getScramblerInfo().getDescription();
    }
}

