/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.scramblers;

import com.puzzletimer.models.Scramble;
import com.puzzletimer.models.ScramblerInfo;
import com.puzzletimer.scramblers.Scrambler;
import com.puzzletimer.solvers.RubiksCubeRUSolver;
import java.util.HashMap;
import java.util.Random;

public class RubiksCubeLUScrambler
implements Scrambler {
    private ScramblerInfo scramblerInfo;
    private Random random;

    public RubiksCubeLUScrambler(ScramblerInfo scramblerInfo) {
        this.scramblerInfo = scramblerInfo;
        this.random = new Random();
    }

    @Override
    public ScramblerInfo getScramblerInfo() {
        return this.scramblerInfo;
    }

    @Override
    public Scramble getNextScramble() {
        HashMap<String, String> mirror = new HashMap<String, String>();
        mirror.put("U", "U'");
        mirror.put("U2", "U2");
        mirror.put("U'", "U");
        mirror.put("R", "L'");
        mirror.put("R2", "L2");
        mirror.put("R'", "L");
        String[] sequence = RubiksCubeRUSolver.generate(RubiksCubeRUSolver.getRandomState(this.random));
        int i = 0;
        while (i < sequence.length) {
            sequence[i] = (String)mirror.get(sequence[i]);
            ++i;
        }
        return new Scramble(this.getScramblerInfo().getScramblerId(), sequence);
    }

    public String toString() {
        return this.getScramblerInfo().getDescription();
    }
}

