/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.scramblers;

import com.puzzletimer.models.Scramble;
import com.puzzletimer.models.ScramblerInfo;
import com.puzzletimer.scramblers.Scrambler;
import com.puzzletimer.solvers.RubiksCubeSolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;

public class RubiksCubeRandomScrambler
implements Scrambler {
    private ScramblerInfo scramblerInfo;
    private byte[] cornersPermutation;
    private byte[] cornersOrientation;
    private byte[] edgesPermutation;
    private byte[] edgesOrientation;
    private Random random;

    public RubiksCubeRandomScrambler(ScramblerInfo scramblerInfo, byte[] cornersPermutation, byte[] cornersOrientation, byte[] edgesPermutation, byte[] edgesOrientation) {
        this.scramblerInfo = scramblerInfo;
        this.cornersPermutation = cornersPermutation;
        this.cornersOrientation = cornersOrientation;
        this.edgesPermutation = edgesPermutation;
        this.edgesOrientation = edgesOrientation;
        this.random = new Random();
    }

    @Override
    public ScramblerInfo getScramblerInfo() {
        return this.scramblerInfo;
    }

    private int permutationSign(byte[] permutation) {
        int nInversions = 0;
        int i = 0;
        while (i < permutation.length) {
            int j = i + 1;
            while (j < permutation.length) {
                if (permutation[i] > permutation[j]) {
                    ++nInversions;
                }
                ++j;
            }
            ++i;
        }
        return nInversions % 2 == 0 ? 1 : -1;
    }

    public RubiksCubeSolver.State getRandomState() {
        byte[] edgesOrientation;
        byte[] cornersOrientation;
        byte[] edgesPermutation;
        byte[] cornersPermutation;
        do {
            ArrayList<Byte> undefinedCornersPermutation = new ArrayList<Byte>();
            int i = 0;
            while (i < this.cornersPermutation.length) {
                undefinedCornersPermutation.add((byte)i);
                ++i;
            }
            i = 0;
            while (i < this.cornersPermutation.length) {
                if (this.cornersPermutation[i] >= 0) {
                    undefinedCornersPermutation.remove((Object)this.cornersPermutation[i]);
                }
                ++i;
            }
            Collections.shuffle(undefinedCornersPermutation, this.random);
            cornersPermutation = new byte[this.cornersPermutation.length];
            i = 0;
            while (i < cornersPermutation.length) {
                if (this.cornersPermutation[i] >= 0) {
                    cornersPermutation[i] = this.cornersPermutation[i];
                } else {
                    cornersPermutation[i] = (Byte)undefinedCornersPermutation.get(0);
                    undefinedCornersPermutation.remove(0);
                }
                ++i;
            }
            int nUndefinedCornerOrientations = 0;
            int i2 = 0;
            while (i2 < this.cornersOrientation.length) {
                if (this.cornersOrientation[i2] < 0) {
                    ++nUndefinedCornerOrientations;
                }
                ++i2;
            }
            int cornersOrientationSum = 0;
            cornersOrientation = new byte[this.cornersOrientation.length];
            int i3 = 0;
            while (i3 < cornersOrientation.length) {
                if (this.cornersOrientation[i3] >= 0) {
                    cornersOrientation[i3] = this.cornersOrientation[i3];
                } else {
                    cornersOrientation[i3] = nUndefinedCornerOrientations == 1 ? (byte)((3 - cornersOrientationSum) % 3) : (byte)this.random.nextInt(3);
                    --nUndefinedCornerOrientations;
                }
                cornersOrientationSum += cornersOrientation[i3];
                cornersOrientationSum %= 3;
                ++i3;
            }
            ArrayList<Byte> undefinedEdgesPermutation = new ArrayList<Byte>();
            int i4 = 0;
            while (i4 < this.edgesPermutation.length) {
                undefinedEdgesPermutation.add((byte)i4);
                ++i4;
            }
            i4 = 0;
            while (i4 < this.edgesPermutation.length) {
                if (this.edgesPermutation[i4] >= 0) {
                    undefinedEdgesPermutation.remove((Object)this.edgesPermutation[i4]);
                }
                ++i4;
            }
            Collections.shuffle(undefinedEdgesPermutation, this.random);
            edgesPermutation = new byte[this.edgesPermutation.length];
            i4 = 0;
            while (i4 < edgesPermutation.length) {
                if (this.edgesPermutation[i4] >= 0) {
                    edgesPermutation[i4] = this.edgesPermutation[i4];
                } else {
                    edgesPermutation[i4] = (Byte)undefinedEdgesPermutation.get(0);
                    undefinedEdgesPermutation.remove(0);
                }
                ++i4;
            }
            int nUndefinedEdgeOrientations = 0;
            int i5 = 0;
            while (i5 < this.edgesOrientation.length) {
                if (this.edgesOrientation[i5] < 0) {
                    ++nUndefinedEdgeOrientations;
                }
                ++i5;
            }
            int edgesOrientationSum = 0;
            edgesOrientation = new byte[this.edgesOrientation.length];
            int i6 = 0;
            while (i6 < edgesOrientation.length) {
                if (this.edgesOrientation[i6] >= 0) {
                    edgesOrientation[i6] = this.edgesOrientation[i6];
                } else {
                    edgesOrientation[i6] = nUndefinedEdgeOrientations == 1 ? (byte)((2 - edgesOrientationSum) % 2) : (byte)this.random.nextInt(2);
                    --nUndefinedEdgeOrientations;
                }
                edgesOrientationSum += edgesOrientation[i6];
                edgesOrientationSum %= 2;
                ++i6;
            }
        } while (this.permutationSign(cornersPermutation) != this.permutationSign(edgesPermutation));
        return new RubiksCubeSolver.State(cornersPermutation, cornersOrientation, edgesPermutation, edgesOrientation);
    }

    @Override
    public Scramble getNextScramble() {
        return new Scramble(this.getScramblerInfo().getScramblerId(), RubiksCubeSolver.generate(this.getRandomState()));
    }

    public String toString() {
        return this.getScramblerInfo().getDescription();
    }
}

