/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.scramblers;

import com.puzzletimer.models.Scramble;
import com.puzzletimer.models.ScramblerInfo;
import com.puzzletimer.scramblers.RubiksCubeRandomScrambler;
import com.puzzletimer.scramblers.Scrambler;
import com.puzzletimer.solvers.RubiksCubeSolver;

public class RubiksCubeSingleStickerCycleScrambler
implements Scrambler {
    private ScramblerInfo scramblerInfo;
    private RubiksCubeRandomScrambler rubiksCubeRandomScrambler;

    public RubiksCubeSingleStickerCycleScrambler(ScramblerInfo scramblerInfo) {
        this.scramblerInfo = scramblerInfo;
        this.rubiksCubeRandomScrambler = new RubiksCubeRandomScrambler(new ScramblerInfo("RUBIKS-CUBE-RANDOM", "RUBIKS-CUBE", "Random scrambler"), new byte[]{-1, -1, -1, -1, -1, -1, -1, -1}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1});
    }

    @Override
    public ScramblerInfo getScramblerInfo() {
        return this.scramblerInfo;
    }

    @Override
    public Scramble getNextScramble() {
        RubiksCubeSolver.State state = null;
        boolean singleCornerCycle = false;
        boolean singleEdgeCycle = false;
        block0: while (!singleCornerCycle || !singleEdgeCycle) {
            boolean solved;
            state = this.rubiksCubeRandomScrambler.getRandomState();
            boolean[] solvedCorners = new boolean[8];
            int i = 0;
            while (i < solvedCorners.length) {
                solvedCorners[i] = state.cornersPermutation[i] == i && state.cornersOrientation[i] == 0;
                ++i;
            }
            solvedCorners[0] = true;
            int currentCorner = 0;
            while (true) {
                int nextCorner;
                if ((nextCorner = state.cornersPermutation[currentCorner]) == 0) {
                    solved = true;
                    int i2 = 0;
                    while (i2 < solvedCorners.length) {
                        if (!solvedCorners[i2]) {
                            solved = false;
                        }
                        ++i2;
                    }
                    break;
                }
                currentCorner = nextCorner;
                solvedCorners[currentCorner] = true;
            }
            singleCornerCycle = solved;
            boolean[] solvedEdges = new boolean[12];
            int i3 = 0;
            while (i3 < solvedEdges.length) {
                solvedEdges[i3] = state.edgesPermutation[i3] == i3 && state.edgesOrientation[i3] == 0;
                ++i3;
            }
            solvedEdges[0] = true;
            int currentEdge = 0;
            while (true) {
                int nextEdge;
                if ((nextEdge = state.edgesPermutation[currentEdge]) == 0) {
                    boolean solved2 = true;
                    int i4 = 0;
                    while (i4 < solvedEdges.length) {
                        if (!solvedEdges[i4]) {
                            solved2 = false;
                        }
                        ++i4;
                    }
                    singleEdgeCycle = solved2;
                    continue block0;
                }
                currentEdge = nextEdge;
                solvedEdges[currentEdge] = true;
            }
        }
        return new Scramble(this.getScramblerInfo().getScramblerId(), RubiksCubeSolver.generate(state));
    }

    public String toString() {
        return this.getScramblerInfo().getDescription();
    }
}

