/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.scramblers;

import com.puzzletimer.models.Scramble;
import com.puzzletimer.models.ScramblerInfo;
import com.puzzletimer.scramblers.Scrambler;
import java.util.Arrays;
import java.util.Random;

public class RubiksRevengeRandomScrambler
implements Scrambler {
    private ScramblerInfo scramblerInfo;
    private int scrambleLength;
    private Random random;

    public RubiksRevengeRandomScrambler(ScramblerInfo scramblerInfo, int scrambleLength) {
        this.scramblerInfo = scramblerInfo;
        this.scrambleLength = scrambleLength;
        this.random = new Random();
    }

    @Override
    public ScramblerInfo getScramblerInfo() {
        return this.scramblerInfo;
    }

    @Override
    public Scramble getNextScramble() {
        int[] slice = new int[this.scrambleLength];
        int[] power = new int[this.scrambleLength];
        int i = 0;
        while (i < this.scrambleLength) {
            int s = this.random.nextInt(9);
            int p = this.random.nextInt(3);
            boolean ignore = false;
            int j = i - 1;
            while (j >= 0) {
                if (s / 3 != slice[j] / 3) break;
                if (s == slice[j]) {
                    ignore = true;
                }
                --j;
            }
            if (ignore) continue;
            slice[i] = s;
            power[i] = p;
            ++i;
        }
        i = 0;
        while (i < slice.length) {
            int len = 1;
            while (i + len < slice.length && slice[i] / 3 == slice[i + len] / 3) {
                ++len;
            }
            Arrays.sort(slice, i, i + len);
            i += len;
        }
        String[][] moves = new String[][]{{"U", "U2", "U'"}, {"Uw", "Uw2", "Uw'"}, {"D", "D2", "D'"}, {"L", "L2", "L'"}, {"Rw", "Rw2", "Rw'"}, {"R", "R2", "R'"}, {"F", "F2", "F'"}, {"Fw", "Fw2", "Fw'"}, {"B", "B2", "B'"}};
        String[] sequence = new String[this.scrambleLength];
        int j = 0;
        while (j < sequence.length) {
            sequence[j] = moves[slice[j]][power[j]];
            ++j;
        }
        return new Scramble(this.getScramblerInfo().getScramblerId(), sequence);
    }

    public String toString() {
        return this.getScramblerInfo().getDescription();
    }
}

