/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.scramblers;

import com.puzzletimer.Internationalization;
import com.puzzletimer.models.ScramblerInfo;
import com.puzzletimer.scramblers.EmptyScrambler;
import com.puzzletimer.scramblers.FloppyCubeRandomScrambler;
import com.puzzletimer.scramblers.MegaminxRandomScrambler;
import com.puzzletimer.scramblers.ProfessorsCubeRandomScrambler;
import com.puzzletimer.scramblers.PyraminxRandomScrambler;
import com.puzzletimer.scramblers.RubiksClockRandomScrambler;
import com.puzzletimer.scramblers.RubiksCubeEasyCrossScrambler;
import com.puzzletimer.scramblers.RubiksCubeLUScrambler;
import com.puzzletimer.scramblers.RubiksCubeRUScrambler;
import com.puzzletimer.scramblers.RubiksCubeRandomScrambler;
import com.puzzletimer.scramblers.RubiksCubeSingleStickerCycleScrambler;
import com.puzzletimer.scramblers.RubiksDominoRandomScrambler;
import com.puzzletimer.scramblers.RubiksPocketCubeRandomScrambler;
import com.puzzletimer.scramblers.RubiksRevengeRandomScrambler;
import com.puzzletimer.scramblers.RubiksTowerRandomScrambler;
import com.puzzletimer.scramblers.Scrambler;
import com.puzzletimer.scramblers.SkewbRandomScrambler;
import com.puzzletimer.scramblers.Square1CubeShapeScrambler;
import com.puzzletimer.scramblers.Square1RandomScrambler;
import com.puzzletimer.scramblers.TowerCubeRandomScrambler;
import com.puzzletimer.scramblers.VCube6RandomScrambler;
import com.puzzletimer.scramblers.VCube7RandomScrambler;
import java.util.ArrayList;
import java.util.HashMap;

public class ScramblerProvider {
    private Scrambler[] scramblers;
    private HashMap<String, Scrambler> scramblerMap;

    public ScramblerProvider() {
        EmptyScrambler rubiksPocketCubeImporter = new EmptyScrambler(new ScramblerInfo("2x2x2-CUBE-IMPORTER", "2x2x2-CUBE", ""));
        RubiksPocketCubeRandomScrambler rubiksPocketCubeRandom = new RubiksPocketCubeRandomScrambler(new ScramblerInfo("2x2x2-CUBE-RANDOM", "2x2x2-CUBE", Internationalization._("scrambler.2x2x2-CUBE-RANDOM")), 0, new String[]{"U", "D", "L", "R", "F", "B"});
        RubiksPocketCubeRandomScrambler rubiksPocketCubeURF = new RubiksPocketCubeRandomScrambler(new ScramblerInfo("2x2x2-CUBE-URF", "2x2x2-CUBE", Internationalization._("scrambler.2x2x2-CUBE-URF")), 0, new String[]{"U", "R", "F"});
        RubiksPocketCubeRandomScrambler rubiksPocketCubeSuboptimalURF = new RubiksPocketCubeRandomScrambler(new ScramblerInfo("2x2x2-CUBE-SUBOPTIMAL-URF", "2x2x2-CUBE", Internationalization._("scrambler.2x2x2-CUBE-SUBOPTIMAL-URF")), 11, new String[]{"U", "R", "F"});
        EmptyScrambler rubiksCubeImporter = new EmptyScrambler(new ScramblerInfo("RUBIKS-CUBE-IMPORTER", "RUBIKS-CUBE", ""));
        RubiksCubeRandomScrambler rubiksCubeRandom = new RubiksCubeRandomScrambler(new ScramblerInfo("RUBIKS-CUBE-RANDOM", "RUBIKS-CUBE", Internationalization._("scrambler.RUBIKS-CUBE-RANDOM")), new byte[]{-1, -1, -1, -1, -1, -1, -1, -1}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1});
        RubiksCubeLUScrambler rubiksCubeLU = new RubiksCubeLUScrambler(new ScramblerInfo("RUBIKS-CUBE-LU", "RUBIKS-CUBE", Internationalization._("scrambler.RUBIKS-CUBE-LU")));
        RubiksCubeRUScrambler rubiksCubeRU = new RubiksCubeRUScrambler(new ScramblerInfo("RUBIKS-CUBE-RU", "RUBIKS-CUBE", Internationalization._("scrambler.RUBIKS-CUBE-RU")));
        byte[] byArray = new byte[8];
        byArray[0] = -1;
        byArray[1] = -1;
        byArray[2] = -1;
        byArray[3] = -1;
        byte[] byArray2 = new byte[12];
        byArray2[1] = 1;
        byArray2[2] = 2;
        byArray2[3] = 3;
        byArray2[4] = 4;
        byArray2[5] = 5;
        byArray2[6] = 6;
        byArray2[7] = 7;
        byArray2[8] = 8;
        byArray2[9] = 9;
        byArray2[10] = 10;
        byArray2[11] = 11;
        RubiksCubeRandomScrambler rubiksCubeCLLTraining = new RubiksCubeRandomScrambler(new ScramblerInfo("RUBIKS-CUBE-CLL-TRAINING", "RUBIKS-CUBE", Internationalization._("scrambler.RUBIKS-CUBE-CLL-TRAINING")), new byte[]{-1, -1, -1, -1, 4, 5, 6, 7}, byArray, byArray2, new byte[12]);
        byte[] byArray3 = new byte[8];
        byArray3[1] = 1;
        byArray3[2] = 2;
        byArray3[3] = 3;
        byArray3[4] = 4;
        byArray3[5] = 5;
        byArray3[6] = 6;
        byArray3[7] = 7;
        byte[] byArray4 = new byte[12];
        byArray4[1] = 1;
        byArray4[2] = 2;
        byArray4[3] = 3;
        byArray4[4] = -1;
        byArray4[5] = -1;
        byArray4[6] = -1;
        byArray4[7] = -1;
        byArray4[8] = 8;
        byArray4[9] = 9;
        byArray4[10] = 10;
        byArray4[11] = 11;
        byte[] byArray5 = new byte[12];
        byArray5[4] = -1;
        byArray5[5] = -1;
        byArray5[6] = -1;
        byArray5[7] = -1;
        RubiksCubeRandomScrambler rubiksCubeELLTraining = new RubiksCubeRandomScrambler(new ScramblerInfo("RUBIKS-CUBE-ELL-TRAINING", "RUBIKS-CUBE", Internationalization._("scrambler.RUBIKS-CUBE-ELL-TRAINING")), byArray3, new byte[8], byArray4, byArray5);
        byte[] byArray6 = new byte[12];
        byArray6[0] = -1;
        byArray6[1] = -1;
        byArray6[2] = -1;
        byArray6[3] = -1;
        byArray6[4] = -1;
        byArray6[5] = -1;
        byArray6[6] = -1;
        byArray6[7] = -1;
        RubiksCubeRandomScrambler rubiksCubeFridrichF2LTraining = new RubiksCubeRandomScrambler(new ScramblerInfo("RUBIKS-CUBE-FRIDRICH-F2L-TRAINING", "RUBIKS-CUBE", Internationalization._("scrambler.RUBIKS-CUBE-FRIDRICH-F2L-TRAINING")), new byte[]{-1, -1, -1, -1, -1, -1, -1, -1}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, 8, 9, 10, 11}, byArray6);
        byte[] byArray7 = new byte[8];
        byArray7[0] = -1;
        byArray7[1] = -1;
        byArray7[2] = -1;
        byArray7[3] = -1;
        byte[] byArray8 = new byte[12];
        byArray8[1] = 1;
        byArray8[2] = 2;
        byArray8[3] = 3;
        byArray8[4] = -1;
        byArray8[5] = -1;
        byArray8[6] = -1;
        byArray8[7] = -1;
        byArray8[8] = 8;
        byArray8[9] = 9;
        byArray8[10] = 10;
        byArray8[11] = 11;
        byte[] byArray9 = new byte[12];
        byArray9[4] = -1;
        byArray9[5] = -1;
        byArray9[6] = -1;
        byArray9[7] = -1;
        RubiksCubeRandomScrambler rubiksCubeFridrichOLLTraining = new RubiksCubeRandomScrambler(new ScramblerInfo("RUBIKS-CUBE-FRIDRICH-OLL-TRAINING", "RUBIKS-CUBE", Internationalization._("scrambler.RUBIKS-CUBE-FRIDRICH-OLL-TRAINING")), new byte[]{-1, -1, -1, -1, 4, 5, 6, 7}, byArray7, byArray8, byArray9);
        byte[] byArray10 = new byte[12];
        byArray10[1] = 1;
        byArray10[2] = 2;
        byArray10[3] = 3;
        byArray10[4] = -1;
        byArray10[5] = -1;
        byArray10[6] = -1;
        byArray10[7] = -1;
        byArray10[8] = 8;
        byArray10[9] = 9;
        byArray10[10] = 10;
        byArray10[11] = 11;
        RubiksCubeRandomScrambler rubiksCubeFridrichPLLTraining = new RubiksCubeRandomScrambler(new ScramblerInfo("RUBIKS-CUBE-FRIDRICH-PLL-TRAINING", "RUBIKS-CUBE", Internationalization._("scrambler.RUBIKS-CUBE-FRIDRICH-PLL-TRAINING")), new byte[]{-1, -1, -1, -1, 4, 5, 6, 7}, new byte[8], byArray10, new byte[12]);
        byte[] byArray11 = new byte[12];
        byArray11[1] = 1;
        byArray11[2] = 2;
        byArray11[3] = 3;
        byArray11[4] = 4;
        byArray11[5] = 5;
        byArray11[6] = 6;
        byArray11[7] = 7;
        byArray11[8] = 8;
        byArray11[9] = 9;
        byArray11[10] = 10;
        byArray11[11] = 11;
        RubiksCubeRandomScrambler rubiksCube3OPCornersTraining = new RubiksCubeRandomScrambler(new ScramblerInfo("RUBIKS-CUBE-3OP-CORNERS-TRAINING", "RUBIKS-CUBE", Internationalization._("scrambler.RUBIKS-CUBE-3OP-CORNERS-TRAINING")), new byte[]{-1, -1, -1, -1, -1, -1, -1, -1}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1}, byArray11, new byte[12]);
        byte[] byArray12 = new byte[12];
        byArray12[1] = 1;
        byArray12[2] = 2;
        byArray12[3] = 3;
        byArray12[4] = 4;
        byArray12[5] = 5;
        byArray12[6] = 6;
        byArray12[7] = 7;
        byArray12[8] = 8;
        byArray12[9] = 9;
        byArray12[10] = 10;
        byArray12[11] = 11;
        RubiksCubeRandomScrambler rubiksCube3OPCornersPermutationTraining = new RubiksCubeRandomScrambler(new ScramblerInfo("RUBIKS-CUBE-3OP-CORNERS-PERMUTATION-TRAINING", "RUBIKS-CUBE", Internationalization._("scrambler.RUBIKS-CUBE-3OP-CORNERS-PERMUTATION-TRAINING")), new byte[]{-1, -1, -1, -1, -1, -1, -1, -1}, new byte[8], byArray12, new byte[12]);
        byte[] byArray13 = new byte[8];
        byArray13[1] = 1;
        byArray13[2] = 2;
        byArray13[3] = 3;
        byArray13[4] = 4;
        byArray13[5] = 5;
        byArray13[6] = 6;
        byArray13[7] = 7;
        byte[] byArray14 = new byte[12];
        byArray14[1] = 1;
        byArray14[2] = 2;
        byArray14[3] = 3;
        byArray14[4] = 4;
        byArray14[5] = 5;
        byArray14[6] = 6;
        byArray14[7] = 7;
        byArray14[8] = 8;
        byArray14[9] = 9;
        byArray14[10] = 10;
        byArray14[11] = 11;
        RubiksCubeRandomScrambler rubiksCube3OPCornersOrientationTraining = new RubiksCubeRandomScrambler(new ScramblerInfo("RUBIKS-CUBE-3OP-CORNERS-ORIENTATION-TRAINING", "RUBIKS-CUBE", Internationalization._("scrambler.RUBIKS-CUBE-3OP-CORNERS-ORIENTATION-TRAINING")), byArray13, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1}, byArray14, new byte[12]);
        byte[] byArray15 = new byte[8];
        byArray15[1] = 1;
        byArray15[2] = 2;
        byArray15[3] = 3;
        byArray15[4] = 4;
        byArray15[5] = 5;
        byArray15[6] = 6;
        byArray15[7] = 7;
        RubiksCubeRandomScrambler rubiksCube3OPEdgesTraining = new RubiksCubeRandomScrambler(new ScramblerInfo("RUBIKS-CUBE-3OP-EDGES-TRAINING", "RUBIKS-CUBE", Internationalization._("scrambler.RUBIKS-CUBE-3OP-EDGES-TRAINING")), byArray15, new byte[8], new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1});
        byte[] byArray16 = new byte[8];
        byArray16[1] = 1;
        byArray16[2] = 2;
        byArray16[3] = 3;
        byArray16[4] = 4;
        byArray16[5] = 5;
        byArray16[6] = 6;
        byArray16[7] = 7;
        RubiksCubeRandomScrambler rubiksCube3OPEdgesPermutationTraining = new RubiksCubeRandomScrambler(new ScramblerInfo("RUBIKS-CUBE-3OP-EDGES-PERMUTATION-TRAINING", "RUBIKS-CUBE", Internationalization._("scrambler.RUBIKS-CUBE-3OP-EDGES-PERMUTATION-TRAINING")), byArray16, new byte[8], new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, new byte[12]);
        byte[] byArray17 = new byte[8];
        byArray17[1] = 1;
        byArray17[2] = 2;
        byArray17[3] = 3;
        byArray17[4] = 4;
        byArray17[5] = 5;
        byArray17[6] = 6;
        byArray17[7] = 7;
        byte[] byArray18 = new byte[12];
        byArray18[1] = 1;
        byArray18[2] = 2;
        byArray18[3] = 3;
        byArray18[4] = 4;
        byArray18[5] = 5;
        byArray18[6] = 6;
        byArray18[7] = 7;
        byArray18[8] = 8;
        byArray18[9] = 9;
        byArray18[10] = 10;
        byArray18[11] = 11;
        RubiksCubeRandomScrambler rubiksCube3OPEdgesOrientationTraining = new RubiksCubeRandomScrambler(new ScramblerInfo("RUBIKS-CUBE-3OP-EDGES-ORIENTATION-TRAINING", "RUBIKS-CUBE", Internationalization._("scrambler.RUBIKS-CUBE-3OP-EDGES-ORIENTATION-TRAINING")), byArray17, new byte[8], byArray18, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1});
        byte[] byArray19 = new byte[8];
        byArray19[1] = 1;
        byArray19[2] = 2;
        byArray19[3] = 3;
        byArray19[4] = 4;
        byArray19[5] = 5;
        byArray19[6] = 6;
        byArray19[7] = 7;
        byte[] byArray20 = new byte[12];
        byArray20[1] = 1;
        byArray20[2] = 2;
        byArray20[3] = 3;
        byArray20[4] = 4;
        byArray20[5] = 5;
        byArray20[6] = 6;
        byArray20[7] = 7;
        byArray20[8] = 8;
        byArray20[9] = 9;
        byArray20[10] = 10;
        byArray20[11] = 11;
        RubiksCubeRandomScrambler rubiksCube3OPOrientationTraining = new RubiksCubeRandomScrambler(new ScramblerInfo("RUBIKS-CUBE-3OP-ORIENTATION-TRAINING", "RUBIKS-CUBE", Internationalization._("scrambler.RUBIKS-CUBE-3OP-ORIENTATION-TRAINING")), byArray19, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1}, byArray20, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1});
        RubiksCubeRandomScrambler rubiksCube3OPPermutationTraining = new RubiksCubeRandomScrambler(new ScramblerInfo("RUBIKS-CUBE-3OP-PERMUTATION-TRAINING", "RUBIKS-CUBE", Internationalization._("scrambler.RUBIKS-CUBE-3OP-PERMUTATION-TRAINING")), new byte[]{-1, -1, -1, -1, -1, -1, -1, -1}, new byte[8], new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, new byte[12]);
        RubiksCubeSingleStickerCycleScrambler rubiksCubeBLDSingleStickerCycle = new RubiksCubeSingleStickerCycleScrambler(new ScramblerInfo("RUBIKS-CUBE-BLD-SINGLE-STICKER-CYCLE", "RUBIKS-CUBE", Internationalization._("scrambler.RUBIKS-CUBE-BLD-SINGLE-STICKER-CYCLE")));
        RubiksCubeEasyCrossScrambler rubiksCubeEasyCross = new RubiksCubeEasyCrossScrambler(new ScramblerInfo("RUBIKS-CUBE-EASY-CROSS", "RUBIKS-CUBE", Internationalization._("scrambler.RUBIKS-CUBE-EASY-CROSS")), 3);
        EmptyScrambler rubiksRevengeImporter = new EmptyScrambler(new ScramblerInfo("4x4x4-CUBE-IMPORTER", "4x4x4-CUBE", ""));
        RubiksRevengeRandomScrambler rubiksRevengeRandom = new RubiksRevengeRandomScrambler(new ScramblerInfo("4x4x4-CUBE-RANDOM", "4x4x4-CUBE", Internationalization._("scrambler.4x4x4-CUBE-RANDOM")), 40);
        EmptyScrambler professorsCubeImporter = new EmptyScrambler(new ScramblerInfo("5x5x5-CUBE-IMPORTER", "5x5x5-CUBE", ""));
        ProfessorsCubeRandomScrambler professorsCubeRandom = new ProfessorsCubeRandomScrambler(new ScramblerInfo("5x5x5-CUBE-RANDOM", "5x5x5-CUBE", Internationalization._("scrambler.5x5x5-CUBE-RANDOM")), 60);
        EmptyScrambler vCube6Importer = new EmptyScrambler(new ScramblerInfo("6x6x6-CUBE-IMPORTER", "6x6x6-CUBE", ""));
        VCube6RandomScrambler vCube6Random = new VCube6RandomScrambler(new ScramblerInfo("6x6x6-CUBE-RANDOM", "6x6x6-CUBE", Internationalization._("scrambler.6x6x6-CUBE-RANDOM")), 80);
        EmptyScrambler vCube7Importer = new EmptyScrambler(new ScramblerInfo("7x7x7-CUBE-IMPORTER", "7x7x7-CUBE", ""));
        VCube7RandomScrambler vCube7Random = new VCube7RandomScrambler(new ScramblerInfo("7x7x7-CUBE-RANDOM", "7x7x7-CUBE", Internationalization._("scrambler.7x7x7-CUBE-RANDOM")), 100);
        EmptyScrambler rubiksClockImporter = new EmptyScrambler(new ScramblerInfo("RUBIKS-CLOCK-IMPORTER", "RUBIKS-CLOCK", ""));
        RubiksClockRandomScrambler rubiksClockRandom = new RubiksClockRandomScrambler(new ScramblerInfo("RUBIKS-CLOCK-RANDOM", "RUBIKS-CLOCK", Internationalization._("scrambler.RUBIKS-CLOCK-RANDOM")));
        EmptyScrambler megaminxImporter = new EmptyScrambler(new ScramblerInfo("MEGAMINX-IMPORTER", "MEGAMINX", ""));
        MegaminxRandomScrambler megaminxRandom = new MegaminxRandomScrambler(new ScramblerInfo("MEGAMINX-RANDOM", "MEGAMINX", Internationalization._("scrambler.MEGAMINX-RANDOM")));
        EmptyScrambler pyraminxImporter = new EmptyScrambler(new ScramblerInfo("PYRAMINX-IMPORTER", "PYRAMINX", ""));
        PyraminxRandomScrambler pyraminxRandom = new PyraminxRandomScrambler(new ScramblerInfo("PYRAMINX-RANDOM", "PYRAMINX", Internationalization._("scrambler.PYRAMINX-RANDOM")), 0);
        PyraminxRandomScrambler pyraminxSuboptimalRandom = new PyraminxRandomScrambler(new ScramblerInfo("PYRAMINX-SUBOPTIMAL-RANDOM", "PYRAMINX", Internationalization._("scrambler.PYRAMINX-SUBOPTIMAL-RANDOM")), 11);
        EmptyScrambler square1Importer = new EmptyScrambler(new ScramblerInfo("SQUARE-1-IMPORTER", "SQUARE-1", ""));
        Square1RandomScrambler square1Random = new Square1RandomScrambler(new ScramblerInfo("SQUARE-1-RANDOM", "SQUARE-1", Internationalization._("scrambler.SQUARE-1-RANDOM")));
        Square1CubeShapeScrambler square1CubeShape = new Square1CubeShapeScrambler(new ScramblerInfo("SQUARE-1-CUBE-SHAPE", "SQUARE-1", Internationalization._("scrambler.SQUARE-1-CUBE-SHAPE")));
        EmptyScrambler skewbImporter = new EmptyScrambler(new ScramblerInfo("SKEWB-IMPORTER", "SKEWB", ""));
        SkewbRandomScrambler skewbRandom = new SkewbRandomScrambler(new ScramblerInfo("SKEWB-RANDOM", "SKEWB", Internationalization._("scrambler.SKEWB-RANDOM")));
        EmptyScrambler floppyCubeImporter = new EmptyScrambler(new ScramblerInfo("FLOPPY-CUBE-IMPORTER", "FLOPPY-CUBE", ""));
        FloppyCubeRandomScrambler floppyCubeRandom = new FloppyCubeRandomScrambler(new ScramblerInfo("FLOPPY-CUBE-RANDOM", "FLOPPY-CUBE", Internationalization._("scrambler.FLOPPY-CUBE-RANDOM")));
        EmptyScrambler towerCubeImporter = new EmptyScrambler(new ScramblerInfo("TOWER-CUBE-IMPORTER", "TOWER-CUBE", ""));
        TowerCubeRandomScrambler towerCubeRandom = new TowerCubeRandomScrambler(new ScramblerInfo("TOWER-CUBE-RANDOM", "TOWER-CUBE", Internationalization._("scrambler.TOWER-CUBE-RANDOM")));
        EmptyScrambler rubiksTowerImporter = new EmptyScrambler(new ScramblerInfo("RUBIKS-TOWER-IMPORTER", "RUBIKS-TOWER", ""));
        RubiksTowerRandomScrambler rubiksTowerRandom = new RubiksTowerRandomScrambler(new ScramblerInfo("RUBIKS-TOWER-RANDOM", "RUBIKS-TOWER", Internationalization._("scrambler.RUBIKS-TOWER-RANDOM")));
        EmptyScrambler rubiksDominoImporter = new EmptyScrambler(new ScramblerInfo("RUBIKS-DOMINO-IMPORTER", "RUBIKS-DOMINO", ""));
        RubiksDominoRandomScrambler rubiksDominoRandom = new RubiksDominoRandomScrambler(new ScramblerInfo("RUBIKS-DOMINO-RANDOM", "RUBIKS-DOMINO", Internationalization._("scrambler.RUBIKS-DOMINO-RANDOM")));
        EmptyScrambler otherImporter = new EmptyScrambler(new ScramblerInfo("OTHER-IMPORTER", "OTHER", ""));
        EmptyScrambler empty = new EmptyScrambler(new ScramblerInfo("EMPTY", "OTHER", Internationalization._("scrambler.EMPTY")));
        this.scramblers = new Scrambler[]{rubiksPocketCubeImporter, rubiksPocketCubeRandom, rubiksPocketCubeURF, rubiksPocketCubeSuboptimalURF, rubiksCubeImporter, rubiksCubeRandom, rubiksCubeLU, rubiksCubeRU, rubiksCubeCLLTraining, rubiksCubeELLTraining, rubiksCubeFridrichF2LTraining, rubiksCubeFridrichOLLTraining, rubiksCubeFridrichPLLTraining, rubiksCube3OPCornersTraining, rubiksCube3OPCornersPermutationTraining, rubiksCube3OPCornersOrientationTraining, rubiksCube3OPEdgesTraining, rubiksCube3OPEdgesPermutationTraining, rubiksCube3OPEdgesOrientationTraining, rubiksCube3OPOrientationTraining, rubiksCube3OPPermutationTraining, rubiksCubeBLDSingleStickerCycle, rubiksCubeEasyCross, rubiksRevengeImporter, rubiksRevengeRandom, professorsCubeImporter, professorsCubeRandom, vCube6Importer, vCube6Random, vCube7Importer, vCube7Random, rubiksClockImporter, rubiksClockRandom, megaminxImporter, megaminxRandom, pyraminxImporter, pyraminxRandom, pyraminxSuboptimalRandom, skewbImporter, skewbRandom, square1Importer, square1Random, square1CubeShape, floppyCubeImporter, floppyCubeRandom, towerCubeImporter, towerCubeRandom, rubiksTowerImporter, rubiksTowerRandom, rubiksDominoImporter, rubiksDominoRandom, otherImporter, empty};
        this.scramblerMap = new HashMap();
        Scrambler[] scramblerArray = this.scramblers;
        int n = this.scramblers.length;
        int n2 = 0;
        while (n2 < n) {
            Scrambler scrambler = scramblerArray[n2];
            this.scramblerMap.put(scrambler.getScramblerInfo().getScramblerId(), scrambler);
            ++n2;
        }
    }

    public Scrambler[] getAll() {
        ArrayList<Scrambler> scramblers = new ArrayList<Scrambler>();
        Scrambler[] scramblerArray = this.scramblers;
        int n = this.scramblers.length;
        int n2 = 0;
        while (n2 < n) {
            Scrambler scrambler = scramblerArray[n2];
            if (!scrambler.getScramblerInfo().getScramblerId().endsWith("-IMPORTER")) {
                scramblers.add(scrambler);
            }
            ++n2;
        }
        Scrambler[] scramblersArray = new Scrambler[scramblers.size()];
        scramblers.toArray(scramblersArray);
        return scramblersArray;
    }

    public Scrambler get(String scramblerId) {
        return this.scramblerMap.get(scramblerId);
    }
}

