/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.solvers;

import com.puzzletimer.solvers.IndexMapping;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

public class FloppyCubeSolver {
    private static int N_CORNERS_PERMUTATION;
    private static int N_EDGES_ORIENTATION;
    private static int[][] distance;

    static {
        int nVisited;
        N_CORNERS_PERMUTATION = 24;
        N_EDGES_ORIENTATION = 16;
        distance = new int[N_CORNERS_PERMUTATION][N_EDGES_ORIENTATION];
        int i = 0;
        while (i < distance.length) {
            int j = 0;
            while (j < distance[i].length) {
                FloppyCubeSolver.distance[i][j] = -1;
                ++j;
            }
            ++i;
        }
        FloppyCubeSolver.distance[0][0] = 0;
        int depth = 0;
        do {
            nVisited = 0;
            int i2 = 0;
            while (i2 < N_CORNERS_PERMUTATION) {
                int j = 0;
                while (j < N_EDGES_ORIENTATION) {
                    if (distance[i2][j] == depth) {
                        State state = new State(IndexMapping.indexToPermutation(i2, 4), IndexMapping.indexToOrientation(j, 2, 4));
                        String[] stringArray = new String[]{"U", "R", "D", "L"};
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int edgesOrientationIndex;
                            String move = stringArray[n2];
                            State newState = state.multiply(State.moves.get(move));
                            int cornersPermutationIndex = IndexMapping.permutationToIndex(newState.cornersPermutation);
                            if (distance[cornersPermutationIndex][edgesOrientationIndex = IndexMapping.orientationToIndex(newState.edgesOrientation, 2)] == -1) {
                                FloppyCubeSolver.distance[cornersPermutationIndex][edgesOrientationIndex] = depth + 1;
                                ++nVisited;
                            }
                            ++n2;
                        }
                    }
                    ++j;
                }
                ++i2;
            }
            ++depth;
        } while (nVisited > 0);
    }

    public static String[] solve(State state) {
        int edgesOrientationIndex;
        int cornersPermutationIndex;
        ArrayList<String> sequence = new ArrayList<String>();
        block0: while (distance[cornersPermutationIndex = IndexMapping.permutationToIndex(state.cornersPermutation)][edgesOrientationIndex = IndexMapping.orientationToIndex(state.edgesOrientation, 2)] != 0) {
            String[] stringArray = new String[]{"U", "D", "L", "R"};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                int nextEdgesOrientationIndex;
                String move = stringArray[n2];
                State nextState = state.multiply(State.moves.get(move));
                int nextCornersPermutationIndex = IndexMapping.permutationToIndex(nextState.cornersPermutation);
                if (distance[nextCornersPermutationIndex][nextEdgesOrientationIndex = IndexMapping.orientationToIndex(nextState.edgesOrientation, 2)] == distance[cornersPermutationIndex][edgesOrientationIndex] - 1) {
                    sequence.add(move);
                    state = nextState;
                    continue block0;
                }
                ++n2;
            }
        }
        String[] sequenceArray = new String[sequence.size()];
        sequence.toArray(sequenceArray);
        return sequenceArray;
    }

    public static String[] generate(State state) {
        String[] solution = FloppyCubeSolver.solve(state);
        String[] sequence = new String[solution.length];
        int i = 0;
        while (i < sequence.length) {
            sequence[i] = solution[solution.length - 1 - i];
            ++i;
        }
        return sequence;
    }

    public static State getRandomState(Random random) {
        int edgesOrientationIndex;
        int cornersPermutationIndex;
        while (distance[cornersPermutationIndex = random.nextInt(N_CORNERS_PERMUTATION)][edgesOrientationIndex = random.nextInt(N_EDGES_ORIENTATION)] < 0) {
        }
        byte[] cornersPermutation = IndexMapping.indexToPermutation(cornersPermutationIndex, 4);
        byte[] edgesOrientation = IndexMapping.indexToOrientation(edgesOrientationIndex, 2, 4);
        return new State(cornersPermutation, edgesOrientation);
    }

    public static class State {
        public byte[] cornersPermutation;
        public byte[] edgesOrientation;
        public static HashMap<String, State> moves = new HashMap();

        static {
            byte[] byArray = new byte[4];
            byArray[0] = 1;
            byArray[2] = 2;
            byArray[3] = 3;
            byte[] byArray2 = new byte[4];
            byArray2[0] = 1;
            moves.put("U", new State(byArray, byArray2));
            byte[] byArray3 = new byte[4];
            byArray3[1] = 2;
            byArray3[2] = 1;
            byArray3[3] = 3;
            byte[] byArray4 = new byte[4];
            byArray4[1] = 1;
            moves.put("R", new State(byArray3, byArray4));
            byte[] byArray5 = new byte[4];
            byArray5[1] = 1;
            byArray5[2] = 3;
            byArray5[3] = 2;
            byte[] byArray6 = new byte[4];
            byArray6[2] = 1;
            moves.put("D", new State(byArray5, byArray6));
            byte[] byArray7 = new byte[4];
            byArray7[0] = 3;
            byArray7[1] = 1;
            byArray7[2] = 2;
            byte[] byArray8 = new byte[4];
            byArray8[3] = 1;
            moves.put("L", new State(byArray7, byArray8));
        }

        public State(byte[] cornersPermutation, byte[] edgesOrientation) {
            this.cornersPermutation = cornersPermutation;
            this.edgesOrientation = edgesOrientation;
        }

        public State multiply(State move) {
            byte[] cornersPermutation = new byte[4];
            int i = 0;
            while (i < 4) {
                cornersPermutation[i] = this.cornersPermutation[move.cornersPermutation[i]];
                ++i;
            }
            byte[] edgesOrientation = new byte[4];
            int i2 = 0;
            while (i2 < 4) {
                edgesOrientation[i2] = (byte)((this.edgesOrientation[i2] + move.edgesOrientation[i2]) % 2);
                ++i2;
            }
            return new State(cornersPermutation, edgesOrientation);
        }
    }
}

