/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.solvers;

import com.puzzletimer.solvers.IndexMapping;
import com.puzzletimer.solvers.RubiksCubeSolver;
import java.util.ArrayList;

public class RubiksCubeCrossSolver {
    private static String[] moveNames;
    private static RubiksCubeSolver.State[] moves;
    private static int N_EDGES_COMBINATIONS;
    private static int N_EDGES_PERMUTATIONS;
    private static int N_EDGES_ORIENTATIONS;
    private static int goalEdgesPermutation;
    private static int goalEdgesOrientation;
    private static int[][] edgesPermutationMove;
    private static int[][] edgesOrientationMove;
    private static byte[] edgesPermutationDistance;
    private static byte[] edgesOrientationDistance;

    static {
        int j;
        int[] indices;
        int k;
        RubiksCubeSolver.State state;
        int j2;
        moveNames = new String[]{"U", "U2", "U'", "D", "D2", "D'", "L", "L2", "L'", "R", "R2", "R'", "F", "F2", "F'", "B", "B2", "B'"};
        moves = new RubiksCubeSolver.State[moveNames.length];
        int i = 0;
        while (i < moves.length) {
            RubiksCubeCrossSolver.moves[i] = RubiksCubeSolver.State.moves.get(moveNames[i]);
            ++i;
        }
        N_EDGES_COMBINATIONS = 495;
        N_EDGES_PERMUTATIONS = 24;
        N_EDGES_ORIENTATIONS = 16;
        int[] goalIndices = RubiksCubeCrossSolver.stateToIndices(RubiksCubeSolver.State.id);
        goalEdgesPermutation = goalIndices[0] * N_EDGES_PERMUTATIONS + goalIndices[1];
        goalEdgesOrientation = goalIndices[0] * N_EDGES_ORIENTATIONS + goalIndices[2];
        edgesPermutationMove = new int[N_EDGES_COMBINATIONS * N_EDGES_PERMUTATIONS][moves.length];
        i = 0;
        while (i < N_EDGES_COMBINATIONS) {
            j2 = 0;
            while (j2 < N_EDGES_PERMUTATIONS) {
                int[] nArray = new int[3];
                nArray[0] = i;
                nArray[1] = j2;
                state = RubiksCubeCrossSolver.indicesToState(nArray);
                k = 0;
                while (k < moves.length) {
                    indices = RubiksCubeCrossSolver.stateToIndices(state.multiply(moves[k]));
                    RubiksCubeCrossSolver.edgesPermutationMove[i * RubiksCubeCrossSolver.N_EDGES_PERMUTATIONS + j2][k] = indices[0] * N_EDGES_PERMUTATIONS + indices[1];
                    ++k;
                }
                ++j2;
            }
            ++i;
        }
        edgesOrientationMove = new int[N_EDGES_COMBINATIONS * N_EDGES_ORIENTATIONS][moves.length];
        i = 0;
        while (i < N_EDGES_COMBINATIONS) {
            j2 = 0;
            while (j2 < N_EDGES_ORIENTATIONS) {
                int[] nArray = new int[3];
                nArray[0] = i;
                nArray[2] = j2;
                state = RubiksCubeCrossSolver.indicesToState(nArray);
                k = 0;
                while (k < moves.length) {
                    indices = RubiksCubeCrossSolver.stateToIndices(state.multiply(moves[k]));
                    RubiksCubeCrossSolver.edgesOrientationMove[i * RubiksCubeCrossSolver.N_EDGES_ORIENTATIONS + j2][k] = indices[0] * N_EDGES_ORIENTATIONS + indices[2];
                    ++k;
                }
                ++j2;
            }
            ++i;
        }
        edgesPermutationDistance = new byte[N_EDGES_COMBINATIONS * N_EDGES_PERMUTATIONS];
        i = 0;
        while (i < edgesPermutationDistance.length) {
            RubiksCubeCrossSolver.edgesPermutationDistance[i] = -1;
            ++i;
        }
        RubiksCubeCrossSolver.edgesPermutationDistance[RubiksCubeCrossSolver.goalEdgesPermutation] = 0;
        int distance = 0;
        int nVisited = 1;
        while (nVisited < N_EDGES_COMBINATIONS * N_EDGES_PERMUTATIONS) {
            int i2 = 0;
            while (i2 < edgesPermutationDistance.length) {
                if (edgesPermutationDistance[i2] == distance) {
                    j = 0;
                    while (j < edgesPermutationMove[i2].length) {
                        int next = edgesPermutationMove[i2][j];
                        if (edgesPermutationDistance[next] < 0) {
                            RubiksCubeCrossSolver.edgesPermutationDistance[next] = (byte)(distance + 1);
                            ++nVisited;
                        }
                        ++j;
                    }
                }
                ++i2;
            }
            ++distance;
        }
        edgesOrientationDistance = new byte[N_EDGES_COMBINATIONS * N_EDGES_ORIENTATIONS];
        int i3 = 0;
        while (i3 < edgesOrientationDistance.length) {
            RubiksCubeCrossSolver.edgesOrientationDistance[i3] = -1;
            ++i3;
        }
        RubiksCubeCrossSolver.edgesOrientationDistance[RubiksCubeCrossSolver.goalEdgesOrientation] = 0;
        distance = 0;
        nVisited = 1;
        while (nVisited < N_EDGES_COMBINATIONS * N_EDGES_ORIENTATIONS) {
            i3 = 0;
            while (i3 < edgesOrientationDistance.length) {
                if (edgesOrientationDistance[i3] == distance) {
                    j = 0;
                    while (j < edgesOrientationMove[i3].length) {
                        int next = edgesOrientationMove[i3][j];
                        if (edgesOrientationDistance[next] < 0) {
                            RubiksCubeCrossSolver.edgesOrientationDistance[next] = (byte)(distance + 1);
                            ++nVisited;
                        }
                        ++j;
                    }
                }
                ++i3;
            }
            ++distance;
        }
    }

    private static int[] stateToIndices(RubiksCubeSolver.State state) {
        boolean[] blArray = new boolean[12];
        blArray[8] = true;
        blArray[9] = true;
        blArray[10] = true;
        blArray[11] = true;
        boolean[] selectedEdges = blArray;
        byte[] byArray = new byte[12];
        byArray[0] = -1;
        byArray[1] = -1;
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = -1;
        byArray[7] = -1;
        byArray[9] = 1;
        byArray[10] = 2;
        byArray[11] = 3;
        byte[] edgesMapping = byArray;
        boolean[] edgesCombination = new boolean[state.edgesPermutation.length];
        int i = 0;
        while (i < edgesCombination.length) {
            edgesCombination[i] = selectedEdges[state.edgesPermutation[i]];
            ++i;
        }
        int edgesCombinationIndex = IndexMapping.combinationToIndex(edgesCombination, 4);
        byte[] edgesPermutation = new byte[4];
        byte[] edgesOrientation = new byte[4];
        int next = 0;
        int i2 = 0;
        while (i2 < state.edgesPermutation.length) {
            if (edgesCombination[i2]) {
                edgesPermutation[next] = edgesMapping[state.edgesPermutation[i2]];
                edgesOrientation[next] = state.edgesOrientation[i2];
                ++next;
            }
            ++i2;
        }
        int edgesPermutationIndex = IndexMapping.permutationToIndex(edgesPermutation);
        int edgesOrientationIndex = IndexMapping.orientationToIndex(edgesOrientation, 2);
        return new int[]{edgesCombinationIndex, edgesPermutationIndex, edgesOrientationIndex};
    }

    private static RubiksCubeSolver.State indicesToState(int[] indices) {
        boolean[] combination = IndexMapping.indexToCombination(indices[0], 4, 12);
        byte[] permutation = IndexMapping.indexToPermutation(indices[1], 4);
        byte[] orientation = IndexMapping.indexToOrientation(indices[2], 2, 4);
        byte[] selectedEdges = new byte[]{8, 9, 10, 11};
        int nextSelectedEdgeIndex = 0;
        byte[] byArray = new byte[8];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        byte[] otherEdges = byArray;
        int nextOtherEdgeIndex = 0;
        byte[] edgesPermutation = new byte[12];
        byte[] edgesOrientation = new byte[12];
        int i = 0;
        while (i < edgesPermutation.length) {
            if (combination[i]) {
                edgesPermutation[i] = selectedEdges[permutation[nextSelectedEdgeIndex]];
                edgesOrientation[i] = orientation[nextSelectedEdgeIndex];
                ++nextSelectedEdgeIndex;
            } else {
                edgesPermutation[i] = otherEdges[nextOtherEdgeIndex];
                edgesOrientation[i] = 0;
                ++nextOtherEdgeIndex;
            }
            ++i;
        }
        return new RubiksCubeSolver.State(RubiksCubeSolver.State.id.cornersPermutation, RubiksCubeSolver.State.id.cornersOrientation, edgesPermutation, edgesOrientation);
    }

    public static ArrayList<String[]> solve(RubiksCubeSolver.State state) {
        int[] indices = RubiksCubeCrossSolver.stateToIndices(state);
        int edgesPermutationIndex = indices[0] * N_EDGES_PERMUTATIONS + indices[1];
        int edgesOrientationIndex = indices[0] * N_EDGES_ORIENTATIONS + indices[2];
        ArrayList<String[]> solutions = new ArrayList<String[]>();
        int depth = 0;
        while (true) {
            int[] path = new int[depth];
            RubiksCubeCrossSolver.search(edgesPermutationIndex, edgesOrientationIndex, depth, path, solutions);
            if (solutions.size() > 0) {
                return solutions;
            }
            ++depth;
        }
    }

    private static void search(int edgesPermutation, int edgesOrientation, int depth, int[] path, ArrayList<String[]> solutions) {
        if (depth == 0) {
            if (edgesPermutation == goalEdgesPermutation && edgesOrientation == goalEdgesOrientation) {
                String[] sequence = new String[path.length];
                int i = 0;
                while (i < sequence.length) {
                    sequence[i] = moveNames[path[i]];
                    ++i;
                }
                solutions.add(sequence);
            }
            return;
        }
        if (edgesPermutationDistance[edgesPermutation] > depth || edgesOrientationDistance[edgesOrientation] > depth) {
            return;
        }
        int i = 0;
        while (i < moves.length) {
            path[path.length - depth] = i;
            RubiksCubeCrossSolver.search(edgesPermutationMove[edgesPermutation][i], edgesOrientationMove[edgesOrientation][i], depth - 1, path, solutions);
            ++i;
        }
    }
}

