/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.solvers;

import com.puzzletimer.solvers.IndexMapping;
import com.puzzletimer.solvers.RubiksCubeSolver;
import java.util.HashMap;
import java.util.Random;

public class RubiksCubeRUSolver {
    private static String[] moveNames;
    private static RubiksCubeSolver.State[] moves;
    private static int N_CORNERS_PERMUTATIONS;
    private static int N_CORNERS_ORIENTATIONS;
    private static int N_EDGES_PERMUTATIONS;
    private static int N_EDGES_ORIENTATIONS;
    private static int goalCornersPermutation;
    private static int goalCornersOrientation;
    private static int goalEdgesPermutation;
    private static int goalEdgesOrientation;
    private static int[][] cornersPermutationMove;
    private static int[][] cornersOrientationMove;
    private static int[][] edgesPermutationMove;
    private static int[][] edgesOrientationMove;
    private static byte[][] cornersDistance;
    private static byte[][] edgesDistance;

    static {
        int nextOrientation;
        int nextPermutation;
        int k;
        int i;
        int nVisited;
        int[] indices;
        int j;
        RubiksCubeSolver.State state;
        moveNames = new String[]{"U", "U2", "U'", "R", "R2", "R'"};
        moves = new RubiksCubeSolver.State[moveNames.length];
        int i2 = 0;
        while (i2 < moves.length) {
            RubiksCubeRUSolver.moves[i2] = RubiksCubeSolver.State.moves.get(moveNames[i2]);
            ++i2;
        }
        N_CORNERS_PERMUTATIONS = 720;
        N_CORNERS_ORIENTATIONS = 729;
        N_EDGES_PERMUTATIONS = 5040;
        N_EDGES_ORIENTATIONS = 128;
        int[] goalIndices = RubiksCubeRUSolver.stateToIndices(RubiksCubeSolver.State.id);
        goalCornersPermutation = goalIndices[0];
        goalCornersOrientation = goalIndices[1];
        goalEdgesPermutation = goalIndices[2];
        goalEdgesOrientation = goalIndices[3];
        cornersPermutationMove = new int[N_CORNERS_PERMUTATIONS][moves.length];
        i = 0;
        while (i < N_CORNERS_PERMUTATIONS) {
            int[] nArray = new int[4];
            nArray[0] = i;
            state = RubiksCubeRUSolver.indicesToState(nArray);
            j = 0;
            while (j < moves.length) {
                indices = RubiksCubeRUSolver.stateToIndices(state.multiply(moves[j]));
                RubiksCubeRUSolver.cornersPermutationMove[i][j] = indices[0];
                ++j;
            }
            ++i;
        }
        cornersOrientationMove = new int[N_CORNERS_ORIENTATIONS][moves.length];
        i = 0;
        while (i < N_CORNERS_ORIENTATIONS) {
            int[] nArray = new int[4];
            nArray[1] = i;
            state = RubiksCubeRUSolver.indicesToState(nArray);
            j = 0;
            while (j < moves.length) {
                indices = RubiksCubeRUSolver.stateToIndices(state.multiply(moves[j]));
                RubiksCubeRUSolver.cornersOrientationMove[i][j] = indices[1];
                ++j;
            }
            ++i;
        }
        edgesPermutationMove = new int[N_EDGES_PERMUTATIONS][moves.length];
        i = 0;
        while (i < N_EDGES_PERMUTATIONS) {
            int[] nArray = new int[4];
            nArray[2] = i;
            state = RubiksCubeRUSolver.indicesToState(nArray);
            j = 0;
            while (j < moves.length) {
                indices = RubiksCubeRUSolver.stateToIndices(state.multiply(moves[j]));
                RubiksCubeRUSolver.edgesPermutationMove[i][j] = indices[2];
                ++j;
            }
            ++i;
        }
        edgesOrientationMove = new int[N_EDGES_ORIENTATIONS][moves.length];
        i = 0;
        while (i < N_EDGES_ORIENTATIONS) {
            int[] nArray = new int[4];
            nArray[3] = i;
            state = RubiksCubeRUSolver.indicesToState(nArray);
            j = 0;
            while (j < moves.length) {
                indices = RubiksCubeRUSolver.stateToIndices(state.multiply(moves[j]));
                RubiksCubeRUSolver.edgesOrientationMove[i][j] = indices[3];
                ++j;
            }
            ++i;
        }
        cornersDistance = new byte[N_CORNERS_PERMUTATIONS][N_CORNERS_ORIENTATIONS];
        i = 0;
        while (i < cornersDistance.length) {
            int j2 = 0;
            while (j2 < cornersDistance[i].length) {
                RubiksCubeRUSolver.cornersDistance[i][j2] = -1;
                ++j2;
            }
            ++i;
        }
        RubiksCubeRUSolver.cornersDistance[RubiksCubeRUSolver.goalCornersPermutation][RubiksCubeRUSolver.goalCornersOrientation] = 0;
        int distance = 0;
        do {
            nVisited = 0;
            i = 0;
            while (i < cornersDistance.length) {
                int j3 = 0;
                while (j3 < cornersDistance[i].length) {
                    if (cornersDistance[i][j3] == distance) {
                        k = 0;
                        while (k < cornersPermutationMove[i].length) {
                            nextPermutation = cornersPermutationMove[i][k];
                            nextOrientation = cornersOrientationMove[j3][k];
                            if (cornersDistance[nextPermutation][nextOrientation] < 0) {
                                RubiksCubeRUSolver.cornersDistance[nextPermutation][nextOrientation] = (byte)(distance + 1);
                                ++nVisited;
                            }
                            ++k;
                        }
                    }
                    ++j3;
                }
                ++i;
            }
            ++distance;
        } while (nVisited > 0);
        edgesDistance = new byte[N_EDGES_PERMUTATIONS][N_EDGES_ORIENTATIONS];
        i = 0;
        while (i < edgesDistance.length) {
            int j4 = 0;
            while (j4 < edgesDistance[i].length) {
                RubiksCubeRUSolver.edgesDistance[i][j4] = -1;
                ++j4;
            }
            ++i;
        }
        RubiksCubeRUSolver.edgesDistance[RubiksCubeRUSolver.goalEdgesPermutation][RubiksCubeRUSolver.goalEdgesOrientation] = 0;
        distance = 0;
        do {
            nVisited = 0;
            i = 0;
            while (i < edgesDistance.length) {
                int j5 = 0;
                while (j5 < edgesDistance[i].length) {
                    if (edgesDistance[i][j5] == distance) {
                        k = 0;
                        while (k < edgesPermutationMove[i].length) {
                            nextPermutation = edgesPermutationMove[i][k];
                            nextOrientation = edgesOrientationMove[j5][k];
                            if (edgesDistance[nextPermutation][nextOrientation] < 0) {
                                RubiksCubeRUSolver.edgesDistance[nextPermutation][nextOrientation] = (byte)(distance + 1);
                                ++nVisited;
                            }
                            ++k;
                        }
                    }
                    ++j5;
                }
                ++i;
            }
            ++distance;
        } while (nVisited > 0);
    }

    private static int[] stateToIndices(RubiksCubeSolver.State state) {
        boolean[] blArray = new boolean[8];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[5] = true;
        blArray[6] = true;
        boolean[] selectedCorners = blArray;
        byte[] byArray = new byte[8];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = -1;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = -1;
        byte[] cornersMapping = byArray;
        byte[] cornersPermutation = new byte[6];
        byte[] cornersOrientation = new byte[6];
        int next = 0;
        int i = 0;
        while (i < state.cornersPermutation.length) {
            if (selectedCorners[i]) {
                cornersPermutation[next] = cornersMapping[state.cornersPermutation[i]];
                cornersOrientation[next] = state.cornersOrientation[i];
                ++next;
            }
            ++i;
        }
        int cornersPermutationIndex = IndexMapping.permutationToIndex(cornersPermutation);
        int cornersOrientationIndex = IndexMapping.orientationToIndex(cornersOrientation, 3);
        boolean[] blArray2 = new boolean[12];
        blArray2[1] = true;
        blArray2[2] = true;
        blArray2[4] = true;
        blArray2[5] = true;
        blArray2[6] = true;
        blArray2[7] = true;
        blArray2[9] = true;
        boolean[] selectedEdges = blArray2;
        byte[] byArray2 = new byte[12];
        byArray2[0] = -1;
        byArray2[2] = 1;
        byArray2[3] = -1;
        byArray2[4] = 2;
        byArray2[5] = 3;
        byArray2[6] = 4;
        byArray2[7] = 5;
        byArray2[8] = -1;
        byArray2[9] = 6;
        byArray2[10] = -1;
        byArray2[11] = -1;
        byte[] edgesMapping = byArray2;
        byte[] edgesPermutation = new byte[7];
        byte[] edgesOrientation = new byte[7];
        next = 0;
        int i2 = 0;
        while (i2 < state.edgesPermutation.length) {
            if (selectedEdges[i2]) {
                edgesPermutation[next] = edgesMapping[state.edgesPermutation[i2]];
                edgesOrientation[next] = state.edgesOrientation[i2];
                ++next;
            }
            ++i2;
        }
        int edgesPermutationIndex = IndexMapping.permutationToIndex(edgesPermutation);
        int edgesOrientationIndex = IndexMapping.orientationToIndex(edgesOrientation, 2);
        return new int[]{cornersPermutationIndex, cornersOrientationIndex, edgesPermutationIndex, edgesOrientationIndex};
    }

    private static RubiksCubeSolver.State indicesToState(int[] indices) {
        boolean[] blArray = new boolean[8];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[5] = true;
        blArray[6] = true;
        boolean[] combination = blArray;
        byte[] permutation = IndexMapping.indexToPermutation(indices[0], 6);
        byte[] orientation = IndexMapping.indexToOrientation(indices[1], 3, 6);
        byte[] byArray = new byte[6];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 5;
        byArray[5] = 6;
        byte[] selectedCorners = byArray;
        int nextSelectedCornerIndex = 0;
        byte[] otherCorners = new byte[]{4, 7};
        int nextOtherCornerIndex = 0;
        byte[] cornersPermutation = new byte[8];
        byte[] cornersOrientation = new byte[8];
        int i = 0;
        while (i < cornersPermutation.length) {
            if (combination[i]) {
                cornersPermutation[i] = selectedCorners[permutation[nextSelectedCornerIndex]];
                cornersOrientation[i] = orientation[nextSelectedCornerIndex];
                ++nextSelectedCornerIndex;
            } else {
                cornersPermutation[i] = otherCorners[nextOtherCornerIndex];
                cornersOrientation[i] = 0;
                ++nextOtherCornerIndex;
            }
            ++i;
        }
        boolean[] blArray2 = new boolean[12];
        blArray2[1] = true;
        blArray2[2] = true;
        blArray2[4] = true;
        blArray2[5] = true;
        blArray2[6] = true;
        blArray2[7] = true;
        blArray2[9] = true;
        combination = blArray2;
        permutation = IndexMapping.indexToPermutation(indices[2], 7);
        orientation = IndexMapping.indexToOrientation(indices[3], 2, 7);
        byte[] selectedEdges = new byte[]{1, 2, 4, 5, 6, 7, 9};
        int nextSelectedEdgeIndex = 0;
        byte[] byArray2 = new byte[5];
        byArray2[1] = 3;
        byArray2[2] = 8;
        byArray2[3] = 10;
        byArray2[4] = 11;
        byte[] otherEdges = byArray2;
        int nextOtherEdgeIndex = 0;
        byte[] edgesPermutation = new byte[12];
        byte[] edgesOrientation = new byte[12];
        int i2 = 0;
        while (i2 < edgesPermutation.length) {
            if (combination[i2]) {
                edgesPermutation[i2] = selectedEdges[permutation[nextSelectedEdgeIndex]];
                edgesOrientation[i2] = orientation[nextSelectedEdgeIndex];
                ++nextSelectedEdgeIndex;
            } else {
                edgesPermutation[i2] = otherEdges[nextOtherEdgeIndex];
                edgesOrientation[i2] = 0;
                ++nextOtherEdgeIndex;
            }
            ++i2;
        }
        return new RubiksCubeSolver.State(cornersPermutation, cornersOrientation, edgesPermutation, edgesOrientation);
    }

    public static String[] solve(RubiksCubeSolver.State state) {
        int[] indices = RubiksCubeRUSolver.stateToIndices(state);
        int depth = 0;
        while (true) {
            int[] solution;
            if (RubiksCubeRUSolver.search(indices[0], indices[1], indices[2], indices[3], depth, solution = new int[depth])) {
                String[] sequence = new String[solution.length];
                int i = 0;
                while (i < sequence.length) {
                    sequence[i] = moveNames[solution[i]];
                    ++i;
                }
                return sequence;
            }
            ++depth;
        }
    }

    private static boolean search(int cornersPermutation, int cornersOrientation, int edgesPermutation, int edgesOrientation, int depth, int[] solution) {
        if (depth == 0) {
            return cornersPermutation == goalCornersPermutation && cornersOrientation == goalCornersOrientation && edgesPermutation == goalEdgesPermutation && edgesOrientation == goalEdgesOrientation;
        }
        if (cornersDistance[cornersPermutation][cornersOrientation] > depth || edgesDistance[edgesPermutation][edgesOrientation] > depth) {
            return false;
        }
        int i = 0;
        while (i < moves.length) {
            if (solution.length - depth <= 0 || solution[solution.length - depth - 1] / 3 != i / 3) {
                solution[solution.length - depth] = i;
                if (RubiksCubeRUSolver.search(cornersPermutationMove[cornersPermutation][i], cornersOrientationMove[cornersOrientation][i], edgesPermutationMove[edgesPermutation][i], edgesOrientationMove[edgesOrientation][i], depth - 1, solution)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public static String[] generate(RubiksCubeSolver.State state) {
        HashMap<String, String> inverseMoveNames = new HashMap<String, String>();
        inverseMoveNames.put("U", "U'");
        inverseMoveNames.put("U2", "U2");
        inverseMoveNames.put("U'", "U");
        inverseMoveNames.put("R", "R'");
        inverseMoveNames.put("R2", "R2");
        inverseMoveNames.put("R'", "R");
        String[] solution = RubiksCubeRUSolver.solve(state);
        String[] sequence = new String[solution.length];
        int i = 0;
        while (i < solution.length) {
            sequence[i] = (String)inverseMoveNames.get(solution[solution.length - i - 1]);
            ++i;
        }
        return sequence;
    }

    public static RubiksCubeSolver.State getRandomState(Random random) {
        RubiksCubeSolver.State state;
        while (true) {
            int cornersPermutation = random.nextInt(N_CORNERS_PERMUTATIONS);
            int cornersOrientation = random.nextInt(N_CORNERS_ORIENTATIONS);
            int edgesPermutation = random.nextInt(N_EDGES_PERMUTATIONS);
            int edgesOrientation = random.nextInt(N_EDGES_ORIENTATIONS);
            if (cornersDistance[cornersPermutation][cornersOrientation] < 0 || edgesDistance[edgesPermutation][edgesOrientation] < 0) continue;
            state = RubiksCubeRUSolver.indicesToState(new int[]{cornersPermutation, cornersOrientation, edgesPermutation, edgesOrientation});
            if (RubiksCubeRUSolver.permutationSign(state.cornersPermutation) == RubiksCubeRUSolver.permutationSign(state.edgesPermutation)) break;
        }
        return state;
    }

    private static int permutationSign(byte[] permutation) {
        int nInversions = 0;
        int i = 0;
        while (i < permutation.length) {
            int j = i + 1;
            while (j < permutation.length) {
                if (permutation[i] > permutation[j]) {
                    ++nInversions;
                }
                ++j;
            }
            ++i;
        }
        return nInversions % 2 == 0 ? 1 : -1;
    }
}

