/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.solvers;

import com.puzzletimer.solvers.IndexMapping;
import com.puzzletimer.solvers.RubiksCubeSolver;
import java.util.ArrayList;

public class RubiksCubeXCrossSolver {
    private static String[] moveNames;
    private static RubiksCubeSolver.State[] moves;
    private static int N_CORNERS_COMBINATIONS;
    private static int N_CORNERS_PERMUTATIONS;
    private static int N_CORNERS_ORIENTATIONS;
    private static int N_EDGES_COMBINATIONS;
    private static int N_EDGES_PERMUTATIONS;
    private static int N_EDGES_ORIENTATIONS;
    private static int goalCornersPermutation;
    private static int goalCornersOrientation;
    private static int goalEdgesPermutation;
    private static int goalEdgesOrientation;
    private static int[][] cornersPermutationMove;
    private static int[][] cornersOrientationMove;
    private static int[][] edgesPermutationMove;
    private static int[][] edgesOrientationMove;
    private static byte[] edgesPermutationDistance;
    private static byte[] edgesOrientationDistance;

    static {
        int j;
        int[] indices;
        int k;
        RubiksCubeSolver.State state;
        int j2;
        moveNames = new String[]{"U", "U2", "U'", "D", "D2", "D'", "L", "L2", "L'", "R", "R2", "R'", "F", "F2", "F'", "B", "B2", "B'"};
        moves = new RubiksCubeSolver.State[moveNames.length];
        int i = 0;
        while (i < moves.length) {
            RubiksCubeXCrossSolver.moves[i] = RubiksCubeSolver.State.moves.get(moveNames[i]);
            ++i;
        }
        N_CORNERS_COMBINATIONS = 8;
        N_CORNERS_PERMUTATIONS = 1;
        N_CORNERS_ORIENTATIONS = 3;
        N_EDGES_COMBINATIONS = 792;
        N_EDGES_PERMUTATIONS = 120;
        N_EDGES_ORIENTATIONS = 32;
        int[] goalIndices = RubiksCubeXCrossSolver.stateToIndices(RubiksCubeSolver.State.id);
        goalCornersPermutation = goalIndices[0] * N_CORNERS_PERMUTATIONS + goalIndices[1];
        goalCornersOrientation = goalIndices[0] * N_CORNERS_ORIENTATIONS + goalIndices[2];
        goalEdgesPermutation = goalIndices[3] * N_EDGES_PERMUTATIONS + goalIndices[4];
        goalEdgesOrientation = goalIndices[3] * N_EDGES_ORIENTATIONS + goalIndices[5];
        cornersPermutationMove = new int[N_CORNERS_COMBINATIONS * N_CORNERS_PERMUTATIONS][moves.length];
        i = 0;
        while (i < N_CORNERS_COMBINATIONS) {
            j2 = 0;
            while (j2 < N_CORNERS_PERMUTATIONS) {
                int[] nArray = new int[6];
                nArray[0] = i;
                nArray[1] = j2;
                state = RubiksCubeXCrossSolver.indicesToState(nArray);
                k = 0;
                while (k < moves.length) {
                    indices = RubiksCubeXCrossSolver.stateToIndices(state.multiply(moves[k]));
                    RubiksCubeXCrossSolver.cornersPermutationMove[i * RubiksCubeXCrossSolver.N_CORNERS_PERMUTATIONS + j2][k] = indices[0] * N_CORNERS_PERMUTATIONS + indices[1];
                    ++k;
                }
                ++j2;
            }
            ++i;
        }
        cornersOrientationMove = new int[N_CORNERS_COMBINATIONS * N_CORNERS_ORIENTATIONS][moves.length];
        i = 0;
        while (i < N_CORNERS_COMBINATIONS) {
            j2 = 0;
            while (j2 < N_CORNERS_ORIENTATIONS) {
                int[] nArray = new int[6];
                nArray[0] = i;
                nArray[2] = j2;
                state = RubiksCubeXCrossSolver.indicesToState(nArray);
                k = 0;
                while (k < moves.length) {
                    indices = RubiksCubeXCrossSolver.stateToIndices(state.multiply(moves[k]));
                    RubiksCubeXCrossSolver.cornersOrientationMove[i * RubiksCubeXCrossSolver.N_CORNERS_ORIENTATIONS + j2][k] = indices[0] * N_CORNERS_ORIENTATIONS + indices[2];
                    ++k;
                }
                ++j2;
            }
            ++i;
        }
        edgesPermutationMove = new int[N_EDGES_COMBINATIONS * N_EDGES_PERMUTATIONS][moves.length];
        i = 0;
        while (i < N_EDGES_COMBINATIONS) {
            j2 = 0;
            while (j2 < N_EDGES_PERMUTATIONS) {
                int[] nArray = new int[6];
                nArray[3] = i;
                nArray[4] = j2;
                state = RubiksCubeXCrossSolver.indicesToState(nArray);
                k = 0;
                while (k < moves.length) {
                    indices = RubiksCubeXCrossSolver.stateToIndices(state.multiply(moves[k]));
                    RubiksCubeXCrossSolver.edgesPermutationMove[i * RubiksCubeXCrossSolver.N_EDGES_PERMUTATIONS + j2][k] = indices[3] * N_EDGES_PERMUTATIONS + indices[4];
                    ++k;
                }
                ++j2;
            }
            ++i;
        }
        edgesOrientationMove = new int[N_EDGES_COMBINATIONS * N_EDGES_ORIENTATIONS][moves.length];
        i = 0;
        while (i < N_EDGES_COMBINATIONS) {
            j2 = 0;
            while (j2 < N_EDGES_ORIENTATIONS) {
                int[] nArray = new int[6];
                nArray[3] = i;
                nArray[5] = j2;
                state = RubiksCubeXCrossSolver.indicesToState(nArray);
                k = 0;
                while (k < moves.length) {
                    indices = RubiksCubeXCrossSolver.stateToIndices(state.multiply(moves[k]));
                    RubiksCubeXCrossSolver.edgesOrientationMove[i * RubiksCubeXCrossSolver.N_EDGES_ORIENTATIONS + j2][k] = indices[3] * N_EDGES_ORIENTATIONS + indices[5];
                    ++k;
                }
                ++j2;
            }
            ++i;
        }
        edgesPermutationDistance = new byte[N_EDGES_COMBINATIONS * N_EDGES_PERMUTATIONS];
        i = 0;
        while (i < edgesPermutationDistance.length) {
            RubiksCubeXCrossSolver.edgesPermutationDistance[i] = -1;
            ++i;
        }
        RubiksCubeXCrossSolver.edgesPermutationDistance[RubiksCubeXCrossSolver.goalEdgesPermutation] = 0;
        int distance = 0;
        int nVisited = 1;
        while (nVisited < N_EDGES_COMBINATIONS * N_EDGES_PERMUTATIONS) {
            int i2 = 0;
            while (i2 < edgesPermutationDistance.length) {
                if (edgesPermutationDistance[i2] == distance) {
                    j = 0;
                    while (j < edgesPermutationMove[i2].length) {
                        int next = edgesPermutationMove[i2][j];
                        if (edgesPermutationDistance[next] < 0) {
                            RubiksCubeXCrossSolver.edgesPermutationDistance[next] = (byte)(distance + 1);
                            ++nVisited;
                        }
                        ++j;
                    }
                }
                ++i2;
            }
            ++distance;
        }
        edgesOrientationDistance = new byte[N_EDGES_COMBINATIONS * N_EDGES_ORIENTATIONS];
        int i3 = 0;
        while (i3 < edgesOrientationDistance.length) {
            RubiksCubeXCrossSolver.edgesOrientationDistance[i3] = -1;
            ++i3;
        }
        RubiksCubeXCrossSolver.edgesOrientationDistance[RubiksCubeXCrossSolver.goalEdgesOrientation] = 0;
        distance = 0;
        nVisited = 1;
        while (nVisited < N_EDGES_COMBINATIONS * N_EDGES_ORIENTATIONS) {
            i3 = 0;
            while (i3 < edgesOrientationDistance.length) {
                if (edgesOrientationDistance[i3] == distance) {
                    j = 0;
                    while (j < edgesOrientationMove[i3].length) {
                        int next = edgesOrientationMove[i3][j];
                        if (edgesOrientationDistance[next] < 0) {
                            RubiksCubeXCrossSolver.edgesOrientationDistance[next] = (byte)(distance + 1);
                            ++nVisited;
                        }
                        ++j;
                    }
                }
                ++i3;
            }
            ++distance;
        }
    }

    private static int[] stateToIndices(RubiksCubeSolver.State state) {
        boolean[] blArray = new boolean[8];
        blArray[4] = true;
        boolean[] selectedCorners = blArray;
        byte[] byArray = new byte[8];
        byArray[0] = -1;
        byArray[1] = -1;
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[5] = -1;
        byArray[6] = -1;
        byArray[7] = -1;
        byte[] cornersMapping = byArray;
        boolean[] cornersCombination = new boolean[state.cornersPermutation.length];
        int i = 0;
        while (i < cornersCombination.length) {
            cornersCombination[i] = selectedCorners[state.cornersPermutation[i]];
            ++i;
        }
        int cornersCombinationIndex = IndexMapping.combinationToIndex(cornersCombination, 1);
        byte[] cornersPermutation = new byte[1];
        byte[] cornersOrientation = new byte[1];
        int next = 0;
        int i2 = 0;
        while (i2 < state.cornersPermutation.length) {
            if (cornersCombination[i2]) {
                cornersPermutation[next] = cornersMapping[state.cornersPermutation[i2]];
                cornersOrientation[next] = state.cornersOrientation[i2];
                ++next;
            }
            ++i2;
        }
        int cornersPermutationIndex = IndexMapping.permutationToIndex(cornersPermutation);
        int cornersOrientationIndex = IndexMapping.orientationToIndex(cornersOrientation, 3);
        boolean[] blArray2 = new boolean[12];
        blArray2[0] = true;
        blArray2[8] = true;
        blArray2[9] = true;
        blArray2[10] = true;
        blArray2[11] = true;
        boolean[] selectedEdges = blArray2;
        byte[] byArray2 = new byte[12];
        byArray2[1] = -1;
        byArray2[2] = -1;
        byArray2[3] = -1;
        byArray2[4] = -1;
        byArray2[5] = -1;
        byArray2[6] = -1;
        byArray2[7] = -1;
        byArray2[8] = 1;
        byArray2[9] = 2;
        byArray2[10] = 3;
        byArray2[11] = 4;
        byte[] edgesMapping = byArray2;
        boolean[] edgesCombination = new boolean[state.edgesPermutation.length];
        int i3 = 0;
        while (i3 < edgesCombination.length) {
            edgesCombination[i3] = selectedEdges[state.edgesPermutation[i3]];
            ++i3;
        }
        int edgesCombinationIndex = IndexMapping.combinationToIndex(edgesCombination, 5);
        byte[] edgesPermutation = new byte[5];
        byte[] edgesOrientation = new byte[5];
        next = 0;
        int i4 = 0;
        while (i4 < state.edgesPermutation.length) {
            if (edgesCombination[i4]) {
                edgesPermutation[next] = edgesMapping[state.edgesPermutation[i4]];
                edgesOrientation[next] = state.edgesOrientation[i4];
                ++next;
            }
            ++i4;
        }
        int edgesPermutationIndex = IndexMapping.permutationToIndex(edgesPermutation);
        int edgesOrientationIndex = IndexMapping.orientationToIndex(edgesOrientation, 2);
        return new int[]{cornersCombinationIndex, cornersPermutationIndex, cornersOrientationIndex, edgesCombinationIndex, edgesPermutationIndex, edgesOrientationIndex};
    }

    private static RubiksCubeSolver.State indicesToState(int[] indices) {
        boolean[] combination = IndexMapping.indexToCombination(indices[0], 1, 8);
        byte[] permutation = IndexMapping.indexToPermutation(indices[1], 1);
        byte[] orientation = IndexMapping.indexToOrientation(indices[2], 3, 1);
        byte[] selectedCorners = new byte[]{4};
        int nextSelectedCornerIndex = 0;
        byte[] byArray = new byte[7];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 5;
        byArray[5] = 6;
        byArray[6] = 7;
        byte[] otherCorners = byArray;
        int nextOtherCornerIndex = 0;
        byte[] cornersPermutation = new byte[8];
        byte[] cornersOrientation = new byte[8];
        int i = 0;
        while (i < cornersPermutation.length) {
            if (combination[i]) {
                cornersPermutation[i] = selectedCorners[permutation[nextSelectedCornerIndex]];
                cornersOrientation[i] = orientation[nextSelectedCornerIndex];
                ++nextSelectedCornerIndex;
            } else {
                cornersPermutation[i] = otherCorners[nextOtherCornerIndex];
                cornersOrientation[i] = 0;
                ++nextOtherCornerIndex;
            }
            ++i;
        }
        combination = IndexMapping.indexToCombination(indices[3], 5, 12);
        permutation = IndexMapping.indexToPermutation(indices[4], 5);
        orientation = IndexMapping.indexToOrientation(indices[5], 2, 5);
        byte[] byArray2 = new byte[5];
        byArray2[1] = 8;
        byArray2[2] = 9;
        byArray2[3] = 10;
        byArray2[4] = 11;
        byte[] selectedEdges = byArray2;
        int nextSelectedEdgeIndex = 0;
        byte[] otherEdges = new byte[]{1, 2, 3, 4, 5, 6, 7};
        int nextOtherEdgeIndex = 0;
        byte[] edgesPermutation = new byte[12];
        byte[] edgesOrientation = new byte[12];
        int i2 = 0;
        while (i2 < edgesPermutation.length) {
            if (combination[i2]) {
                edgesPermutation[i2] = selectedEdges[permutation[nextSelectedEdgeIndex]];
                edgesOrientation[i2] = orientation[nextSelectedEdgeIndex];
                ++nextSelectedEdgeIndex;
            } else {
                edgesPermutation[i2] = otherEdges[nextOtherEdgeIndex];
                edgesOrientation[i2] = 0;
                ++nextOtherEdgeIndex;
            }
            ++i2;
        }
        return new RubiksCubeSolver.State(cornersPermutation, cornersOrientation, edgesPermutation, edgesOrientation);
    }

    public static ArrayList<String[]> solve(RubiksCubeSolver.State state) {
        int[] indices = RubiksCubeXCrossSolver.stateToIndices(state);
        int cornersPermutationIndex = indices[0] * N_CORNERS_PERMUTATIONS + indices[1];
        int cornersOrientationIndex = indices[0] * N_CORNERS_ORIENTATIONS + indices[2];
        int edgesPermutationIndex = indices[3] * N_EDGES_PERMUTATIONS + indices[4];
        int edgesOrientationIndex = indices[3] * N_EDGES_ORIENTATIONS + indices[5];
        ArrayList<String[]> solutions = new ArrayList<String[]>();
        int depth = 0;
        while (true) {
            int[] path = new int[depth];
            RubiksCubeXCrossSolver.search(cornersPermutationIndex, cornersOrientationIndex, edgesPermutationIndex, edgesOrientationIndex, depth, path, solutions);
            if (solutions.size() > 0) {
                return solutions;
            }
            ++depth;
        }
    }

    private static void search(int cornersPermutation, int cornersOrientation, int edgesPermutation, int edgesOrientation, int depth, int[] path, ArrayList<String[]> solutions) {
        if (depth == 0) {
            if (cornersPermutation == goalCornersPermutation && cornersOrientation == goalCornersOrientation && edgesPermutation == goalEdgesPermutation && edgesOrientation == goalEdgesOrientation) {
                String[] sequence = new String[path.length];
                int i = 0;
                while (i < sequence.length) {
                    sequence[i] = moveNames[path[i]];
                    ++i;
                }
                solutions.add(sequence);
            }
            return;
        }
        if (edgesPermutationDistance[edgesPermutation] > depth || edgesOrientationDistance[edgesOrientation] > depth) {
            return;
        }
        int i = 0;
        while (i < moves.length) {
            path[path.length - depth] = i;
            RubiksCubeXCrossSolver.search(cornersPermutationMove[cornersPermutation][i], cornersOrientationMove[cornersOrientation][i], edgesPermutationMove[edgesPermutation][i], edgesOrientationMove[edgesOrientation][i], depth - 1, path, solutions);
            ++i;
        }
    }
}

