/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.solvers;

import com.puzzletimer.solvers.IndexMapping;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

public class RubiksDominoSolver {
    public static final int N_CORNERS_PERMUTATIONS = 40320;
    public static final int N_EDGES_PERMUTATIONS = 40320;
    public static final int N_MOVES = 10;
    private static State[] moves;
    private static int[] faces;
    private static int[][] cornersPermutationMove;
    private static int[][] edgesPermutationMove;
    private static byte[] cornersPermutationDistance;
    private static byte[] edgesPermutationDistance;

    static {
        int next;
        int k;
        int i;
        int j;
        State state;
        byte[] byArray = new byte[8];
        byArray[0] = 3;
        byArray[2] = 1;
        byArray[3] = 2;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        byte[] byArray2 = new byte[8];
        byArray2[0] = 3;
        byArray2[2] = 1;
        byArray2[3] = 2;
        byArray2[4] = 4;
        byArray2[5] = 5;
        byArray2[6] = 6;
        byArray2[7] = 7;
        State moveU = new State(byArray, byArray2);
        byte[] byArray3 = new byte[8];
        byArray3[1] = 1;
        byArray3[2] = 2;
        byArray3[3] = 3;
        byArray3[4] = 5;
        byArray3[5] = 6;
        byArray3[6] = 7;
        byArray3[7] = 4;
        byte[] byArray4 = new byte[8];
        byArray4[1] = 1;
        byArray4[2] = 2;
        byArray4[3] = 3;
        byArray4[4] = 5;
        byArray4[5] = 6;
        byArray4[6] = 7;
        byArray4[7] = 4;
        State moveD = new State(byArray3, byArray4);
        byte[] byArray5 = new byte[8];
        byArray5[0] = 7;
        byArray5[1] = 1;
        byArray5[2] = 2;
        byArray5[3] = 4;
        byArray5[4] = 3;
        byArray5[5] = 5;
        byArray5[6] = 6;
        byte[] byArray6 = new byte[8];
        byArray6[1] = 1;
        byArray6[2] = 2;
        byArray6[3] = 7;
        byArray6[4] = 4;
        byArray6[5] = 5;
        byArray6[6] = 6;
        byArray6[7] = 3;
        State moveL = new State(byArray5, byArray6);
        byte[] byArray7 = new byte[8];
        byArray7[1] = 6;
        byArray7[2] = 5;
        byArray7[3] = 3;
        byArray7[4] = 4;
        byArray7[5] = 2;
        byArray7[6] = 1;
        byArray7[7] = 7;
        byte[] byArray8 = new byte[8];
        byArray8[1] = 5;
        byArray8[2] = 2;
        byArray8[3] = 3;
        byArray8[4] = 4;
        byArray8[5] = 1;
        byArray8[6] = 6;
        byArray8[7] = 7;
        State moveR = new State(byArray7, byArray8);
        byte[] byArray9 = new byte[8];
        byArray9[1] = 1;
        byArray9[2] = 7;
        byArray9[3] = 6;
        byArray9[4] = 4;
        byArray9[5] = 5;
        byArray9[6] = 3;
        byArray9[7] = 2;
        byte[] byArray10 = new byte[8];
        byArray10[1] = 1;
        byArray10[2] = 6;
        byArray10[3] = 3;
        byArray10[4] = 4;
        byArray10[5] = 5;
        byArray10[6] = 2;
        byArray10[7] = 7;
        State moveF = new State(byArray9, byArray10);
        byte[] byArray11 = new byte[8];
        byArray11[0] = 5;
        byArray11[1] = 4;
        byArray11[2] = 2;
        byArray11[3] = 3;
        byArray11[4] = 1;
        byArray11[6] = 6;
        byArray11[7] = 7;
        byte[] byArray12 = new byte[8];
        byArray12[0] = 4;
        byArray12[1] = 1;
        byArray12[2] = 2;
        byArray12[3] = 3;
        byArray12[5] = 5;
        byArray12[6] = 6;
        byArray12[7] = 7;
        State moveB = new State(byArray11, byArray12);
        moves = new State[]{moveU, moveU.multiply(moveU), moveU.multiply(moveU).multiply(moveU), moveD, moveD.multiply(moveD), moveD.multiply(moveD).multiply(moveD), moveL, moveR, moveF, moveB};
        int[] nArray = new int[10];
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 2;
        nArray[7] = 3;
        nArray[8] = 4;
        nArray[9] = 5;
        faces = nArray;
        cornersPermutationMove = new int[40320][10];
        int i2 = 0;
        while (i2 < 40320) {
            state = new State(IndexMapping.indexToPermutation(i2, 8), new byte[8]);
            j = 0;
            while (j < 10) {
                RubiksDominoSolver.cornersPermutationMove[i2][j] = IndexMapping.permutationToIndex(state.multiply((State)RubiksDominoSolver.moves[j]).cornersPermutation);
                ++j;
            }
            ++i2;
        }
        edgesPermutationMove = new int[40320][10];
        i2 = 0;
        while (i2 < 40320) {
            state = new State(new byte[8], IndexMapping.indexToPermutation(i2, 8));
            j = 0;
            while (j < 10) {
                RubiksDominoSolver.edgesPermutationMove[i2][j] = IndexMapping.permutationToIndex(state.multiply((State)RubiksDominoSolver.moves[j]).edgesPermutation);
                ++j;
            }
            ++i2;
        }
        cornersPermutationDistance = new byte[40320];
        i2 = 0;
        while (i2 < cornersPermutationDistance.length) {
            RubiksDominoSolver.cornersPermutationDistance[i2] = -1;
            ++i2;
        }
        RubiksDominoSolver.cornersPermutationDistance[0] = 0;
        int distance = 0;
        int nVisited = 1;
        while (nVisited < 40320) {
            i = 0;
            while (i < 40320) {
                if (cornersPermutationDistance[i] == distance) {
                    k = 0;
                    while (k < 10) {
                        next = cornersPermutationMove[i][k];
                        if (cornersPermutationDistance[next] < 0) {
                            RubiksDominoSolver.cornersPermutationDistance[next] = (byte)(distance + 1);
                            ++nVisited;
                        }
                        ++k;
                    }
                }
                ++i;
            }
            ++distance;
        }
        edgesPermutationDistance = new byte[40320];
        i = 0;
        while (i < edgesPermutationDistance.length) {
            RubiksDominoSolver.edgesPermutationDistance[i] = -1;
            ++i;
        }
        RubiksDominoSolver.edgesPermutationDistance[0] = 0;
        distance = 0;
        nVisited = 1;
        while (nVisited < 40320) {
            i = 0;
            while (i < 40320) {
                if (edgesPermutationDistance[i] == distance) {
                    k = 0;
                    while (k < 10) {
                        next = edgesPermutationMove[i][k];
                        if (edgesPermutationDistance[next] < 0) {
                            RubiksDominoSolver.edgesPermutationDistance[next] = (byte)(distance + 1);
                            ++nVisited;
                        }
                        ++k;
                    }
                }
                ++i;
            }
            ++distance;
        }
    }

    public static String[] solve(State state) {
        int cornersPermutation = IndexMapping.permutationToIndex(state.cornersPermutation);
        int edgesPermutation = IndexMapping.permutationToIndex(state.edgesPermutation);
        int depth = 0;
        while (true) {
            ArrayList<Integer> solution;
            if (RubiksDominoSolver.search(cornersPermutation, edgesPermutation, depth, solution = new ArrayList<Integer>(), -1)) {
                String[] moveNames = new String[]{"U", "U2", "U'", "D", "D2", "D'", "L", "R", "F", "B"};
                String[] sequence = new String[solution.size()];
                int i = 0;
                while (i < sequence.length) {
                    sequence[i] = moveNames[solution.get(i)];
                    ++i;
                }
                return sequence;
            }
            ++depth;
        }
    }

    private static boolean search(int cornersPermutation, int edgesPermutation, int depth, ArrayList<Integer> solution, int lastFace) {
        if (depth == 0) {
            return cornersPermutation == 0 && edgesPermutation == 0;
        }
        if (cornersPermutationDistance[cornersPermutation] <= depth && edgesPermutationDistance[edgesPermutation] <= depth) {
            int i = 0;
            while (i < 10) {
                if (faces[i] != lastFace) {
                    solution.add(i);
                    if (RubiksDominoSolver.search(cornersPermutationMove[cornersPermutation][i], edgesPermutationMove[edgesPermutation][i], depth - 1, solution, faces[i])) {
                        return true;
                    }
                    solution.remove(solution.size() - 1);
                }
                ++i;
            }
        }
        return false;
    }

    public static String[] generate(State state) {
        String[] solution = RubiksDominoSolver.solve(state);
        HashMap<String, String> inverseMoves = new HashMap<String, String>();
        inverseMoves.put("U", "U'");
        inverseMoves.put("U2", "U2");
        inverseMoves.put("U'", "U");
        inverseMoves.put("D", "D'");
        inverseMoves.put("D2", "D2");
        inverseMoves.put("D'", "D");
        inverseMoves.put("L", "L");
        inverseMoves.put("R", "R");
        inverseMoves.put("F", "F");
        inverseMoves.put("B", "B");
        String[] sequence = new String[solution.length];
        int i = 0;
        while (i < sequence.length) {
            sequence[i] = (String)inverseMoves.get(solution[solution.length - 1 - i]);
            ++i;
        }
        return sequence;
    }

    public static State getRandomState(Random random) {
        return new State(IndexMapping.indexToPermutation(random.nextInt(40320), 8), IndexMapping.indexToPermutation(random.nextInt(40320), 8));
    }

    public static class State {
        public byte[] cornersPermutation;
        public byte[] edgesPermutation;

        public State(byte[] cornersPermutation, byte[] edgesPermutation) {
            this.cornersPermutation = cornersPermutation;
            this.edgesPermutation = edgesPermutation;
        }

        public State multiply(State move) {
            byte[] cornersPermutation = new byte[8];
            byte[] edgesPermutation = new byte[8];
            int i = 0;
            while (i < 8) {
                cornersPermutation[i] = this.cornersPermutation[move.cornersPermutation[i]];
                edgesPermutation[i] = this.edgesPermutation[move.edgesPermutation[i]];
                ++i;
            }
            return new State(cornersPermutation, edgesPermutation);
        }
    }
}

