/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.solvers;

import com.puzzletimer.solvers.IndexMapping;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

public class SkewbSolver {
    private final int N_FACES_PERMUTATIONS = 360;
    private final int N_FREE_CORNERS_PERMUTATION = 12;
    private final int N_FREE_CORNERS_ORIENTATION = 27;
    private final int N_FIXED_CORNERS_ORIENTATION = 81;
    private boolean initialized = false;
    private State[] moves;
    private int[][] facesPermutationMove;
    private int[][] freeCornersPermutationMove;
    private int[][] freeCornersOrientationMove;
    private int[][] fixedCornersOrientationMove;
    private int[][][][] distance;

    private void initialize() {
        int nVisited;
        int j;
        State state;
        byte[] byArray = new byte[6];
        byArray[0] = 1;
        byArray[1] = 4;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[5] = 5;
        byte[] byArray2 = new byte[4];
        byArray2[0] = 2;
        byArray2[2] = 1;
        byArray2[3] = 3;
        byte[] byArray3 = new byte[4];
        byArray3[0] = 2;
        byArray3[1] = 2;
        byArray3[2] = 2;
        byte[] byArray4 = new byte[4];
        byArray4[0] = 1;
        State moveL = new State(byArray, byArray2, byArray3, byArray4);
        byte[] byArray5 = new byte[6];
        byArray5[0] = 3;
        byArray5[1] = 1;
        byArray5[3] = 2;
        byArray5[4] = 4;
        byArray5[5] = 5;
        byte[] byArray6 = new byte[4];
        byArray6[0] = 1;
        byArray6[1] = 3;
        byArray6[2] = 2;
        byte[] byArray7 = new byte[4];
        byArray7[0] = 2;
        byArray7[1] = 2;
        byArray7[3] = 2;
        byte[] byArray8 = new byte[4];
        byArray8[1] = 1;
        State moveR = new State(byArray5, byArray6, byArray7, byArray8);
        byte[] byArray9 = new byte[6];
        byArray9[1] = 1;
        byArray9[2] = 2;
        byArray9[3] = 4;
        byArray9[4] = 5;
        byArray9[5] = 3;
        byte[] byArray10 = new byte[4];
        byArray10[1] = 2;
        byArray10[2] = 3;
        byArray10[3] = 1;
        byte[] byArray11 = new byte[4];
        byArray11[1] = 2;
        byArray11[2] = 2;
        byArray11[3] = 2;
        byte[] byArray12 = new byte[4];
        byArray12[3] = 1;
        State moveD = new State(byArray9, byArray10, byArray11, byArray12);
        byte[] byArray13 = new byte[6];
        byArray13[1] = 2;
        byArray13[2] = 5;
        byArray13[3] = 3;
        byArray13[4] = 4;
        byArray13[5] = 1;
        byte[] byArray14 = new byte[4];
        byArray14[0] = 3;
        byArray14[1] = 1;
        byArray14[3] = 2;
        byte[] byArray15 = new byte[4];
        byArray15[0] = 2;
        byArray15[2] = 2;
        byArray15[3] = 2;
        byte[] byArray16 = new byte[4];
        byArray16[2] = 1;
        State moveB = new State(byArray13, byArray14, byArray15, byArray16);
        this.moves = new State[]{moveL, moveL.multiply(moveL), moveR, moveR.multiply(moveR), moveD, moveD.multiply(moveD), moveB, moveB.multiply(moveB)};
        this.facesPermutationMove = new int[360][this.moves.length];
        int i = 0;
        while (i < this.facesPermutationMove.length) {
            state = new State(IndexMapping.indexToEvenPermutation(i, 6), new byte[4], new byte[4], new byte[4]);
            j = 0;
            while (j < this.moves.length) {
                this.facesPermutationMove[i][j] = IndexMapping.evenPermutationToIndex(state.multiply((State)this.moves[j]).facesPermutation);
                ++j;
            }
            ++i;
        }
        this.freeCornersPermutationMove = new int[12][this.moves.length];
        i = 0;
        while (i < this.freeCornersPermutationMove.length) {
            state = new State(new byte[6], IndexMapping.indexToEvenPermutation(i, 4), new byte[4], new byte[4]);
            j = 0;
            while (j < this.moves.length) {
                this.freeCornersPermutationMove[i][j] = IndexMapping.evenPermutationToIndex(state.multiply((State)this.moves[j]).freeCornersPermutation);
                ++j;
            }
            ++i;
        }
        this.freeCornersOrientationMove = new int[27][this.moves.length];
        i = 0;
        while (i < this.freeCornersOrientationMove.length) {
            state = new State(new byte[6], new byte[4], IndexMapping.indexToZeroSumOrientation(i, 3, 4), new byte[4]);
            j = 0;
            while (j < this.moves.length) {
                this.freeCornersOrientationMove[i][j] = IndexMapping.zeroSumOrientationToIndex(state.multiply((State)this.moves[j]).freeCornersOrientation, 3);
                ++j;
            }
            ++i;
        }
        this.fixedCornersOrientationMove = new int[81][this.moves.length];
        i = 0;
        while (i < this.fixedCornersOrientationMove.length) {
            state = new State(new byte[6], new byte[4], new byte[4], IndexMapping.indexToOrientation(i, 3, 4));
            j = 0;
            while (j < this.moves.length) {
                this.fixedCornersOrientationMove[i][j] = IndexMapping.orientationToIndex(state.multiply((State)this.moves[j]).fixedCornersOrientation, 3);
                ++j;
            }
            ++i;
        }
        this.distance = new int[360][12][27][81];
        i = 0;
        while (i < this.distance.length) {
            int j2 = 0;
            while (j2 < this.distance[i].length) {
                int k = 0;
                while (k < this.distance[i][j2].length) {
                    int m = 0;
                    while (m < this.distance[i][j2][k].length) {
                        this.distance[i][j2][k][m] = -1;
                        ++m;
                    }
                    ++k;
                }
                ++j2;
            }
            ++i;
        }
        this.distance[0][0][0][0] = 0;
        int depth = 0;
        do {
            nVisited = 0;
            int i2 = 0;
            while (i2 < this.distance.length) {
                int j3 = 0;
                while (j3 < this.distance[i2].length) {
                    int k = 0;
                    while (k < this.distance[i2][j3].length) {
                        int m = 0;
                        while (m < this.distance[i2][j3][k].length) {
                            if (this.distance[i2][j3][k][m] == depth) {
                                int moveIndex = 0;
                                while (moveIndex < this.moves.length) {
                                    int nextFacesPermutation = this.facesPermutationMove[i2][moveIndex];
                                    int nextFreeCornersPemutation = this.freeCornersPermutationMove[j3][moveIndex];
                                    int nextFreeCornersOrientation = this.freeCornersOrientationMove[k][moveIndex];
                                    int nextFixedCornersOrientation = this.fixedCornersOrientationMove[m][moveIndex];
                                    if (this.distance[nextFacesPermutation][nextFreeCornersPemutation][nextFreeCornersOrientation][nextFixedCornersOrientation] == -1) {
                                        this.distance[nextFacesPermutation][nextFreeCornersPemutation][nextFreeCornersOrientation][nextFixedCornersOrientation] = depth + 1;
                                        ++nVisited;
                                    }
                                    ++moveIndex;
                                }
                            }
                            ++m;
                        }
                        ++k;
                    }
                    ++j3;
                }
                ++i2;
            }
            ++depth;
        } while (nVisited > 0);
        this.initialized = true;
    }

    public String[] solve(State state) {
        if (!this.initialized) {
            this.initialize();
        }
        String[] moveNames = new String[]{"L", "L'", "R", "R'", "D", "D'", "B", "B'"};
        ArrayList<String> sequence = new ArrayList<String>();
        int facesPermutation = IndexMapping.evenPermutationToIndex(state.facesPermutation);
        int freeCornersPermutation = IndexMapping.evenPermutationToIndex(state.freeCornersPermutation);
        int freeCornersOrientation = IndexMapping.zeroSumOrientationToIndex(state.freeCornersOrientation, 3);
        int fixedCornersOrientation = IndexMapping.orientationToIndex(state.fixedCornersOrientation, 3);
        block0: while (this.distance[facesPermutation][freeCornersPermutation][freeCornersOrientation][fixedCornersOrientation] != 0) {
            int k = 0;
            while (k < this.moves.length) {
                int nextFacesPermutation = this.facesPermutationMove[facesPermutation][k];
                int nextFreeCornersPemutation = this.freeCornersPermutationMove[freeCornersPermutation][k];
                int nextFreeCornersOrientation = this.freeCornersOrientationMove[freeCornersOrientation][k];
                int nextFixedCornersOrientation = this.fixedCornersOrientationMove[fixedCornersOrientation][k];
                if (this.distance[nextFacesPermutation][nextFreeCornersPemutation][nextFreeCornersOrientation][nextFixedCornersOrientation] == this.distance[facesPermutation][freeCornersPermutation][freeCornersOrientation][fixedCornersOrientation] - 1) {
                    sequence.add(moveNames[k]);
                    facesPermutation = nextFacesPermutation;
                    freeCornersPermutation = nextFreeCornersPemutation;
                    freeCornersOrientation = nextFreeCornersOrientation;
                    fixedCornersOrientation = nextFixedCornersOrientation;
                    continue block0;
                }
                ++k;
            }
        }
        String[] sequenceArray = new String[sequence.size()];
        sequence.toArray(sequenceArray);
        return sequenceArray;
    }

    public String[] generate(State state) {
        String[] solution = this.solve(state);
        HashMap<String, String> inverseMoves = new HashMap<String, String>();
        inverseMoves.put("L", "L'");
        inverseMoves.put("L'", "L");
        inverseMoves.put("R", "R'");
        inverseMoves.put("R'", "R");
        inverseMoves.put("D", "D'");
        inverseMoves.put("D'", "D");
        inverseMoves.put("B", "B'");
        inverseMoves.put("B'", "B");
        String[] sequence = new String[solution.length];
        int i = 0;
        while (i < sequence.length) {
            sequence[i] = (String)inverseMoves.get(solution[solution.length - 1 - i]);
            ++i;
        }
        return sequence;
    }

    public State getRandomState(Random random) {
        int indexFixedCornersOrientation;
        int indexFreeCornersOrientation;
        int indexFreeCornersPermutation;
        int indexFacesPermutation;
        if (!this.initialized) {
            this.initialize();
        }
        while (this.distance[indexFacesPermutation = random.nextInt(360)][indexFreeCornersPermutation = random.nextInt(12)][indexFreeCornersOrientation = random.nextInt(27)][indexFixedCornersOrientation = random.nextInt(81)] == -1) {
        }
        return new State(IndexMapping.indexToEvenPermutation(indexFacesPermutation, 6), IndexMapping.indexToEvenPermutation(indexFreeCornersPermutation, 4), IndexMapping.indexToZeroSumOrientation(indexFreeCornersOrientation, 3, 4), IndexMapping.indexToOrientation(indexFixedCornersOrientation, 3, 4));
    }

    public static class State {
        public byte[] facesPermutation;
        public byte[] freeCornersPermutation;
        public byte[] freeCornersOrientation;
        public byte[] fixedCornersOrientation;

        public State(byte[] facesPermutation, byte[] freeCornersPermutation, byte[] freeCornersOrientation, byte[] fixedCornersOrientation) {
            this.facesPermutation = facesPermutation;
            this.freeCornersPermutation = freeCornersPermutation;
            this.freeCornersOrientation = freeCornersOrientation;
            this.fixedCornersOrientation = fixedCornersOrientation;
        }

        public State multiply(State move) {
            byte[] facesPermutation = new byte[6];
            int i = 0;
            while (i < facesPermutation.length) {
                facesPermutation[i] = this.facesPermutation[move.facesPermutation[i]];
                ++i;
            }
            byte[] freeCornersPermutation = new byte[4];
            int i2 = 0;
            while (i2 < freeCornersPermutation.length) {
                freeCornersPermutation[i2] = this.freeCornersPermutation[move.freeCornersPermutation[i2]];
                ++i2;
            }
            byte[] freeCornersOrientation = new byte[4];
            int i3 = 0;
            while (i3 < freeCornersOrientation.length) {
                freeCornersOrientation[i3] = (byte)((this.freeCornersOrientation[move.freeCornersPermutation[i3]] + move.freeCornersOrientation[i3]) % 3);
                ++i3;
            }
            byte[] fixedCornersOrientation = new byte[4];
            int i4 = 0;
            while (i4 < freeCornersOrientation.length) {
                fixedCornersOrientation[i4] = (byte)((this.fixedCornersOrientation[i4] + move.fixedCornersOrientation[i4]) % 3);
                ++i4;
            }
            return new State(facesPermutation, freeCornersPermutation, freeCornersOrientation, fixedCornersOrientation);
        }
    }
}

