/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.solvers;

import com.puzzletimer.solvers.IndexMapping;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

public class TowerCubeSolver {
    private static int N_CORNERS_PERMUTATIONS;
    private static int N_EDGES_PERMUTATIONS;
    private static int N_MOVES;
    private static State[] moves;
    private static int[][] cornersPermutationMove;
    private static int[][] edgesPermutationMove;
    private static int[][] distance;

    static {
        int nVisited;
        int j;
        State state;
        N_CORNERS_PERMUTATIONS = 40320;
        N_EDGES_PERMUTATIONS = 24;
        N_MOVES = 10;
        byte[] byArray = new byte[8];
        byArray[0] = 3;
        byArray[2] = 1;
        byArray[3] = 2;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        byte[] byArray2 = new byte[4];
        byArray2[1] = 1;
        byArray2[2] = 2;
        byArray2[3] = 3;
        State moveU = new State(byArray, byArray2);
        byte[] byArray3 = new byte[8];
        byArray3[1] = 1;
        byArray3[2] = 2;
        byArray3[3] = 3;
        byArray3[4] = 5;
        byArray3[5] = 6;
        byArray3[6] = 7;
        byArray3[7] = 4;
        byte[] byArray4 = new byte[4];
        byArray4[1] = 1;
        byArray4[2] = 2;
        byArray4[3] = 3;
        State moveD = new State(byArray3, byArray4);
        byte[] byArray5 = new byte[8];
        byArray5[0] = 7;
        byArray5[1] = 1;
        byArray5[2] = 2;
        byArray5[3] = 4;
        byArray5[4] = 3;
        byArray5[5] = 5;
        byArray5[6] = 6;
        byte[] byArray6 = new byte[4];
        byArray6[0] = 3;
        byArray6[1] = 1;
        byArray6[2] = 2;
        State moveL = new State(byArray5, byArray6);
        byte[] byArray7 = new byte[8];
        byArray7[1] = 6;
        byArray7[2] = 5;
        byArray7[3] = 3;
        byArray7[4] = 4;
        byArray7[5] = 2;
        byArray7[6] = 1;
        byArray7[7] = 7;
        byte[] byArray8 = new byte[4];
        byArray8[1] = 2;
        byArray8[2] = 1;
        byArray8[3] = 3;
        State moveR = new State(byArray7, byArray8);
        byte[] byArray9 = new byte[8];
        byArray9[1] = 1;
        byArray9[2] = 7;
        byArray9[3] = 6;
        byArray9[4] = 4;
        byArray9[5] = 5;
        byArray9[6] = 3;
        byArray9[7] = 2;
        byte[] byArray10 = new byte[4];
        byArray10[1] = 1;
        byArray10[2] = 3;
        byArray10[3] = 2;
        State moveF = new State(byArray9, byArray10);
        byte[] byArray11 = new byte[8];
        byArray11[0] = 5;
        byArray11[1] = 4;
        byArray11[2] = 2;
        byArray11[3] = 3;
        byArray11[4] = 1;
        byArray11[6] = 6;
        byArray11[7] = 7;
        byte[] byArray12 = new byte[4];
        byArray12[0] = 1;
        byArray12[2] = 2;
        byArray12[3] = 3;
        State moveB = new State(byArray11, byArray12);
        moves = new State[]{moveU, moveU.multiply(moveU), moveU.multiply(moveU).multiply(moveU), moveD, moveD.multiply(moveD), moveD.multiply(moveD).multiply(moveD), moveL, moveR, moveF, moveB};
        cornersPermutationMove = new int[N_CORNERS_PERMUTATIONS][N_MOVES];
        int i = 0;
        while (i < N_CORNERS_PERMUTATIONS) {
            state = new State(IndexMapping.indexToPermutation(i, 8), new byte[4]);
            j = 0;
            while (j < N_MOVES) {
                TowerCubeSolver.cornersPermutationMove[i][j] = IndexMapping.permutationToIndex(state.multiply((State)TowerCubeSolver.moves[j]).cornersPermutation);
                ++j;
            }
            ++i;
        }
        edgesPermutationMove = new int[N_EDGES_PERMUTATIONS][N_MOVES];
        i = 0;
        while (i < N_EDGES_PERMUTATIONS) {
            state = new State(new byte[8], IndexMapping.indexToPermutation(i, 4));
            j = 0;
            while (j < N_MOVES) {
                TowerCubeSolver.edgesPermutationMove[i][j] = IndexMapping.permutationToIndex(state.multiply((State)TowerCubeSolver.moves[j]).edgesPermutation);
                ++j;
            }
            ++i;
        }
        distance = new int[N_CORNERS_PERMUTATIONS][N_EDGES_PERMUTATIONS];
        i = 0;
        while (i < distance.length) {
            int j2 = 0;
            while (j2 < distance[i].length) {
                TowerCubeSolver.distance[i][j2] = -1;
                ++j2;
            }
            ++i;
        }
        TowerCubeSolver.distance[0][0] = 0;
        int depth = 0;
        do {
            nVisited = 0;
            int i2 = 0;
            while (i2 < N_CORNERS_PERMUTATIONS) {
                int j3 = 0;
                while (j3 < N_EDGES_PERMUTATIONS) {
                    if (distance[i2][j3] == depth) {
                        int k = 0;
                        while (k < N_MOVES) {
                            int nextCornersPemutation = cornersPermutationMove[i2][k];
                            int nextEdgesPemutation = edgesPermutationMove[j3][k];
                            if (distance[nextCornersPemutation][nextEdgesPemutation] == -1) {
                                TowerCubeSolver.distance[nextCornersPemutation][nextEdgesPemutation] = depth + 1;
                                ++nVisited;
                            }
                            ++k;
                        }
                    }
                    ++j3;
                }
                ++i2;
            }
            ++depth;
        } while (nVisited > 0);
    }

    public static String[] solve(State state) {
        String[] moveNames = new String[]{"U", "U2", "U'", "D", "D2", "D'", "L", "R", "F", "B"};
        ArrayList<String> sequence = new ArrayList<String>();
        int cornersPermutationIndex = IndexMapping.permutationToIndex(state.cornersPermutation);
        int edgesPermutationIndex = IndexMapping.permutationToIndex(state.edgesPermutation);
        block0: while (distance[cornersPermutationIndex][edgesPermutationIndex] != 0) {
            int k = 0;
            while (k < N_MOVES) {
                int nextCornersPermutationIndex = cornersPermutationMove[cornersPermutationIndex][k];
                int nextEdgesPermutationIndex = edgesPermutationMove[edgesPermutationIndex][k];
                if (distance[nextCornersPermutationIndex][nextEdgesPermutationIndex] == distance[cornersPermutationIndex][edgesPermutationIndex] - 1) {
                    sequence.add(moveNames[k]);
                    cornersPermutationIndex = nextCornersPermutationIndex;
                    edgesPermutationIndex = nextEdgesPermutationIndex;
                    continue block0;
                }
                ++k;
            }
        }
        String[] sequenceArray = new String[sequence.size()];
        sequence.toArray(sequenceArray);
        return sequenceArray;
    }

    public static String[] generate(State state) {
        String[] solution = TowerCubeSolver.solve(state);
        HashMap<String, String> inverseMoves = new HashMap<String, String>();
        inverseMoves.put("U", "U'");
        inverseMoves.put("U2", "U2");
        inverseMoves.put("U'", "U");
        inverseMoves.put("D", "D'");
        inverseMoves.put("D2", "D2");
        inverseMoves.put("D'", "D");
        inverseMoves.put("L", "L");
        inverseMoves.put("R", "R");
        inverseMoves.put("F", "F");
        inverseMoves.put("B", "B");
        String[] sequence = new String[solution.length];
        int i = 0;
        while (i < sequence.length) {
            sequence[i] = (String)inverseMoves.get(solution[solution.length - 1 - i]);
            ++i;
        }
        return sequence;
    }

    public static State getRandomState(Random random) {
        return new State(IndexMapping.indexToPermutation(random.nextInt(N_CORNERS_PERMUTATIONS), 8), IndexMapping.indexToPermutation(random.nextInt(N_EDGES_PERMUTATIONS), 4));
    }

    public static class State {
        public byte[] cornersPermutation;
        public byte[] edgesPermutation;

        public State(byte[] cornersPermutation, byte[] edgesPermutation) {
            this.cornersPermutation = cornersPermutation;
            this.edgesPermutation = edgesPermutation;
        }

        public State multiply(State move) {
            byte[] cornersPermutation = new byte[8];
            int i = 0;
            while (i < 8) {
                cornersPermutation[i] = this.cornersPermutation[move.cornersPermutation[i]];
                ++i;
            }
            byte[] edgesPermutation = new byte[4];
            int i2 = 0;
            while (i2 < 4) {
                edgesPermutation[i2] = this.edgesPermutation[move.edgesPermutation[i2]];
                ++i2;
            }
            return new State(cornersPermutation, edgesPermutation);
        }
    }
}

