/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.state;

import com.puzzletimer.models.ColorScheme;
import java.util.ArrayList;
import java.util.HashMap;

public class ColorManager {
    private ArrayList<Listener> listeners = new ArrayList();
    private HashMap<String, ColorScheme> colorSchemeMap = new HashMap();

    public ColorManager(ColorScheme[] colorSchemes) {
        ColorScheme[] colorSchemeArray = colorSchemes;
        int n = colorSchemes.length;
        int n2 = 0;
        while (n2 < n) {
            ColorScheme colorScheme = colorSchemeArray[n2];
            this.colorSchemeMap.put(colorScheme.getPuzzleId(), colorScheme);
            ++n2;
        }
    }

    public ColorScheme getColorScheme(String puzzleId) {
        if (this.colorSchemeMap.containsKey(puzzleId)) {
            return this.colorSchemeMap.get(puzzleId);
        }
        return new ColorScheme(puzzleId, new ColorScheme.FaceColor[0]);
    }

    public void setColorScheme(ColorScheme colorScheme) {
        this.colorSchemeMap.put(colorScheme.getPuzzleId(), colorScheme);
        for (Listener listener : this.listeners) {
            listener.colorSchemeUpdated(colorScheme);
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public static class Listener {
        public void colorSchemeUpdated(ColorScheme colorScheme) {
        }
    }
}

