/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.state;

import com.puzzletimer.models.ConfigurationEntry;
import java.util.ArrayList;
import java.util.HashMap;

public class ConfigurationManager {
    private ArrayList<Listener> listeners = new ArrayList();
    private HashMap<String, ConfigurationEntry> entryMap = new HashMap();

    public ConfigurationManager(ConfigurationEntry[] entries) {
        ConfigurationEntry[] configurationEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigurationEntry entry = configurationEntryArray[n2];
            this.entryMap.put(entry.getKey(), entry);
            ++n2;
        }
    }

    public String getConfiguration(String key) {
        return this.entryMap.get(key).getValue();
    }

    public void setConfiguration(String key, String value) {
        this.entryMap.put(key, new ConfigurationEntry(key, value));
        for (Listener listener : this.listeners) {
            listener.configurationEntryUpdated(key, value);
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public static class Listener {
        public void configurationEntryUpdated(String key, String value) {
        }
    }
}

