/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.state;

import java.util.ArrayList;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class MessageManager {
    private ArrayList<String> messageQueue = new ArrayList();
    private ArrayList<MessageType> messageTypeQueue = new ArrayList();
    private ArrayList<Listener> listeners = new ArrayList();

    public MessageManager() {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){
            private Date nextUpdate = new Date();
            private boolean clear = true;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Date now = new Date();
                if (now.getTime() > this.nextUpdate.getTime()) {
                    if (!this.clear) {
                        for (Listener listener : MessageManager.this.listeners) {
                            listener.messagesCleared();
                        }
                        this.clear = true;
                    }
                    MessageManager messageManager = MessageManager.this;
                    synchronized (messageManager) {
                        if (MessageManager.this.messageTypeQueue.size() > 0) {
                            MessageType messageType = (MessageType)((Object)MessageManager.this.messageTypeQueue.remove(0));
                            String message = (String)MessageManager.this.messageQueue.remove(0);
                            for (Listener listener : MessageManager.this.listeners) {
                                listener.messageReceived(messageType, message);
                            }
                            this.nextUpdate = new Date(now.getTime() + 8000L);
                            this.clear = false;
                        }
                    }
                }
            }
        }, 0L, 250L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueMessage(MessageType messageType, String message) {
        MessageManager messageManager = this;
        synchronized (messageManager) {
            this.messageTypeQueue.add(messageType);
            this.messageQueue.add(message);
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public static class Listener {
        public void messagesCleared() {
        }

        public void messageReceived(MessageType messageType, String message) {
        }
    }

    public static enum MessageType {
        INFORMATION,
        ERROR;

    }
}

