/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.state;

import com.puzzletimer.models.Timing;
import com.puzzletimer.timer.Timer;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimerTask;

public class TimerManager {
    private ArrayList<Listener> listeners = new ArrayList();
    private Timer currentTimer = null;
    private boolean inspectionEnabled = false;
    private java.util.Timer repeater = null;
    private Date inspectionStart = null;
    private String penalty = "";

    public void setTimer(Timer timer) {
        if (this.inspectionStart != null) {
            this.repeater.cancel();
            this.inspectionStart = null;
            this.penalty = "";
        }
        if (this.currentTimer != null) {
            this.currentTimer.stop();
        }
        this.currentTimer = timer;
        this.currentTimer.setInspectionEnabled(this.inspectionEnabled);
        for (Listener listener : this.listeners) {
            listener.timerChanged(timer);
        }
        this.currentTimer.start();
    }

    public void resetTimer() {
        for (Listener listener : this.listeners) {
            listener.timerReset();
        }
    }

    public void pressLeftHand() {
        for (Listener listener : this.listeners) {
            listener.leftHandPressed();
        }
    }

    public void releaseLeftHand() {
        for (Listener listener : this.listeners) {
            listener.leftHandReleased();
        }
    }

    public void pressRightHand() {
        for (Listener listener : this.listeners) {
            listener.rightHandPressed();
        }
    }

    public void releaseRightHand() {
        for (Listener listener : this.listeners) {
            listener.rightHandReleased();
        }
    }

    public boolean isInspectionEnabled() {
        return this.inspectionEnabled;
    }

    public void setInspectionEnabled(boolean inspectionEnabled) {
        this.inspectionEnabled = inspectionEnabled;
        if (this.currentTimer != null) {
            this.currentTimer.setInspectionEnabled(inspectionEnabled);
        }
        for (Listener listener : this.listeners) {
            listener.inspectionEnabledSet(inspectionEnabled);
        }
    }

    public void startInspection() {
        for (Listener listener : this.listeners) {
            listener.inspectionStarted();
        }
        this.inspectionStart = new Date();
        this.penalty = "";
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                long start = TimerManager.this.inspectionStart.getTime();
                long now = new Date().getTime();
                for (Listener listener : TimerManager.this.listeners) {
                    listener.inspectionRunning(15000L - (now - start));
                }
                if (now - start > 17000L) {
                    TimerManager.this.repeater.cancel();
                    for (Listener listener : TimerManager.this.listeners) {
                        listener.inspectionFinished();
                    }
                    TimerManager.this.inspectionStart = null;
                    TimerManager.this.penalty = "DNF";
                    TimerManager.this.finishSolution(new Timing(new Date(now), new Date(now)));
                } else if (now - start > 15000L) {
                    TimerManager.this.penalty = "+2";
                }
            }
        };
        this.repeater = new java.util.Timer();
        this.repeater.schedule(timerTask, 0L, 10L);
    }

    public void startSolution() {
        if (this.inspectionStart != null) {
            this.repeater.cancel();
            this.inspectionStart = null;
            for (Listener listener : this.listeners) {
                listener.inspectionFinished();
            }
        }
        for (Listener listener : this.listeners) {
            listener.solutionStarted();
        }
    }

    public void updateSolutionTiming(Timing timing) {
        for (Listener listener : this.listeners) {
            listener.solutionRunning(timing);
        }
    }

    public void finishSolution(Timing timing) {
        for (Listener listener : this.listeners) {
            listener.solutionFinished(timing, this.penalty);
        }
        this.penalty = "";
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public static class Listener {
        public void timerChanged(Timer timer) {
        }

        public void timerReset() {
        }

        public void leftHandPressed() {
        }

        public void leftHandReleased() {
        }

        public void rightHandPressed() {
        }

        public void rightHandReleased() {
        }

        public void inspectionEnabledSet(boolean inspectionEnabled) {
        }

        public void inspectionStarted() {
        }

        public void inspectionRunning(long remainingTime) {
        }

        public void inspectionFinished() {
        }

        public void solutionStarted() {
        }

        public void solutionRunning(Timing timing) {
        }

        public void solutionFinished(Timing timing, String penalty) {
        }
    }
}

