/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.statistics;

import com.puzzletimer.models.Solution;
import com.puzzletimer.statistics.StatisticalMeasure;
import com.puzzletimer.util.SolutionUtils;

public class BestAverage
implements StatisticalMeasure {
    private int minimumWindowSize;
    private int maximumWindowSize;
    private int windowPosition;
    private long value;

    public BestAverage(int minimumWindowSize, int maximumWindowSize) {
        this.minimumWindowSize = minimumWindowSize;
        this.maximumWindowSize = maximumWindowSize;
    }

    @Override
    public int getMinimumWindowSize() {
        return this.minimumWindowSize;
    }

    @Override
    public int getMaximumWindowSize() {
        return this.maximumWindowSize;
    }

    @Override
    public int getWindowPosition() {
        return this.windowPosition;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public void setSolutions(Solution[] solutions) {
        long[] times = SolutionUtils.realTimes(solutions, false);
        long bestAverage = Long.MAX_VALUE;
        int i = 0;
        while (i < times.length - this.minimumWindowSize + 1) {
            long average;
            long worst = Long.MIN_VALUE;
            long best = Long.MAX_VALUE;
            long sum = 0L;
            int j = 0;
            while (j < this.minimumWindowSize) {
                if (times[i + j] == Long.MAX_VALUE && worst == Long.MAX_VALUE) {
                    sum = Long.MAX_VALUE;
                    break;
                }
                if (times[i + j] > worst) {
                    worst = times[i + j];
                }
                if (times[i + j] < best) {
                    best = times[i + j];
                }
                sum += times[i + j];
                ++j;
            }
            if (sum != Long.MAX_VALUE && (average = (sum - worst - best) / (long)(this.minimumWindowSize - 2)) < bestAverage) {
                bestAverage = average;
                this.windowPosition = i;
            }
            ++i;
        }
        this.value = bestAverage;
    }
}

