/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.statistics;

import com.puzzletimer.models.Solution;
import com.puzzletimer.statistics.StatisticalMeasure;
import com.puzzletimer.util.SolutionUtils;
import java.util.Arrays;

public class Percentile
implements StatisticalMeasure {
    private int minimumWindowSize;
    private int maximumWindowSize;
    private long value;
    private double p;

    public Percentile(int minimumWindowSize, int maximumWindowSize, double p) {
        this.minimumWindowSize = minimumWindowSize;
        this.maximumWindowSize = maximumWindowSize;
        this.p = p;
    }

    @Override
    public int getMinimumWindowSize() {
        return this.minimumWindowSize;
    }

    @Override
    public int getMaximumWindowSize() {
        return this.maximumWindowSize;
    }

    @Override
    public int getWindowPosition() {
        return 0;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public void setSolutions(Solution[] solutions) {
        long[] times = SolutionUtils.realTimes(solutions, false);
        Arrays.sort(times);
        double position = this.p * (double)(solutions.length + 1);
        if (position < 1.0) {
            this.value = times[0];
            return;
        }
        if (position >= (double)times.length) {
            this.value = times[times.length - 1];
            return;
        }
        int index = (int)Math.floor(position);
        if (times[index - 1] == Long.MAX_VALUE || position - (double)index != 0.0 && times[index] == Long.MAX_VALUE) {
            this.value = Long.MAX_VALUE;
            return;
        }
        this.value = (long)((double)times[index - 1] + (position - (double)index) * (double)(times[index] - times[index - 1]));
    }
}

