/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.timer;

import com.puzzletimer.models.Timing;
import com.puzzletimer.state.TimerManager;
import com.puzzletimer.timer.Timer;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Date;
import java.util.TimerTask;
import javax.swing.JFrame;

public class SpaceKeyTimer
implements Timer {
    private JFrame frame;
    private TimerManager timerManager;
    private boolean inspectionEnabled;
    private KeyListener keyListener;
    private TimerManager.Listener timerListener;
    private java.util.Timer repeater;
    private Date start;
    private Date finish;
    private State state;

    public SpaceKeyTimer(JFrame frame, TimerManager timerManager) {
        this.frame = frame;
        this.timerManager = timerManager;
        this.inspectionEnabled = false;
        this.repeater = null;
        this.start = null;
        this.finish = new Date(0L);
        this.state = this.inspectionEnabled ? State.READY_FOR_INSPECTION : State.READY;
    }

    @Override
    public String getTimerId() {
        return "KEYBOARD-TIMER-SPACE";
    }

    @Override
    public void setInspectionEnabled(boolean inspectionEnabled) {
        this.inspectionEnabled = inspectionEnabled;
        switch (this.state) {
            case READY_FOR_INSPECTION: {
                if (inspectionEnabled) break;
                this.state = State.READY;
                break;
            }
            case READY: {
                if (!inspectionEnabled) break;
                this.state = State.READY_FOR_INSPECTION;
            }
        }
    }

    @Override
    public void start() {
        this.keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() != 32) {
                    return;
                }
                switch (SpaceKeyTimer.this.state) {
                    case RUNNING: {
                        SpaceKeyTimer.this.finish = new Date();
                        if (SpaceKeyTimer.this.finish.getTime() - SpaceKeyTimer.this.start.getTime() < 250L) break;
                        SpaceKeyTimer.this.repeater.cancel();
                        SpaceKeyTimer.this.timerManager.finishSolution(new Timing(SpaceKeyTimer.this.start, SpaceKeyTimer.this.finish));
                        SpaceKeyTimer.this.state = State.FINISHED;
                    }
                }
                SpaceKeyTimer.this.timerManager.pressLeftHand();
                SpaceKeyTimer.this.timerManager.pressRightHand();
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() != 32) {
                    return;
                }
                switch (SpaceKeyTimer.this.state) {
                    case READY_FOR_INSPECTION: {
                        if (new Date().getTime() - SpaceKeyTimer.this.finish.getTime() < 250L) break;
                        SpaceKeyTimer.this.timerManager.startInspection();
                        SpaceKeyTimer.this.state = State.READY;
                        break;
                    }
                    case READY: {
                        if (new Date().getTime() - SpaceKeyTimer.this.finish.getTime() < 250L) break;
                        SpaceKeyTimer.this.timerManager.startSolution();
                        SpaceKeyTimer.this.start = new Date();
                        SpaceKeyTimer.this.repeater = new java.util.Timer();
                        SpaceKeyTimer.this.repeater.schedule(new TimerTask(){

                            @Override
                            public void run() {
                                SpaceKeyTimer.this.timerManager.updateSolutionTiming(new Timing(SpaceKeyTimer.this.start, new Date()));
                            }
                        }, 0L, 5L);
                        SpaceKeyTimer.this.state = State.RUNNING;
                        break;
                    }
                    case FINISHED: {
                        SpaceKeyTimer.this.state = SpaceKeyTimer.this.inspectionEnabled ? State.READY_FOR_INSPECTION : State.READY;
                    }
                }
                SpaceKeyTimer.this.timerManager.releaseLeftHand();
                SpaceKeyTimer.this.timerManager.releaseRightHand();
            }
        };
        this.frame.addKeyListener(this.keyListener);
        this.timerListener = new TimerManager.Listener(){

            @Override
            public void inspectionFinished() {
                SpaceKeyTimer.this.state = SpaceKeyTimer.this.inspectionEnabled ? State.READY_FOR_INSPECTION : State.READY;
            }
        };
        this.timerManager.addListener(this.timerListener);
    }

    @Override
    public void stop() {
        if (this.repeater != null) {
            this.repeater.cancel();
        }
        this.frame.removeKeyListener(this.keyListener);
        this.timerManager.removeListener(this.timerListener);
    }

    private static enum State {
        READY_FOR_INSPECTION,
        READY,
        RUNNING,
        FINISHED;

    }
}

