/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.tips;

import com.puzzletimer.Internationalization;
import com.puzzletimer.models.Scramble;
import com.puzzletimer.solvers.RubiksCubeSolver;
import com.puzzletimer.tips.Tip;
import java.util.ArrayList;

public class RubiksCube3OPCycles
implements Tip {
    @Override
    public String getTipId() {
        return "RUBIKS-CUBE-3OP-CYCLES";
    }

    @Override
    public String getPuzzleId() {
        return "RUBIKS-CUBE";
    }

    @Override
    public String getTipDescription() {
        return Internationalization._("tip.RUBIKS-CUBE-3OP-CYCLES");
    }

    @Override
    public String getTip(Scramble scramble) {
        StringBuilder tip = new StringBuilder();
        tip.append(String.valueOf(Internationalization._("tip.RUBIKS-CUBE-3OP-CYCLES")) + ":\n  ");
        RubiksCubeSolver.State cubeState = RubiksCubeSolver.State.id.applySequence(scramble.getSequence());
        int[] nArray = new int[8];
        nArray[0] = 3;
        nArray[1] = 2;
        nArray[2] = 1;
        nArray[4] = 7;
        nArray[5] = 6;
        nArray[6] = 5;
        nArray[7] = 4;
        int[] cornersOrder = nArray;
        for (ArrayList<Byte> cycle : this.cycles(cornersOrder, cubeState.cornersPermutation)) {
            if (cycle.size() < 2) continue;
            String[] cornerNames = new String[]{"UBL", "UBR", "UFR", "UFL", "DBL", "DBR", "DFR", "DFL"};
            tip.append("(" + cornerNames[cycle.get(0)]);
            int i = 1;
            while (i < cycle.size()) {
                tip.append(" " + cornerNames[cycle.get(i)]);
                ++i;
            }
            tip.append(")");
        }
        tip.append("\n  ");
        int[] nArray2 = new int[12];
        nArray2[0] = 6;
        nArray2[1] = 7;
        nArray2[2] = 4;
        nArray2[3] = 5;
        nArray2[4] = 3;
        nArray2[6] = 1;
        nArray2[7] = 2;
        nArray2[8] = 10;
        nArray2[9] = 11;
        nArray2[10] = 8;
        nArray2[11] = 9;
        int[] edgesOrder = nArray2;
        for (ArrayList<Byte> cycle : this.cycles(edgesOrder, cubeState.edgesPermutation)) {
            if (cycle.size() < 2) continue;
            String[] edgeNames = new String[]{"BL", "BR", "FR", "FL", "UB", "UR", "UF", "UL", "DB", "DR", "DF", "DL"};
            tip.append("(" + edgeNames[cycle.get(0)]);
            int i = 1;
            while (i < cycle.size()) {
                tip.append(" " + edgeNames[cycle.get(i)]);
                ++i;
            }
            tip.append(")");
        }
        tip.append("\n\n");
        return tip.toString().trim();
    }

    private ArrayList<ArrayList<Byte>> cycles(int[] order, byte[] permutation) {
        boolean[] visited = new boolean[permutation.length];
        int i = 0;
        while (i < visited.length) {
            visited[i] = false;
            ++i;
        }
        ArrayList<ArrayList<Byte>> cycles = new ArrayList<ArrayList<Byte>>();
        int i2 = 0;
        while (i2 < permutation.length) {
            if (!visited[order[i2]]) {
                ArrayList<Byte> cycle = new ArrayList<Byte>();
                byte current = (byte)order[i2];
                do {
                    cycle.add(current);
                    visited[current] = true;
                } while ((current = permutation[current]) != (Byte)cycle.get(0));
                cycles.add(cycle);
            }
            ++i2;
        }
        return cycles;
    }

    public String toString() {
        return this.getTipDescription();
    }
}

