/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.tips;

import com.puzzletimer.Internationalization;
import com.puzzletimer.models.Scramble;
import com.puzzletimer.solvers.RubiksCubeCrossSolver;
import com.puzzletimer.solvers.RubiksCubeSolver;
import com.puzzletimer.tips.Tip;
import com.puzzletimer.util.StringUtils;

public class RubiksCubeOptimalCross
implements Tip {
    private static RubiksCubeSolver.State x;
    private static RubiksCubeSolver.State z;

    static {
        byte[] byArray = new byte[8];
        byArray[0] = 3;
        byArray[1] = 2;
        byArray[2] = 6;
        byArray[3] = 7;
        byArray[5] = 1;
        byArray[6] = 5;
        byArray[7] = 4;
        byte[] byArray2 = new byte[12];
        byArray2[0] = 7;
        byArray2[1] = 5;
        byArray2[2] = 9;
        byArray2[3] = 11;
        byArray2[4] = 6;
        byArray2[5] = 2;
        byArray2[6] = 10;
        byArray2[7] = 3;
        byArray2[8] = 4;
        byArray2[9] = 1;
        byArray2[10] = 8;
        byte[] byArray3 = new byte[12];
        byArray3[4] = 1;
        byArray3[6] = 1;
        byArray3[8] = 1;
        byArray3[10] = 1;
        x = new RubiksCubeSolver.State(byArray, new byte[]{2, 1, 2, 1, 1, 2, 1, 2}, byArray2, byArray3);
        byte[] byArray4 = new byte[8];
        byArray4[0] = 4;
        byArray4[2] = 3;
        byArray4[3] = 7;
        byArray4[4] = 5;
        byArray4[5] = 1;
        byArray4[6] = 2;
        byArray4[7] = 6;
        byte[] byArray5 = new byte[12];
        byArray5[0] = 8;
        byArray5[1] = 4;
        byArray5[2] = 6;
        byArray5[3] = 10;
        byArray5[5] = 7;
        byArray5[6] = 3;
        byArray5[7] = 11;
        byArray5[8] = 1;
        byArray5[9] = 5;
        byArray5[10] = 2;
        byArray5[11] = 9;
        z = new RubiksCubeSolver.State(byArray4, new byte[]{1, 2, 1, 2, 2, 1, 2, 1}, byArray5, new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1});
    }

    @Override
    public String getTipId() {
        return "RUBIKS-CUBE-OPTIMAL-CROSS";
    }

    @Override
    public String getPuzzleId() {
        return "RUBIKS-CUBE";
    }

    @Override
    public String getTipDescription() {
        return Internationalization._("tip.RUBIKS-CUBE-OPTIMAL-CROSS");
    }

    @Override
    public String getTip(Scramble scramble) {
        RubiksCubeSolver.State state = RubiksCubeSolver.State.id.applySequence(scramble.getSequence());
        StringBuilder tip = new StringBuilder();
        RubiksCubeSolver.State stateU = x.multiply(x).multiply(state).multiply(x).multiply(x);
        tip.append(String.valueOf(Internationalization._("tip.RUBIKS-CUBE-OPTIMAL-CROSS.optimal_cross_on_u")) + ":\n");
        for (String[] solution : RubiksCubeCrossSolver.solve(stateU)) {
            tip.append("  x2 " + StringUtils.join(" ", solution) + "\n");
        }
        tip.append("\n");
        RubiksCubeSolver.State stateD = state;
        tip.append(String.valueOf(Internationalization._("tip.RUBIKS-CUBE-OPTIMAL-CROSS.optimal_cross_on_d")) + ":\n");
        for (String[] solution : RubiksCubeCrossSolver.solve(stateD)) {
            tip.append("  " + StringUtils.join(" ", solution) + "\n");
        }
        tip.append("\n");
        RubiksCubeSolver.State stateL = z.multiply(state).multiply(z).multiply(z).multiply(z);
        tip.append(String.valueOf(Internationalization._("tip.RUBIKS-CUBE-OPTIMAL-CROSS.optimal_cross_on_l")) + ":\n");
        for (String[] solution : RubiksCubeCrossSolver.solve(stateL)) {
            tip.append("  z' " + StringUtils.join(" ", solution) + "\n");
        }
        tip.append("\n");
        RubiksCubeSolver.State stateR = z.multiply(z).multiply(z).multiply(state).multiply(z);
        tip.append(String.valueOf(Internationalization._("tip.RUBIKS-CUBE-OPTIMAL-CROSS.optimal_cross_on_r")) + ":\n");
        for (String[] solution : RubiksCubeCrossSolver.solve(stateR)) {
            tip.append("  z " + StringUtils.join(" ", solution) + "\n");
        }
        tip.append("\n");
        RubiksCubeSolver.State stateF = x.multiply(state).multiply(x).multiply(x).multiply(x);
        tip.append(String.valueOf(Internationalization._("tip.RUBIKS-CUBE-OPTIMAL-CROSS.optimal_cross_on_f")) + ":\n");
        for (String[] solution : RubiksCubeCrossSolver.solve(stateF)) {
            tip.append("  x' " + StringUtils.join(" ", solution) + "\n");
        }
        tip.append("\n");
        RubiksCubeSolver.State stateB = x.multiply(x).multiply(x).multiply(state).multiply(x);
        tip.append(String.valueOf(Internationalization._("tip.RUBIKS-CUBE-OPTIMAL-CROSS.optimal_cross_on_b")) + ":\n");
        for (String[] solution : RubiksCubeCrossSolver.solve(stateB)) {
            tip.append("  x " + StringUtils.join(" ", solution) + "\n");
        }
        tip.append("\n");
        return tip.toString().trim();
    }

    public String toString() {
        return this.getTipDescription();
    }
}

