/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.tips;

import com.puzzletimer.Internationalization;
import com.puzzletimer.models.Scramble;
import com.puzzletimer.solvers.RubiksCubeSolver;
import com.puzzletimer.solvers.RubiksCubeXCrossSolver;
import com.puzzletimer.tips.Tip;
import com.puzzletimer.util.StringUtils;
import java.util.ArrayList;

public class RubiksCubeOptimalXCross
implements Tip {
    private static RubiksCubeSolver.State x;
    private static RubiksCubeSolver.State y;
    private static RubiksCubeSolver.State z;

    static {
        byte[] byArray = new byte[8];
        byArray[0] = 3;
        byArray[1] = 2;
        byArray[2] = 6;
        byArray[3] = 7;
        byArray[5] = 1;
        byArray[6] = 5;
        byArray[7] = 4;
        byte[] byArray2 = new byte[12];
        byArray2[0] = 7;
        byArray2[1] = 5;
        byArray2[2] = 9;
        byArray2[3] = 11;
        byArray2[4] = 6;
        byArray2[5] = 2;
        byArray2[6] = 10;
        byArray2[7] = 3;
        byArray2[8] = 4;
        byArray2[9] = 1;
        byArray2[10] = 8;
        byte[] byArray3 = new byte[12];
        byArray3[4] = 1;
        byArray3[6] = 1;
        byArray3[8] = 1;
        byArray3[10] = 1;
        x = new RubiksCubeSolver.State(byArray, new byte[]{2, 1, 2, 1, 1, 2, 1, 2}, byArray2, byArray3);
        byte[] byArray4 = new byte[8];
        byArray4[0] = 3;
        byArray4[2] = 1;
        byArray4[3] = 2;
        byArray4[4] = 7;
        byArray4[5] = 4;
        byArray4[6] = 5;
        byArray4[7] = 6;
        byte[] byArray5 = new byte[12];
        byArray5[0] = 3;
        byArray5[2] = 1;
        byArray5[3] = 2;
        byArray5[4] = 7;
        byArray5[5] = 4;
        byArray5[6] = 5;
        byArray5[7] = 6;
        byArray5[8] = 11;
        byArray5[9] = 8;
        byArray5[10] = 9;
        byArray5[11] = 10;
        byte[] byArray6 = new byte[12];
        byArray6[0] = 1;
        byArray6[1] = 1;
        byArray6[2] = 1;
        byArray6[3] = 1;
        y = new RubiksCubeSolver.State(byArray4, new byte[8], byArray5, byArray6);
        byte[] byArray7 = new byte[8];
        byArray7[0] = 4;
        byArray7[2] = 3;
        byArray7[3] = 7;
        byArray7[4] = 5;
        byArray7[5] = 1;
        byArray7[6] = 2;
        byArray7[7] = 6;
        byte[] byArray8 = new byte[12];
        byArray8[0] = 8;
        byArray8[1] = 4;
        byArray8[2] = 6;
        byArray8[3] = 10;
        byArray8[5] = 7;
        byArray8[6] = 3;
        byArray8[7] = 11;
        byArray8[8] = 1;
        byArray8[9] = 5;
        byArray8[10] = 2;
        byArray8[11] = 9;
        z = new RubiksCubeSolver.State(byArray7, new byte[]{1, 2, 1, 2, 2, 1, 2, 1}, byArray8, new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1});
    }

    @Override
    public String getTipId() {
        return "RUBIKS-CUBE-OPTIMAL-X-CROSS";
    }

    @Override
    public String getPuzzleId() {
        return "RUBIKS-CUBE";
    }

    @Override
    public String getTipDescription() {
        return Internationalization._("tip.RUBIKS-CUBE-OPTIMAL-X-CROSS");
    }

    @Override
    public String getTip(Scramble scramble) {
        RubiksCubeSolver.State state = RubiksCubeSolver.State.id.applySequence(scramble.getSequence());
        StringBuilder tip = new StringBuilder();
        RubiksCubeSolver.State stateU = x.multiply(x).multiply(state).multiply(x).multiply(x);
        tip.append(String.valueOf(Internationalization._("tip.RUBIKS-CUBE-OPTIMAL-X-CROSS.optimal_x_cross_on_u")) + ":\n");
        tip.append(this.getOptimalSolutions(stateU, "x2 "));
        tip.append("\n");
        RubiksCubeSolver.State stateD = state;
        tip.append(String.valueOf(Internationalization._("tip.RUBIKS-CUBE-OPTIMAL-X-CROSS.optimal_x_cross_on_d")) + ":\n");
        tip.append(this.getOptimalSolutions(stateD, ""));
        tip.append("\n");
        RubiksCubeSolver.State stateL = z.multiply(state).multiply(z).multiply(z).multiply(z);
        tip.append(String.valueOf(Internationalization._("tip.RUBIKS-CUBE-OPTIMAL-X-CROSS.optimal_x_cross_on_l")) + ":\n");
        tip.append(this.getOptimalSolutions(stateL, "z' "));
        tip.append("\n");
        RubiksCubeSolver.State stateR = z.multiply(z).multiply(z).multiply(state).multiply(z);
        tip.append(String.valueOf(Internationalization._("tip.RUBIKS-CUBE-OPTIMAL-X-CROSS.optimal_x_cross_on_r")) + ":\n");
        tip.append(this.getOptimalSolutions(stateR, "z "));
        tip.append("\n");
        RubiksCubeSolver.State stateF = x.multiply(state).multiply(x).multiply(x).multiply(x);
        tip.append(String.valueOf(Internationalization._("tip.RUBIKS-CUBE-OPTIMAL-X-CROSS.optimal_x_cross_on_f")) + ":\n");
        tip.append(this.getOptimalSolutions(stateF, "x' "));
        tip.append("\n");
        RubiksCubeSolver.State stateB = x.multiply(x).multiply(x).multiply(state).multiply(x);
        tip.append(String.valueOf(Internationalization._("tip.RUBIKS-CUBE-OPTIMAL-X-CROSS.optimal_x_cross_on_b")) + ":\n");
        tip.append(this.getOptimalSolutions(stateB, "x "));
        tip.append("\n");
        return tip.toString().trim();
    }

    private String getOptimalSolutions(RubiksCubeSolver.State state, String prefix) {
        ArrayList<String> prefixes = new ArrayList<String>();
        ArrayList<String[]> solutions = new ArrayList<String[]>();
        RubiksCubeSolver.State stateId = state;
        for (String[] solution : RubiksCubeXCrossSolver.solve(stateId)) {
            prefixes.add(prefix);
            solutions.add(solution);
        }
        RubiksCubeSolver.State stateY = y.multiply(y).multiply(y).multiply(state).multiply(y);
        for (String[] solution : RubiksCubeXCrossSolver.solve(stateY)) {
            prefixes.add(String.valueOf(prefix) + "y ");
            solutions.add(solution);
        }
        RubiksCubeSolver.State stateY2 = y.multiply(y).multiply(state).multiply(y).multiply(y);
        for (String[] solution : RubiksCubeXCrossSolver.solve(stateY2)) {
            prefixes.add(String.valueOf(prefix) + "y2 ");
            solutions.add(solution);
        }
        RubiksCubeSolver.State stateY3 = y.multiply(state).multiply(y).multiply(y).multiply(y);
        for (String[] solution : RubiksCubeXCrossSolver.solve(stateY3)) {
            prefixes.add(String.valueOf(prefix) + "y' ");
            solutions.add(solution);
        }
        int minLength = Integer.MAX_VALUE;
        for (String[] solution : solutions) {
            if (solution.length >= minLength) continue;
            minLength = solution.length;
        }
        StringBuilder output = new StringBuilder();
        int i = 0;
        while (i < solutions.size()) {
            if (((String[])solutions.get(i)).length == minLength) {
                output.append(String.format("  %s%s\n", prefixes.get(i), StringUtils.join(" ", (String[])solutions.get(i))));
            }
            ++i;
        }
        return output.toString();
    }

    public String toString() {
        return this.getTipDescription();
    }
}

