/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.graphics;

import com.puzzletimer.graphics.Face;
import com.puzzletimer.graphics.Mesh;
import com.puzzletimer.graphics.algebra.Matrix44;
import com.puzzletimer.graphics.algebra.Vector3;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JPanel;

public class Panel3D
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    public Mesh mesh = new Mesh(new ArrayList<Vector3>(), new ArrayList<Face>());
    public Vector3 lightDirection = new Vector3(0.0, 0.25, -1.0).normalized();
    public Vector3 viewerPosition = new Vector3(0.0, 0.0, -325.0);
    public Vector3 cameraPosition = new Vector3(0.0, 0.0, -3.0);
    public Vector3 cameraRotation = new Vector3(0.0, 0.0, 0.0);
    private int lastX = 0;
    private int lastY = 0;

    public Panel3D() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
    }

    private Vector3 toCameraCoordinates(Vector3 v) {
        return Matrix44.rotationX(-this.cameraRotation.x).mul(Matrix44.rotationY(-this.cameraRotation.y).mul(Matrix44.rotationZ(-this.cameraRotation.z).mul(v.sub(this.cameraPosition))));
    }

    private Vector3 perspectiveProjection(Vector3 v) {
        return new Vector3((double)this.getWidth() / 2.0 + (-v.x - this.viewerPosition.x) * (this.viewerPosition.z / v.z), (double)this.getHeight() / 2.0 + (v.y - this.viewerPosition.y) * (this.viewerPosition.z / v.z), 0.0);
    }

    private Vector3 triangleNormal(Vector3 v1, Vector3 v2, Vector3 v3) {
        return v2.sub(v1).cross(v3.sub(v1)).normalized();
    }

    @Override
    public void paintComponent(Graphics g) {
        Polygon p;
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ArrayList<Vector3> pVertices = new ArrayList<Vector3>();
        for (Vector3 v : this.mesh.vertices) {
            pVertices.add(this.perspectiveProjection(this.toCameraCoordinates(v)));
        }
        ArrayList<Face> frontFaces = new ArrayList<Face>();
        ArrayList<Face> backFaces = new ArrayList<Face>();
        for (Face f : this.mesh.faces) {
            Vector3 n = this.triangleNormal((Vector3)pVertices.get(f.vertexIndices.get(0)), (Vector3)pVertices.get(f.vertexIndices.get(1)), (Vector3)pVertices.get(f.vertexIndices.get(2)));
            if (n.z >= 0.0) {
                frontFaces.add(f);
                continue;
            }
            backFaces.add(f);
        }
        g2.setColor(new Color(0.1f, 0.1f, 0.1f, 0.2f));
        for (Face f : backFaces) {
            p = new Polygon();
            for (int i : f.vertexIndices) {
                p.addPoint((int)((Vector3)pVertices.get((int)i)).x, (int)((Vector3)pVertices.get((int)i)).y);
            }
            g2.fillPolygon(p);
        }
        Collections.sort(frontFaces, new Comparator<Face>(){

            @Override
            public int compare(Face f1, Face f2) {
                double centroidZ1 = 0.0;
                for (int i : f1.vertexIndices) {
                    centroidZ1 += Panel3D.this.mesh.vertices.get((int)i).z;
                }
                centroidZ1 /= (double)f1.vertexIndices.size();
                double centroidZ2 = 0.0;
                for (int i : f2.vertexIndices) {
                    centroidZ2 += Panel3D.this.mesh.vertices.get((int)i).z;
                }
                return centroidZ1 > (centroidZ2 /= (double)f2.vertexIndices.size()) ? -1 : 1;
            }
        });
        for (Face f : frontFaces) {
            p = new Polygon();
            for (int i : f.vertexIndices) {
                p.addPoint((int)((Vector3)pVertices.get((int)i)).x, (int)((Vector3)pVertices.get((int)i)).y);
            }
            Vector3 n = this.triangleNormal(this.mesh.vertices.get(f.vertexIndices.get(0)), this.mesh.vertices.get(f.vertexIndices.get(1)), this.mesh.vertices.get(f.vertexIndices.get(2)));
            double light = Math.abs(this.lightDirection.dot(n));
            float[] hsbColor = Color.RGBtoHSB(f.color.getRed(), f.color.getGreen(), f.color.getBlue(), null);
            Color fillColor = new Color(Color.HSBtoRGB(hsbColor[0], (float)(0.875 + 0.125 * light) * hsbColor[1], (float)(0.875 + 0.125 * light) * hsbColor[2]));
            g2.setColor(fillColor);
            g2.fillPolygon(p);
            Color outlineColor = new Color(Color.HSBtoRGB(hsbColor[0], (float)(0.9 * (0.875 + 0.125 * light) * (double)hsbColor[1]), (float)(0.9 * (0.875 + 0.125 * light) * (double)hsbColor[2])));
            g2.setColor(outlineColor);
            g2.drawPolygon(p);
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.lastX = e.getX();
        this.lastY = e.getY();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        double angleX = (double)(e.getY() - this.lastY) / 50.0;
        double angleY = (double)(e.getX() - this.lastX) / 50.0;
        this.mesh = this.mesh.transform(Matrix44.rotationZ(this.cameraRotation.z).mul(Matrix44.rotationY(this.cameraRotation.y).mul(Matrix44.rotationX(this.cameraRotation.x).mul(Matrix44.rotationX(angleX).mul(Matrix44.rotationY(angleY).mul(Matrix44.rotationX(-this.cameraRotation.x).mul(Matrix44.rotationY(-this.cameraRotation.y).mul(Matrix44.rotationZ(-this.cameraRotation.z)))))))));
        this.lastX = e.getX();
        this.lastY = e.getY();
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        Vector3 direction = this.cameraPosition.normalized();
        Vector3 newPosition = this.cameraPosition.add(direction.mul(0.1 * (double)e.getWheelRotation()));
        if (1.0 < newPosition.norm() && newPosition.norm() < 50.0) {
            this.cameraPosition = newPosition;
        }
        this.repaint();
    }
}

