/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.gui;

import com.puzzletimer.gui.CategoryEditorListener;
import com.puzzletimer.models.Category;
import com.puzzletimer.models.PuzzleInfo;
import com.puzzletimer.models.ScramblerInfo;
import com.puzzletimer.puzzles.Puzzle;
import com.puzzletimer.scramblers.Scrambler;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;

class CategoryEditorDialog
extends JDialog {
    private JTextField textFieldDescription;
    private JComboBox comboBoxPuzzle;
    private JComboBox comboBoxScrambler;
    private JButton buttonOk;
    private JButton buttonCancel;

    public CategoryEditorDialog(JFrame owner, boolean modal, Puzzle[] puzzles, final Scrambler[] scramblers, final Category category, boolean isEditable, final CategoryEditorListener listener) {
        super((Frame)owner, modal);
        this.setTitle("Category Editor");
        this.setMinimumSize(new Dimension(480, 180));
        this.setPreferredSize(this.getMinimumSize());
        this.createComponents();
        this.textFieldDescription.setText(category.getDescription());
        Puzzle[] puzzleArray = puzzles;
        int n = puzzles.length;
        int n2 = 0;
        while (n2 < n) {
            Puzzle puzzle = puzzleArray[n2];
            this.comboBoxPuzzle.addItem(puzzle.getPuzzleInfo());
            ++n2;
        }
        this.comboBoxPuzzle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CategoryEditorDialog.this.comboBoxScrambler.removeAllItems();
                PuzzleInfo selectedPuzzle = (PuzzleInfo)CategoryEditorDialog.this.comboBoxPuzzle.getSelectedItem();
                Scrambler[] scramblerArray = scramblers;
                int n = scramblers.length;
                int n2 = 0;
                while (n2 < n) {
                    Scrambler scrambler = scramblerArray[n2];
                    ScramblerInfo scramblerInfo = scrambler.getScramblerInfo();
                    if (scramblerInfo.getPuzzleId().equals(selectedPuzzle.getPuzzleId())) {
                        CategoryEditorDialog.this.comboBoxScrambler.addItem(scramblerInfo);
                    }
                    ++n2;
                }
            }
        });
        this.comboBoxPuzzle.setEnabled(isEditable);
        this.comboBoxScrambler.setEnabled(isEditable);
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String scramblerId = ((ScramblerInfo)CategoryEditorDialog.this.comboBoxScrambler.getSelectedItem()).getScramblerId();
                String description = CategoryEditorDialog.this.textFieldDescription.getText();
                listener.categoryEdited(category.setScramblerId(scramblerId).setDescription(description));
                CategoryEditorDialog.this.dispose();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CategoryEditorDialog.this.dispose();
            }
        });
        ScramblerInfo categoryScramblerInfo = null;
        Scrambler[] scramblerArray = scramblers;
        int n3 = scramblers.length;
        n = 0;
        while (n < n3) {
            Scrambler scrambler = scramblerArray[n];
            ScramblerInfo scramblerInfo = scrambler.getScramblerInfo();
            if (scramblerInfo.getScramblerId().equals(category.getScramblerId())) {
                categoryScramblerInfo = scramblerInfo;
                break;
            }
            ++n;
        }
        int i = 0;
        while (i < this.comboBoxPuzzle.getItemCount()) {
            PuzzleInfo puzzleInfo = (PuzzleInfo)this.comboBoxPuzzle.getItemAt(i);
            if (puzzleInfo.getPuzzleId().equals(categoryScramblerInfo.getPuzzleId())) {
                this.comboBoxPuzzle.setSelectedIndex(i);
                break;
            }
            ++i;
        }
        i = 0;
        while (i < this.comboBoxScrambler.getItemCount()) {
            ScramblerInfo scramblerInfo = (ScramblerInfo)this.comboBoxScrambler.getItemAt(i);
            if (scramblerInfo.getScramblerId().equals(categoryScramblerInfo.getScramblerId())) {
                this.comboBoxScrambler.setSelectedIndex(i);
                break;
            }
            ++i;
        }
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CategoryEditorDialog.this.setVisible(false);
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    private void createComponents() {
        this.setLayout(new MigLayout("fill, wrap", "[pref!][fill]", "[pref!]8[pref!]8[pref!]16[bottom]"));
        JLabel labelDescription = new JLabel("Description:");
        this.add(labelDescription);
        this.textFieldDescription = new JTextField();
        this.add(this.textFieldDescription);
        JLabel labelPuzzle = new JLabel("Puzzle:");
        this.add(labelPuzzle);
        this.comboBoxPuzzle = new JComboBox();
        this.add(this.comboBoxPuzzle);
        JLabel labelScrambler = new JLabel("Scrambler:");
        this.add(labelScrambler);
        this.comboBoxScrambler = new JComboBox();
        this.add(this.comboBoxScrambler);
        this.buttonOk = new JButton("OK");
        this.add((Component)this.buttonOk, "right, width 100, span 2, split");
        this.buttonCancel = new JButton("Cancel");
        this.add((Component)this.buttonCancel, "width 100");
    }
}

