/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.gui;

import com.puzzletimer.models.Solution;
import com.puzzletimer.util.SolutionUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JPanel;

public class HistogramPanel
extends JPanel {
    private long[] bins;
    private long intervalStart;
    private long intervalEnd;

    public HistogramPanel(Solution[] solutions, int nBins) {
        this.setBackground(Color.WHITE);
        this.bins = new long[nBins];
        this.setSolutions(solutions);
    }

    public void setSolutions(Solution[] solutions) {
        long[] times = SolutionUtils.realTimes(solutions, true);
        if (times.length == 0) {
            this.intervalStart = 17000L;
            this.intervalEnd = 23000L;
        } else {
            long mean = 0L;
            int i = 0;
            while (i < times.length) {
                mean += times[i];
                ++i;
            }
            mean /= (long)times.length;
            long variance = 0L;
            int i2 = 0;
            while (i2 < times.length) {
                variance = (long)((double)variance + Math.pow(times[i2] - mean, 2.0));
                ++i2;
            }
            long stddev = (long)Math.sqrt(variance /= (long)times.length);
            this.intervalStart = mean - 3L * Math.max(50L, stddev);
            this.intervalEnd = mean + 3L * Math.max(50L, stddev);
        }
        int i = 0;
        while (i < this.bins.length) {
            this.bins[i] = 0L;
            ++i;
        }
        i = 0;
        while (i < times.length) {
            if (times[i] >= this.intervalStart && times[i] < this.intervalEnd) {
                int bin;
                int n = bin = (int)((long)this.bins.length * (times[i] - this.intervalStart) / (this.intervalEnd - this.intervalStart));
                this.bins[n] = this.bins[n] + 1L;
            }
            ++i;
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        int height;
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setFont(new Font("Arial", 1, 10));
        int hBase = 16;
        g2.drawLine(0, this.getHeight() - hBase, this.getWidth() - 1, this.getHeight() - hBase);
        double wBar = (double)this.getWidth() / (double)(this.bins.length + 1);
        int i = 0;
        while (i < this.bins.length + 1) {
            int x = (int)(((double)i + 0.5) * wBar);
            int y = this.getHeight() - hBase;
            g2.drawLine(x, y - 2, x, y + 2);
            ++i;
        }
        double binInterval = (double)(this.intervalEnd - this.intervalStart) / (double)this.bins.length;
        int i2 = 0;
        while (i2 < this.bins.length + 1) {
            long value = (long)((double)this.intervalStart + (double)i2 * binInterval);
            String label = SolutionUtils.formatSeconds(value);
            FontMetrics fontMetrics = g2.getFontMetrics();
            int width = fontMetrics.stringWidth(label);
            height = fontMetrics.getAscent();
            int x = (int)(((double)i2 + 0.5) * wBar - (double)(width / 2));
            int y = this.getHeight() - (hBase - height) / 2;
            g2.drawString(label, x, y);
            ++i2;
        }
        long maxValue = 0L;
        int i3 = 0;
        while (i3 < this.bins.length) {
            if (this.bins[i3] > maxValue) {
                maxValue = this.bins[i3];
            }
            ++i3;
        }
        if (maxValue > 0L) {
            i3 = 0;
            while (i3 < this.bins.length) {
                int x1 = (int)(((double)i3 + 0.5) * wBar);
                int x2 = (int)(((double)i3 + 1.5) * wBar);
                int y = this.getHeight() - hBase;
                height = (int)(this.bins[i3] * (long)(this.getHeight() - hBase - 4) / maxValue);
                g2.drawRect(x1, y - height, x2 - x1, height);
                ++i3;
            }
        }
    }
}

