/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.gui;

import com.puzzletimer.gui.GraphPanel;
import com.puzzletimer.gui.HistogramPanel;
import com.puzzletimer.models.Category;
import com.puzzletimer.models.Scramble;
import com.puzzletimer.models.Solution;
import com.puzzletimer.models.Timing;
import com.puzzletimer.parsers.ScrambleParser;
import com.puzzletimer.parsers.ScrambleParserProvider;
import com.puzzletimer.scramblers.Scrambler;
import com.puzzletimer.scramblers.ScramblerProvider;
import com.puzzletimer.state.CategoryListener;
import com.puzzletimer.state.CategoryManager;
import com.puzzletimer.state.ScrambleManager;
import com.puzzletimer.state.SolutionListener;
import com.puzzletimer.state.SolutionManager;
import com.puzzletimer.statistics.Average;
import com.puzzletimer.statistics.Best;
import com.puzzletimer.statistics.BestAverage;
import com.puzzletimer.statistics.BestMean;
import com.puzzletimer.statistics.Mean;
import com.puzzletimer.statistics.Percentile;
import com.puzzletimer.statistics.StandardDeviation;
import com.puzzletimer.statistics.StatisticalMeasure;
import com.puzzletimer.statistics.Worst;
import com.puzzletimer.util.SolutionUtils;
import com.puzzletimer.util.StringUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;

public class HistoryFrame
extends JFrame {
    private HistogramPanel histogramPanel;
    private GraphPanel graphPanel;
    private JLabel labelMean;
    private JLabel labelBest;
    private JLabel labelMeanOf3;
    private JLabel labelBestMeanOf3;
    private JLabel labelStandardDeviation;
    private JLabel labelLowerQuartile;
    private JLabel labelMeanOf10;
    private JLabel labelBestMeanOf10;
    private JLabel labelMedian;
    private JLabel labelMeanOf100;
    private JLabel labelBestMeanOf100;
    private JLabel labelUpperQuartile;
    private JLabel labelAverageOf5;
    private JLabel labelBestAverageOf5;
    private JLabel labelWorst;
    private JLabel labelAverageOf12;
    private JLabel labelBestAverageOf12;
    private JTable table;
    private JButton buttonAddSolutions;
    private JButton buttonEdit;
    private JButton buttonRemove;
    private JButton buttonEnqueueScrambles;
    private JButton buttonOk;

    public HistoryFrame(final ScramblerProvider scramblerProvider, final ScrambleParserProvider scrambleParserProvider, final CategoryManager categoryManager, final ScrambleManager scrambleManager, final SolutionManager solutionManager) {
        this.setMinimumSize(new Dimension(800, 600));
        this.setPreferredSize(this.getMinimumSize());
        this.createComponents();
        categoryManager.addCategoryListener(new CategoryListener(){

            @Override
            public void categoriesUpdated(Category[] categories, Category currentCategory) {
                HistoryFrame.this.setTitle("History - " + currentCategory.getDescription());
            }
        });
        categoryManager.notifyListeners();
        solutionManager.addSolutionListener(new SolutionListener(){

            @Override
            public void solutionsUpdated(Solution[] solutions) {
                int[] selectedRows = new int[solutions.length];
                int i = 0;
                while (i < selectedRows.length) {
                    selectedRows[i] = i;
                    ++i;
                }
                HistoryFrame.this.histogramPanel.setSolutions(solutions);
                HistoryFrame.this.graphPanel.setSolutions(solutions);
                HistoryFrame.this.updateStatistics(solutions, selectedRows);
                HistoryFrame.this.updateTable(solutions);
            }
        });
        solutionManager.notifyListeners();
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                Solution[] selectedSolutions;
                Solution[] solutions = solutionManager.getSolutions();
                int[] selectedRows = HistoryFrame.this.table.getSelectedRows();
                if (selectedRows.length <= 0) {
                    selectedRows = new int[HistoryFrame.this.table.getRowCount()];
                    int i = 0;
                    while (i < selectedRows.length) {
                        selectedRows[i] = i;
                        ++i;
                    }
                    selectedSolutions = solutions;
                } else {
                    selectedSolutions = new Solution[selectedRows.length];
                    int i = 0;
                    while (i < selectedSolutions.length) {
                        selectedSolutions[i] = solutions[selectedRows[i]];
                        ++i;
                    }
                }
                HistoryFrame.this.histogramPanel.setSolutions(selectedSolutions);
                HistoryFrame.this.graphPanel.setSolutions(selectedSolutions);
                HistoryFrame.this.updateStatistics(selectedSolutions, selectedRows);
                HistoryFrame.this.buttonEdit.setEnabled(HistoryFrame.this.table.getSelectedRowCount() == 1);
                HistoryFrame.this.buttonRemove.setEnabled(HistoryFrame.this.table.getSelectedRowCount() > 0);
                HistoryFrame.this.buttonEnqueueScrambles.setEnabled(HistoryFrame.this.table.getSelectedRowCount() > 0);
            }
        });
        this.buttonAddSolutions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SolutionImporterDialog.SolutionImporterListener listener = new SolutionImporterDialog.SolutionImporterListener(){

                    @Override
                    public void solutionsImported(Solution[] solutions) {
                        solutionManager.addSolutions(solutions);
                    }
                };
                Category currentCategory = categoryManager.getCurrentCategory();
                Scrambler currentScrambler = scramblerProvider.get(currentCategory.getScramblerId());
                String puzzleId = currentScrambler.getScramblerInfo().getPuzzleId();
                ScrambleParser scrambleParser = scrambleParserProvider.get(puzzleId);
                SolutionImporterDialog solutionEditingDialog = new SolutionImporterDialog(HistoryFrame.this, true, currentCategory.getCategoryId(), currentCategory.getScramblerId(), scrambleParser, listener);
                solutionEditingDialog.setLocationRelativeTo(null);
                solutionEditingDialog.setVisible(true);
            }
        });
        this.buttonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Solution[] solutions = solutionManager.getSolutions();
                Solution solution = solutions[HistoryFrame.this.table.getSelectedRow()];
                SolutionEditingDialog.SolutionEditingDialogListener listener = new SolutionEditingDialog.SolutionEditingDialogListener(){

                    @Override
                    public void solutionEdited(Solution solution) {
                        solutionManager.updateSolution(solution);
                    }
                };
                SolutionEditingDialog solutionEditingDialog = new SolutionEditingDialog(HistoryFrame.this, true, solution, listener);
                solutionEditingDialog.setLocationRelativeTo(null);
                solutionEditingDialog.setVisible(true);
            }
        });
        this.buttonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Solution[] solutions = solutionManager.getSolutions();
                int[] selectedRows = HistoryFrame.this.table.getSelectedRows();
                int i = 0;
                while (i < selectedRows.length) {
                    solutionManager.removeSolution(solutions[selectedRows[i]]);
                    ++i;
                }
            }
        });
        this.buttonEnqueueScrambles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Solution[] solutions = solutionManager.getSolutions();
                int[] selectedRows = HistoryFrame.this.table.getSelectedRows();
                Scramble[] selectedScrambles = new Scramble[selectedRows.length];
                int i = 0;
                while (i < selectedScrambles.length) {
                    selectedScrambles[i] = solutions[selectedRows[i]].getScramble();
                    ++i;
                }
                scrambleManager.addScrambles(selectedScrambles);
            }
        });
        this.setDefaultCloseOperation(1);
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                HistoryFrame.this.setVisible(false);
            }
        });
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                HistoryFrame.this.setVisible(false);
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    private void createComponents() {
        this.setLayout(new MigLayout("fill", "[][pref!]", "[pref!][pref!]12[pref!][pref!]12[pref!][pref!]12[pref!][]16[pref!]"));
        this.add((Component)new JLabel("Histogram"), "span, wrap");
        this.histogramPanel = new HistogramPanel(new Solution[0], 17);
        this.add((Component)this.histogramPanel, "growx, height 90, span, wrap");
        this.add((Component)new JLabel("Graph"), "span, wrap");
        this.graphPanel = new GraphPanel(new Solution[0]);
        this.add((Component)this.graphPanel, "growx, height 90, span, wrap");
        this.add((Component)new JLabel("Statistics"), "span, wrap");
        JPanel panelStatistics = new JPanel(new MigLayout("fill, insets 0 n 0 n", "[][pref!]32[][pref!]32[][pref!]32[][pref!]", "[pref!]1[pref!]1[pref!]1[pref!]1[pref!]"));
        this.add((Component)panelStatistics, "growx, span, wrap");
        panelStatistics.add((Component)new JLabel("Mean:"), "");
        this.labelMean = new JLabel("XX:XX.XX");
        panelStatistics.add((Component)this.labelMean, "");
        panelStatistics.add((Component)new JLabel("Best:"), "");
        this.labelBest = new JLabel("XX:XX.XX");
        panelStatistics.add((Component)this.labelBest, "");
        panelStatistics.add((Component)new JLabel("Mean of 3:"), "");
        this.labelMeanOf3 = new JLabel("XX:XX.XX");
        panelStatistics.add((Component)this.labelMeanOf3, "");
        panelStatistics.add((Component)new JLabel("Best mean of 3:"), "");
        this.labelBestMeanOf3 = new JLabel("XX:XX.XX");
        panelStatistics.add((Component)this.labelBestMeanOf3, "wrap");
        panelStatistics.add((Component)new JLabel("Standard Deviation:"), "");
        this.labelStandardDeviation = new JLabel("XX:XX.XX");
        panelStatistics.add((Component)this.labelStandardDeviation, "");
        panelStatistics.add((Component)new JLabel("Lower quartile:"), "");
        this.labelLowerQuartile = new JLabel("XX:XX.XX");
        panelStatistics.add((Component)this.labelLowerQuartile, "");
        panelStatistics.add((Component)new JLabel("Mean of 10:"), "");
        this.labelMeanOf10 = new JLabel("XX:XX.XX");
        panelStatistics.add((Component)this.labelMeanOf10, "");
        panelStatistics.add((Component)new JLabel("Best mean of 10:"), "");
        this.labelBestMeanOf10 = new JLabel("XX:XX.XX");
        panelStatistics.add((Component)this.labelBestMeanOf10, "wrap");
        panelStatistics.add((Component)new JLabel("Median:"), "skip 2");
        this.labelMedian = new JLabel("XX:XX.XX");
        panelStatistics.add((Component)this.labelMedian, "");
        panelStatistics.add((Component)new JLabel("Mean of 100:"), "");
        this.labelMeanOf100 = new JLabel("XX:XX.XX");
        panelStatistics.add((Component)this.labelMeanOf100, "");
        panelStatistics.add((Component)new JLabel("Best mean of 100:"), "");
        this.labelBestMeanOf100 = new JLabel("XX:XX.XX");
        panelStatistics.add((Component)this.labelBestMeanOf100, "wrap");
        panelStatistics.add((Component)new JLabel("Upper quartile:"), "skip 2");
        this.labelUpperQuartile = new JLabel("XX:XX.XX");
        panelStatistics.add((Component)this.labelUpperQuartile, "");
        panelStatistics.add((Component)new JLabel("Average of 5:"), "");
        this.labelAverageOf5 = new JLabel("XX:XX.XX");
        panelStatistics.add((Component)this.labelAverageOf5, "");
        panelStatistics.add((Component)new JLabel("Best average of 5:"), "");
        this.labelBestAverageOf5 = new JLabel("XX:XX.XX");
        panelStatistics.add((Component)this.labelBestAverageOf5, "wrap");
        panelStatistics.add((Component)new JLabel("Worst:"), "skip 2");
        this.labelWorst = new JLabel("XX:XX.XX");
        panelStatistics.add((Component)this.labelWorst, "");
        panelStatistics.add((Component)new JLabel("Average of 12:"), "");
        this.labelAverageOf12 = new JLabel("XX:XX.XX");
        panelStatistics.add((Component)this.labelAverageOf12, "");
        panelStatistics.add((Component)new JLabel("Best average of 12:"), "");
        this.labelBestAverageOf12 = new JLabel("XX:XX.XX");
        panelStatistics.add((Component)this.labelBestAverageOf12, "");
        JLabel labelTimes = new JLabel("Solutions");
        this.add((Component)labelTimes, "span, wrap");
        this.table = new JTable();
        this.table.setShowVerticalLines(false);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.table.setFillsViewportHeight(true);
        this.add((Component)scrollPane, "grow");
        this.buttonAddSolutions = new JButton("Add solutions...");
        this.add((Component)this.buttonAddSolutions, "growx, top, split 4, flowy");
        this.buttonEdit = new JButton("Edit...");
        this.buttonEdit.setEnabled(false);
        this.add((Component)this.buttonEdit, "growx, top");
        this.buttonRemove = new JButton("Remove");
        this.buttonRemove.setEnabled(false);
        this.add((Component)this.buttonRemove, "growx, top");
        this.buttonEnqueueScrambles = new JButton("Enqueue scrambles");
        this.buttonEnqueueScrambles.setEnabled(false);
        this.add((Component)this.buttonEnqueueScrambles, "growx, top, gaptop 20, wrap");
        this.buttonOk = new JButton("OK");
        this.add((Component)this.buttonOk, "width 100, right, span");
    }

    private void updateStatistics(Solution[] solutions, final int[] selectedRows) {
        JLabel[] labels = new JLabel[]{this.labelMean, this.labelBest, this.labelMeanOf3, this.labelBestMeanOf3, this.labelStandardDeviation, this.labelLowerQuartile, this.labelMeanOf10, this.labelBestMeanOf10, this.labelMedian, this.labelMeanOf100, this.labelBestMeanOf100, this.labelUpperQuartile, this.labelAverageOf5, this.labelBestAverageOf5, this.labelWorst, this.labelAverageOf12, this.labelBestAverageOf12};
        StatisticalMeasure[] measures = new StatisticalMeasure[]{new Mean(1, Integer.MAX_VALUE), new Best(1, Integer.MAX_VALUE), new Mean(3, 3), new BestMean(3, Integer.MAX_VALUE), new StandardDeviation(1, Integer.MAX_VALUE), new Percentile(1, Integer.MAX_VALUE, 0.25), new Mean(10, 10), new BestMean(10, Integer.MAX_VALUE), new Percentile(1, Integer.MAX_VALUE, 0.5), new Mean(100, 100), new BestMean(100, Integer.MAX_VALUE), new Percentile(1, Integer.MAX_VALUE, 0.75), new Average(5, 5), new BestAverage(5, Integer.MAX_VALUE), new Worst(1, Integer.MAX_VALUE), new Average(12, 12), new BestAverage(12, Integer.MAX_VALUE)};
        boolean[] blArray = new boolean[17];
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[6] = true;
        blArray[7] = true;
        blArray[9] = true;
        blArray[10] = true;
        blArray[12] = true;
        blArray[13] = true;
        blArray[14] = true;
        blArray[15] = true;
        blArray[16] = true;
        boolean[] clickable = blArray;
        int i = 0;
        while (i < labels.length) {
            int j;
            if (solutions.length >= measures[i].getMinimumWindowSize()) {
                int size = Math.min(solutions.length, measures[i].getMaximumWindowSize());
                Solution[] window = new Solution[size];
                j = 0;
                while (j < size) {
                    window[j] = solutions[j];
                    ++j;
                }
                measures[i].setSolutions(window);
                labels[i].setText(SolutionUtils.formatMinutes(measures[i].getValue()));
            } else {
                labels[i].setText("XX:XX.XX");
            }
            if (clickable[i]) {
                MouseListener[] mouseListeners;
                MouseListener[] mouseListenerArray = mouseListeners = labels[i].getMouseListeners();
                int n = mouseListeners.length;
                j = 0;
                while (j < n) {
                    MouseListener mouseListener = mouseListenerArray[j];
                    labels[i].removeMouseListener(mouseListener);
                    ++j;
                }
                labels[i].setCursor(new Cursor(0));
                if (solutions.length >= measures[i].getMinimumWindowSize()) {
                    labels[i].setCursor(new Cursor(12));
                    final int windowSize = measures[i].getMinimumWindowSize();
                    final int windowPosition = measures[i].getWindowPosition();
                    labels[i].addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            HistoryFrame.this.table.removeRowSelectionInterval(0, HistoryFrame.this.table.getRowCount() - 1);
                            int i = 0;
                            while (i < windowSize) {
                                HistoryFrame.this.table.addRowSelectionInterval(selectedRows[windowPosition + i], selectedRows[windowPosition + i]);
                                ++i;
                            }
                        }
                    });
                }
            }
            ++i;
        }
    }

    private void updateTable(Solution[] solutions) {
        DefaultTableModel tableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        String[] stringArray = new String[]{"#", "Start", "Time", "Penalty", "Scramble"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String column = stringArray[n2];
            tableModel.addColumn(column);
            ++n2;
        }
        this.table.setModel(tableModel);
        this.table.setAutoResizeMode(3);
        int[] columnsWidth = new int[]{100, 400, 200, 200, 1000};
        int i = 0;
        while (i < columnsWidth.length) {
            TableColumn indexColumn = this.table.getColumnModel().getColumn(i);
            indexColumn.setPreferredWidth(columnsWidth[i]);
            ++i;
        }
        i = 0;
        while (i < solutions.length) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
            String sStart = dateFormat.format(solutions[i].getTiming().getStart());
            String sTime = SolutionUtils.formatMinutes(solutions[i].getTiming().getElapsedTime());
            tableModel.addRow(new Object[]{solutions.length - i, sStart, sTime, solutions[i].getPenalty(), StringUtils.join(" ", solutions[i].getScramble().getSequence())});
            ++i;
        }
    }

    private static class SolutionEditingDialog
    extends JDialog {
        private JTextField textFieldStart;
        private JTextField textFieldTime;
        private JComboBox comboBoxPenalty;
        private JTextField textFieldScramble;
        private JButton buttonOk;
        private JButton buttonCancel;

        public SolutionEditingDialog(JFrame owner, boolean modal, final Solution solution, final SolutionEditingDialogListener listener) {
            super((Frame)owner, modal);
            this.setTitle("Solution Editor");
            this.setMinimumSize(new Dimension(480, 200));
            this.setPreferredSize(this.getMinimumSize());
            this.createComponents();
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
            this.textFieldStart.setText(dateFormat.format(solution.getTiming().getStart()));
            this.textFieldTime.setText(SolutionUtils.formatMinutes(solution.getTiming().getElapsedTime()));
            this.comboBoxPenalty.addItem("");
            this.comboBoxPenalty.addItem("+2");
            this.comboBoxPenalty.addItem("DNF");
            this.comboBoxPenalty.setSelectedItem(solution.getPenalty());
            this.textFieldScramble.setText(StringUtils.join(" ", solution.getScramble().getSequence()));
            this.textFieldScramble.setCaretPosition(0);
            this.buttonOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    long time = SolutionUtils.parseTime(SolutionEditingDialog.this.textFieldTime.getText());
                    Timing timing = new Timing(solution.getTiming().getStart(), new Date(solution.getTiming().getStart().getTime() + time));
                    String penalty = (String)SolutionEditingDialog.this.comboBoxPenalty.getSelectedItem();
                    listener.solutionEdited(solution.setTiming(timing).setPenalty(penalty));
                    SolutionEditingDialog.this.dispose();
                }
            });
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    SolutionEditingDialog.this.dispose();
                }
            });
            this.getRootPane().registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    SolutionEditingDialog.this.dispose();
                }
            }, KeyStroke.getKeyStroke(27, 0), 2);
        }

        private void createComponents() {
            this.setLayout(new MigLayout("fill, wrap", "[pref!][fill]", "[pref!]8[pref!]8[pref!]8[pref!]16[bottom]"));
            this.add(new JLabel("Start:"));
            this.textFieldStart = new JTextField();
            this.textFieldStart.setEditable(false);
            this.add(this.textFieldStart);
            this.add(new JLabel("Time:"));
            this.textFieldTime = new JTextField();
            this.add(this.textFieldTime);
            this.add(new JLabel("Penalty:"));
            this.comboBoxPenalty = new JComboBox();
            this.add(this.comboBoxPenalty);
            this.add(new JLabel("Scramble:"));
            this.textFieldScramble = new JTextField();
            this.textFieldScramble.setEditable(false);
            this.add(this.textFieldScramble);
            this.buttonOk = new JButton("OK");
            this.add((Component)this.buttonOk, "right, width 100, span 2, split");
            this.buttonCancel = new JButton("Cancel");
            this.add((Component)this.buttonCancel, "width 100");
        }

        public static class SolutionEditingDialogListener {
            public void solutionEdited(Solution solution) {
            }
        }
    }

    private static class SolutionImporterDialog
    extends JDialog {
        private JTextArea textAreaContents;
        private JButton buttonOk;
        private JButton buttonCancel;

        public SolutionImporterDialog(JFrame owner, boolean modal, final UUID categoryId, final String scramblerId, final ScrambleParser scrambleParser, final SolutionImporterListener listener) {
            super((Frame)owner, modal);
            this.setTitle("Solution Importer");
            this.setMinimumSize(new Dimension(640, 480));
            this.setPreferredSize(this.getMinimumSize());
            this.createComponents();
            this.buttonOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    String contents = SolutionImporterDialog.this.textAreaContents.getText();
                    Date start = new Date();
                    ArrayList<Solution> solutions = new ArrayList<Solution>();
                    String[] stringArray = contents.split("\n");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        if ((line = line.trim()).length() != 0 && !line.startsWith("#")) {
                            String[] parts = line.split("\\s+", 2);
                            long time = SolutionUtils.parseTime(parts[0]);
                            Timing timing = new Timing(start, new Date(start.getTime() + time));
                            Scramble scramble = new Scramble(scramblerId, new String[0]);
                            if (parts.length > 1) {
                                scramble = new Scramble(scramblerId, scrambleParser.parse(parts[1]));
                            }
                            solutions.add(new Solution(UUID.randomUUID(), categoryId, scramble, timing, ""));
                            start = new Date(start.getTime() + time);
                        }
                        ++n2;
                    }
                    Solution[] solutionsArray = new Solution[solutions.size()];
                    solutions.toArray(solutionsArray);
                    listener.solutionsImported(solutionsArray);
                    SolutionImporterDialog.this.dispose();
                }
            });
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    SolutionImporterDialog.this.dispose();
                }
            });
            this.getRootPane().registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    SolutionImporterDialog.this.dispose();
                }
            }, KeyStroke.getKeyStroke(27, 0), 2);
        }

        private void createComponents() {
            this.setLayout(new MigLayout("fill", "", "[pref!][fill]16[pref!]"));
            this.add((Component)new JLabel("Solutions"), "wrap");
            this.textAreaContents = new JTextArea("# one solution per line\n# format: time [scramble]");
            JScrollPane scrollPane = new JScrollPane(this.textAreaContents);
            this.add((Component)scrollPane, "growx, wrap");
            this.buttonOk = new JButton("OK");
            this.add((Component)this.buttonOk, "right, width 100, span 2, split");
            this.buttonCancel = new JButton("Cancel");
            this.add((Component)this.buttonCancel, "width 100");
        }

        public static class SolutionImporterListener {
            public void solutionsImported(Solution[] solutions) {
            }
        }
    }
}

