/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.gui;

import com.puzzletimer.models.Category;
import com.puzzletimer.models.Solution;
import com.puzzletimer.state.CategoryListener;
import com.puzzletimer.state.CategoryManager;
import com.puzzletimer.state.SessionListener;
import com.puzzletimer.state.SessionManager;
import com.puzzletimer.statistics.Best;
import com.puzzletimer.statistics.BestAverage;
import com.puzzletimer.statistics.Mean;
import com.puzzletimer.statistics.StandardDeviation;
import com.puzzletimer.statistics.StatisticalMeasure;
import com.puzzletimer.statistics.Worst;
import com.puzzletimer.util.SolutionUtils;
import com.puzzletimer.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;

public class SessionSummaryFrame
extends JFrame {
    private JTextArea textAreaSummary;
    private JButton buttonCopyToClipboard;
    private JButton buttonOk;

    public SessionSummaryFrame(final CategoryManager categoryManager, SessionManager sessionManager) {
        this.setMinimumSize(new Dimension(640, 480));
        this.setPreferredSize(this.getMinimumSize());
        this.createComponents();
        categoryManager.addCategoryListener(new CategoryListener(){

            @Override
            public void categoriesUpdated(Category[] categories, Category currentCategory) {
                SessionSummaryFrame.this.setTitle("Session Summary - " + currentCategory.getDescription());
            }
        });
        categoryManager.notifyListeners();
        sessionManager.addSessionListener(new SessionListener(){

            @Override
            public void solutionsUpdated(Solution[] solutions) {
                SessionSummaryFrame.this.updateSummary(categoryManager.getCurrentCategory(), solutions);
            }
        });
        this.buttonCopyToClipboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                StringSelection contents = new StringSelection(SessionSummaryFrame.this.textAreaSummary.getText());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(contents, contents);
            }
        });
        this.setDefaultCloseOperation(1);
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SessionSummaryFrame.this.setVisible(false);
            }
        });
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SessionSummaryFrame.this.setVisible(false);
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    private void createComponents() {
        this.setLayout(new MigLayout("fill", "", "[pref!][][pref!]16[pref!]"));
        this.add((Component)new JLabel("Summary"), "wrap");
        this.textAreaSummary = new JTextArea();
        JScrollPane scrollPane = new JScrollPane(this.textAreaSummary);
        this.add((Component)scrollPane, "grow, wrap");
        this.buttonCopyToClipboard = new JButton("Copy to Clipboard");
        this.add((Component)this.buttonCopyToClipboard, "width 150, right, wrap");
        this.buttonOk = new JButton("OK");
        this.add((Component)this.buttonOk, "width 100, right");
    }

    private void updateSummary(Category currentCategory, Solution[] solutions) {
        StringBuilder summary = new StringBuilder();
        summary.append(currentCategory.getDescription());
        summary.append("\n");
        if (solutions.length >= 1) {
            Date start = solutions[solutions.length - 1].getTiming().getStart();
            Date end = solutions[0].getTiming().getEnd();
            DateFormat dateTimeFormat = DateFormat.getDateTimeInstance(2, 2);
            DateFormat timeFormat = DateFormat.getTimeInstance(2);
            summary.append(String.valueOf(dateTimeFormat.format(start)) + " - " + timeFormat.format(end));
            summary.append("\n");
            summary.append("\n");
            String[] labels = new String[]{"Mean:              ", "Standard deviation:", "Best Time:         ", "Worst Time:        "};
            StatisticalMeasure[] statistics = new StatisticalMeasure[]{new Mean(1, Integer.MAX_VALUE), new StandardDeviation(1, Integer.MAX_VALUE), new Best(1, Integer.MAX_VALUE), new Worst(1, Integer.MAX_VALUE)};
            int maxStringLength = 0;
            int i = 0;
            while (i < statistics.length) {
                statistics[i].setSolutions(solutions);
                String s = SolutionUtils.formatSeconds(statistics[i].getValue());
                if (s.length() > maxStringLength) {
                    maxStringLength = s.length();
                }
                ++i;
            }
            i = 0;
            while (i < labels.length) {
                summary.append(String.format("%s %" + maxStringLength + "s", labels[i], SolutionUtils.formatSeconds(statistics[i].getValue())));
                summary.append("\n");
                ++i;
            }
            summary.append("\n");
        }
        String[] labels = new String[]{"Best average of 5:", "Best average of 12:"};
        StatisticalMeasure[] statistics = new StatisticalMeasure[]{new BestAverage(5, Integer.MAX_VALUE), new BestAverage(12, Integer.MAX_VALUE)};
        int i = 0;
        while (i < statistics.length) {
            int windowSize = statistics[i].getMinimumWindowSize();
            if (solutions.length >= windowSize) {
                statistics[i].setSolutions(solutions);
                int windowPosition = statistics[i].getWindowPosition();
                summary.append(String.valueOf(labels[i]) + " " + SolutionUtils.formatSeconds(statistics[i].getValue()));
                summary.append("\n");
                summary.append(String.format("  %d-%d - ", solutions.length - windowPosition - windowSize + 1, solutions.length - windowPosition));
                int indexBest = 0;
                int indexWorst = 0;
                long[] times = new long[windowSize];
                int j = 0;
                while (j < windowSize) {
                    times[j] = SolutionUtils.realTime(solutions[windowPosition + j]);
                    if (times[j] < times[indexBest]) {
                        indexBest = j;
                    }
                    if (times[j] > times[indexWorst]) {
                        indexWorst = j;
                    }
                    ++j;
                }
                String sTimes = "";
                int j2 = windowSize - 1;
                while (j2 >= 0) {
                    sTimes = j2 == indexBest || j2 == indexWorst ? String.valueOf(sTimes) + "(" + SolutionUtils.formatSeconds(times[j2]) + ") " : String.valueOf(sTimes) + SolutionUtils.formatSeconds(times[j2]) + " ";
                    --j2;
                }
                summary.append(sTimes.trim());
                summary.append("\n");
                summary.append("\n");
            }
            ++i;
        }
        String[] sSolutions = new String[solutions.length];
        long[] realTimes = SolutionUtils.realTimes(solutions, false);
        int maxStringLength = 0;
        int i2 = 0;
        while (i2 < realTimes.length) {
            sSolutions[i2] = SolutionUtils.formatSeconds(realTimes[i2]);
            if (sSolutions[i2].length() > maxStringLength) {
                maxStringLength = sSolutions[i2].length();
            }
            ++i2;
        }
        i2 = solutions.length - 1;
        while (i2 >= 0) {
            String indexFormat = "%" + ((int)Math.log10(solutions.length) + 1) + "d. ";
            summary.append(String.format(indexFormat, solutions.length - i2));
            String timeFormat = "%" + maxStringLength + "s  ";
            summary.append(String.format(timeFormat, sSolutions[i2]));
            summary.append(StringUtils.join(" ", solutions[i2].getScramble().getSequence()));
            summary.append("\n");
            --i2;
        }
        this.textAreaSummary.setText(summary.toString());
        this.textAreaSummary.setCaretPosition(0);
    }
}

