/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.puzzles;

import com.puzzletimer.graphics.Mesh;
import com.puzzletimer.graphics.algebra.Matrix44;
import com.puzzletimer.graphics.geometry.Plane;
import com.puzzletimer.models.ColorScheme;
import com.puzzletimer.models.PuzzleInfo;
import com.puzzletimer.puzzles.Puzzle;
import java.awt.Color;
import java.util.HashMap;

public class Pyraminx
implements Puzzle {
    @Override
    public PuzzleInfo getPuzzleInfo() {
        return new PuzzleInfo("PYRAMINX", "Pyraminx");
    }

    public String toString() {
        return this.getPuzzleInfo().getDescription();
    }

    @Override
    public Mesh getScrambledPuzzleMesh(ColorScheme colorScheme, String[] sequence) {
        Color[] colorArray = new Color[]{colorScheme.getFaceColor("FACE-U").getColor(), colorScheme.getFaceColor("FACE-R").getColor(), colorScheme.getFaceColor("FACE-L").getColor(), colorScheme.getFaceColor("FACE-B").getColor()};
        Mesh mesh = Mesh.tetrahedron(colorArray);
        double h1 = Math.sqrt(8.0) / 3.0 * (Math.sqrt(3.0) / 2.0 * 1.5);
        Plane plane1 = Plane.fromVectors(mesh.vertices.get(mesh.faces.get((int)0).vertexIndices.get(0)), mesh.vertices.get(mesh.faces.get((int)0).vertexIndices.get(1)), mesh.vertices.get(mesh.faces.get((int)0).vertexIndices.get(2)));
        Plane planeu = new Plane(plane1.p.sub(plane1.n.mul(2.0 * h1 / 3.0)), plane1.n.neg());
        Plane planeU = new Plane(plane1.p.sub(plane1.n.mul(h1 / 3.0)), plane1.n.neg());
        Plane plane2 = Plane.fromVectors(mesh.vertices.get(mesh.faces.get((int)1).vertexIndices.get(0)), mesh.vertices.get(mesh.faces.get((int)1).vertexIndices.get(1)), mesh.vertices.get(mesh.faces.get((int)1).vertexIndices.get(2)));
        Plane planer = new Plane(plane2.p.sub(plane2.n.mul(2.0 * h1 / 3.0)), plane2.n.neg());
        Plane planeR = new Plane(plane2.p.sub(plane2.n.mul(h1 / 3.0)), plane2.n.neg());
        Plane plane3 = Plane.fromVectors(mesh.vertices.get(mesh.faces.get((int)2).vertexIndices.get(0)), mesh.vertices.get(mesh.faces.get((int)2).vertexIndices.get(1)), mesh.vertices.get(mesh.faces.get((int)2).vertexIndices.get(2)));
        Plane planel = new Plane(plane3.p.sub(plane3.n.mul(2.0 * h1 / 3.0)), plane3.n.neg());
        Plane planeL = new Plane(plane3.p.sub(plane3.n.mul(h1 / 3.0)), plane3.n.neg());
        Plane plane4 = Plane.fromVectors(mesh.vertices.get(mesh.faces.get((int)3).vertexIndices.get(0)), mesh.vertices.get(mesh.faces.get((int)3).vertexIndices.get(1)), mesh.vertices.get(mesh.faces.get((int)3).vertexIndices.get(2)));
        Plane planeb = new Plane(plane4.p.sub(plane4.n.mul(2.0 * h1 / 3.0)), plane4.n.neg());
        Plane planeB = new Plane(plane4.p.sub(plane4.n.mul(h1 / 3.0)), plane4.n.neg());
        mesh = mesh.shortenFaces(0.08).cut(planeu, 0.05).cut(planeU, 0.05).cut(planer, 0.05).cut(planeR, 0.05).cut(planel, 0.05).cut(planeL, 0.05).cut(planeb, 0.05).cut(planeB, 0.05).softenFaces(0.02).softenFaces(0.01);
        HashMap<String, Twist> twists = new HashMap<String, Twist>();
        twists.put("U", new Twist(planeU, 2.0943951023931953));
        twists.put("U'", new Twist(planeU, -2.0943951023931953));
        twists.put("u", new Twist(planeu, 2.0943951023931953));
        twists.put("u'", new Twist(planeu, -2.0943951023931953));
        twists.put("L", new Twist(planeL, 2.0943951023931953));
        twists.put("L'", new Twist(planeL, -2.0943951023931953));
        twists.put("l", new Twist(planel, 2.0943951023931953));
        twists.put("l'", new Twist(planel, -2.0943951023931953));
        twists.put("R", new Twist(planeR, 2.0943951023931953));
        twists.put("R'", new Twist(planeR, -2.0943951023931953));
        twists.put("r", new Twist(planer, 2.0943951023931953));
        twists.put("r'", new Twist(planer, -2.0943951023931953));
        twists.put("B", new Twist(planeB, 2.0943951023931953));
        twists.put("B'", new Twist(planeB, -2.0943951023931953));
        twists.put("b", new Twist(planeb, 2.0943951023931953));
        twists.put("b'", new Twist(planeb, -2.0943951023931953));
        String[] stringArray = sequence;
        int n = sequence.length;
        int n2 = 0;
        while (n2 < n) {
            String move = stringArray[n2];
            Twist t = (Twist)twists.get(move);
            mesh = mesh.transformHalfspace(Matrix44.rotation(t.plane.n, t.angle), t.plane);
            ++n2;
        }
        return mesh.transform(Matrix44.rotationY(-0.7853981633974483)).transform(Matrix44.rotationX(0.5235987755982988));
    }

    private static class Twist {
        public Plane plane;
        public double angle;

        public Twist(Plane plane, double angle) {
            this.plane = plane;
            this.angle = angle;
        }
    }
}

