/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.puzzles;

import com.puzzletimer.graphics.Face;
import com.puzzletimer.graphics.Mesh;
import com.puzzletimer.graphics.algebra.Matrix44;
import com.puzzletimer.graphics.algebra.Vector3;
import com.puzzletimer.models.ColorScheme;
import com.puzzletimer.models.PuzzleInfo;
import com.puzzletimer.puzzles.Puzzle;
import com.puzzletimer.solvers.RubiksClockSolver;
import java.awt.Color;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RubiksClock
implements Puzzle {
    @Override
    public PuzzleInfo getPuzzleInfo() {
        return new PuzzleInfo("RUBIKS-CLOCK", "Rubik's clock");
    }

    public String toString() {
        return this.getPuzzleInfo().getDescription();
    }

    private RubiksClockSolver.State stateFromSequence(String[] sequence) {
        Pattern pattern2 = Pattern.compile("([Ud]{4}) ([ud])=(-?\\d),([ud])=(-?\\d)");
        Pattern pattern1 = Pattern.compile("([Ud]{4}) ([ud])=(-?\\d)");
        Pattern pattern0 = Pattern.compile("([Ud]{4})");
        RubiksClockSolver.State state = RubiksClockSolver.State.id;
        String[] stringArray = sequence;
        int n = sequence.length;
        int n2 = 0;
        while (n2 < n) {
            String move = stringArray[n2];
            Matcher matcher2 = pattern2.matcher(move.toString());
            if (matcher2.find()) {
                String pins = matcher2.group(1);
                boolean[] pinsDown = new boolean[4];
                int i = 0;
                while (i < 4) {
                    pinsDown[i] = pins.charAt(i) != 'U';
                    ++i;
                }
                int wheel1 = -1;
                int i2 = 0;
                while (i2 < 4) {
                    if (matcher2.group(2).charAt(0) == (pinsDown[i2] ? (char)'d' : 'u')) {
                        wheel1 = i2;
                    }
                    ++i2;
                }
                int turns1 = Integer.parseInt(matcher2.group(3));
                state = state.rotateWheel(pinsDown, wheel1, turns1);
                int wheel2 = -1;
                int i3 = 0;
                while (i3 < 4) {
                    if (matcher2.group(4).charAt(0) == (pinsDown[i3] ? (char)'d' : 'u')) {
                        wheel2 = i3;
                    }
                    ++i3;
                }
                int turns2 = Integer.parseInt(matcher2.group(5));
                state = state.rotateWheel(pinsDown, wheel2, turns2);
            } else {
                int i;
                Matcher matcher1 = pattern1.matcher(move.toString());
                if (matcher1.find()) {
                    String pins = matcher1.group(1);
                    boolean[] pinsDown = new boolean[4];
                    int i4 = 0;
                    while (i4 < 4) {
                        pinsDown[i4] = pins.charAt(i4) != 'U';
                        ++i4;
                    }
                    int wheel = -1;
                    i = 0;
                    while (i < 4) {
                        if (matcher1.group(2).charAt(0) == (pinsDown[i] ? (char)'d' : 'u')) {
                            wheel = i;
                        }
                        ++i;
                    }
                    int turns = Integer.parseInt(matcher1.group(3));
                    state = state.rotateWheel(pinsDown, wheel, turns);
                } else {
                    Matcher matcher0 = pattern0.matcher(move.toString());
                    if (matcher0.find()) {
                        String pins = matcher0.group(1);
                        boolean[] pinsDown = new boolean[4];
                        i = 0;
                        while (i < 4) {
                            pinsDown[i] = pins.charAt(i) != 'U';
                            ++i;
                        }
                        state = state.rotateWheel(pinsDown, 0, 0);
                    }
                }
            }
            ++n2;
        }
        return state;
    }

    private Mesh circle(double radius, int nVertices, Color color) {
        ArrayList<Vector3> vertices = new ArrayList<Vector3>();
        int i = 0;
        while (i < nVertices) {
            double x = radius * Math.cos(Math.PI * -2 * (double)i / (double)nVertices);
            double y = radius * Math.sin(Math.PI * -2 * (double)i / (double)nVertices);
            vertices.add(new Vector3(x, y, 0.0));
            ++i;
        }
        ArrayList<Integer> vertexIndices = new ArrayList<Integer>();
        int i2 = 0;
        while (i2 < nVertices) {
            vertexIndices.add(i2);
            ++i2;
        }
        ArrayList<Face> faces = new ArrayList<Face>();
        faces.add(new Face(vertexIndices, color));
        return new Mesh(vertices, faces);
    }

    private Mesh hand(double radius1, int nVertices1, double radius2, int nVertices2, double height, Color color) {
        double y;
        double x;
        ArrayList<Vector3> vertices = new ArrayList<Vector3>();
        int i = 0;
        while (i < nVertices1) {
            x = radius1 * Math.cos(-Math.PI * (double)i / (double)(nVertices1 - 1));
            y = radius1 * Math.sin(-Math.PI * (double)i / (double)(nVertices1 - 1));
            vertices.add(new Vector3(x, y, 0.0));
            ++i;
        }
        i = 0;
        while (i < nVertices2) {
            x = radius2 * Math.cos(Math.PI - Math.PI * (double)i / (double)(nVertices2 - 1));
            y = radius2 * Math.sin(Math.PI - Math.PI * (double)i / (double)(nVertices2 - 1));
            vertices.add(new Vector3(x, y + height, 0.0));
            ++i;
        }
        ArrayList<Integer> vertexIndices = new ArrayList<Integer>();
        int i2 = 0;
        while (i2 < nVertices1 + nVertices2) {
            vertexIndices.add(i2);
            ++i2;
        }
        ArrayList<Face> faces = new ArrayList<Face>();
        faces.add(new Face(vertexIndices, color));
        return new Mesh(vertices, faces);
    }

    @Override
    public Mesh getScrambledPuzzleMesh(ColorScheme colorScheme, String[] sequence) {
        Matrix44 transformation;
        int j;
        RubiksClockSolver.State state = this.stateFromSequence(sequence);
        Mesh handBackground = this.hand(0.04, 8, 0.001, 3, 0.16, colorScheme.getFaceColor("HAND-BACKGROUND").getColor()).transform(Matrix44.translation(new Vector3(0.0, 0.0, -0.025)));
        Mesh handForeground = this.hand(0.025, 8, 0.001, 3, 0.11, colorScheme.getFaceColor("HAND-FOREGROUND").getColor()).transform(Matrix44.translation(new Vector3(0.0, 0.0, -0.05)));
        Mesh hands = handBackground.union(handForeground);
        Mesh front = new Mesh(new ArrayList<Vector3>(), new ArrayList<Face>());
        int i = 0;
        while (i < 3) {
            j = 0;
            while (j < 3) {
                Matrix44 transformation2 = Matrix44.translation(new Vector3(0.5 * (double)(j - 1), 0.5 * (double)(1 - i), 0.0)).mul(Matrix44.rotationZ(0.5235987755982988 * (double)state.clocks[3 * i + j]));
                front = front.union(this.circle(0.225, 32, colorScheme.getFaceColor("FRONT").getColor()).union(hands).transform(transformation2));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 2) {
            j = 0;
            while (j < 2) {
                boolean pinDown = state.pinsDown[2 * i + j];
                transformation = Matrix44.translation(new Vector3(0.5 * ((double)j - 0.5), 0.5 * (0.5 - (double)i), pinDown ? 0.0 : -0.1));
                Color pinColor = colorScheme.getFaceColor(pinDown ? "PIN-DOWN" : "PIN-UP").getColor();
                front = front.union(this.circle(0.05, 16, pinColor).transform(transformation));
                ++j;
            }
            ++i;
        }
        Mesh back = new Mesh(new ArrayList<Vector3>(), new ArrayList<Face>());
        int i2 = 0;
        while (i2 < 3) {
            int j2 = 0;
            while (j2 < 3) {
                transformation = Matrix44.translation(new Vector3(0.5 * (double)(j2 - 1), 0.5 * (double)(1 - i2), 0.0)).mul(Matrix44.rotationZ(0.5235987755982988 * (double)state.clocks[9 + 3 * i2 + j2]));
                back = back.union(this.circle(0.225, 32, colorScheme.getFaceColor("BACK").getColor()).union(hands).transform(transformation));
                ++j2;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < 2) {
            int j3 = 0;
            while (j3 < 2) {
                boolean pinDown = !state.pinsDown[2 * i2 + (1 - j3)];
                Matrix44 transformation3 = Matrix44.translation(new Vector3(0.5 * ((double)j3 - 0.5), 0.5 * (0.5 - (double)i2), pinDown ? 0.0 : -0.1));
                Color pinColor = colorScheme.getFaceColor(pinDown ? "PIN-DOWN" : "PIN-UP").getColor();
                back = back.union(this.circle(0.05, 16, pinColor).transform(transformation3));
                ++j3;
            }
            ++i2;
        }
        back = back.transform(Matrix44.rotationY(Math.PI));
        return front.transform(Matrix44.translation(new Vector3(0.0, 0.0, -0.1))).union(back.transform(Matrix44.translation(new Vector3(0.0, 0.0, 0.1))));
    }
}

