/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.scramblers;

import com.puzzletimer.models.Scramble;
import com.puzzletimer.models.ScramblerInfo;
import com.puzzletimer.scramblers.Scrambler;
import com.puzzletimer.solvers.PyraminxSolver;
import java.util.Random;

public class PyraminxRandomScrambler
implements Scrambler {
    private ScramblerInfo scramblerInfo;
    private Random random;

    public PyraminxRandomScrambler(ScramblerInfo scramblerInfo) {
        this.scramblerInfo = scramblerInfo;
        this.random = new Random();
    }

    @Override
    public ScramblerInfo getScramblerInfo() {
        return this.scramblerInfo;
    }

    @Override
    public Scramble getNextScramble() {
        int tipsOrientation = this.random.nextInt(81);
        int verticesOrientation = this.random.nextInt(81);
        int edgesPermutation = this.random.nextInt(360);
        int edgesOrientation = this.random.nextInt(32);
        String[] sequence = PyraminxSolver.generate(tipsOrientation, verticesOrientation, edgesPermutation, edgesOrientation);
        return new Scramble(this.getScramblerInfo().getScramblerId(), sequence);
    }

    public String toString() {
        return this.getScramblerInfo().getDescription();
    }
}

