/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.scramblers;

import com.puzzletimer.models.Scramble;
import com.puzzletimer.models.ScramblerInfo;
import com.puzzletimer.scramblers.Scrambler;
import java.util.ArrayList;
import java.util.Random;

public class Square1RandomScrambler
implements Scrambler {
    private ScramblerInfo scramblerInfo;
    private int scrambleLength;

    public Square1RandomScrambler(ScramblerInfo scramblerInfo, int scrambleLength) {
        this.scramblerInfo = scramblerInfo;
        this.scrambleLength = scrambleLength;
    }

    @Override
    public ScramblerInfo getScramblerInfo() {
        return this.scramblerInfo;
    }

    private boolean[] rotateClockwise(boolean[] xs, int n) {
        boolean[] ys = new boolean[xs.length];
        int i = 0;
        while (i < xs.length) {
            ys[i] = xs[(i + n) % ys.length];
            ++i;
        }
        return ys;
    }

    @Override
    public Scramble getNextScramble() {
        boolean t = true;
        boolean f = false;
        boolean[] top = new boolean[]{t, t, f, t, t, f, t, t, f, t, t, f};
        boolean[] bottom = new boolean[]{t, f, t, t, f, t, t, f, t, t, f, t};
        Random r = new Random();
        ArrayList<String> sequence = new ArrayList<String>();
        int scrambleLength = 0;
        while (scrambleLength < this.scrambleLength) {
            ArrayList<Integer> topOptions = new ArrayList<Integer>();
            int j = 0;
            while (j < 12) {
                if (top[j] && top[(j + 6) % 12]) {
                    topOptions.add(j);
                }
                ++j;
            }
            int x = (Integer)topOptions.get(r.nextInt(topOptions.size()));
            ArrayList<Integer> bottomOptions = new ArrayList<Integer>();
            int j2 = 0;
            while (j2 < 12) {
                if (bottom[j2] && bottom[(j2 + 6) % 12]) {
                    bottomOptions.add(j2);
                }
                ++j2;
            }
            int y = (Integer)bottomOptions.get(r.nextInt(bottomOptions.size()));
            if (x == 0 && y == 0) continue;
            if (x > 0) {
                top = this.rotateClockwise(top, x);
                ++scrambleLength;
            }
            if (y > 0) {
                bottom = this.rotateClockwise(bottom, y);
                ++scrambleLength;
            }
            sequence.add("(" + (x <= 6 ? x : x - 12) + "," + (y <= 6 ? y : y - 12) + ")");
            boolean[] newTop = new boolean[12];
            boolean[] newBottom = new boolean[12];
            int j3 = 0;
            while (j3 < 12) {
                if (j3 < 7) {
                    newTop[j3] = top[j3];
                    newBottom[j3] = bottom[j3];
                } else {
                    newTop[j3] = bottom[j3];
                    newBottom[j3] = top[j3];
                }
                ++j3;
            }
            top = newTop;
            bottom = newBottom;
            ++scrambleLength;
            sequence.add("/");
        }
        String[] sequenceArray = new String[sequence.size()];
        sequence.toArray(sequenceArray);
        return new Scramble(this.getScramblerInfo().getScramblerId(), sequenceArray);
    }

    public String toString() {
        return this.getScramblerInfo().getDescription();
    }
}

