/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.solvers;

public class IndexMapping {
    public static int permutationToIndex(byte[] permutation) {
        int index = 0;
        int i = 0;
        while (i < permutation.length - 1) {
            index *= permutation.length - i;
            int j = i + 1;
            while (j < permutation.length) {
                if (permutation[i] > permutation[j]) {
                    ++index;
                }
                ++j;
            }
            ++i;
        }
        return index;
    }

    public static byte[] indexToPermutation(int index, int length) {
        byte[] permutation = new byte[length];
        permutation[length - 1] = 0;
        int i = length - 2;
        while (i >= 0) {
            permutation[i] = (byte)(index % (length - i));
            index /= length - i;
            int j = i + 1;
            while (j < length) {
                if (permutation[j] >= permutation[i]) {
                    int n = j;
                    permutation[n] = (byte)(permutation[n] + 1);
                }
                ++j;
            }
            --i;
        }
        return permutation;
    }

    public static int evenPermutationToIndex(byte[] permutation) {
        int index = 0;
        int i = 0;
        while (i < permutation.length - 2) {
            index *= permutation.length - i;
            int j = i + 1;
            while (j < permutation.length) {
                if (permutation[i] > permutation[j]) {
                    ++index;
                }
                ++j;
            }
            ++i;
        }
        return index;
    }

    public static byte[] indexToEvenPermutation(int index, int length) {
        int sum = 0;
        byte[] permutation = new byte[length];
        permutation[length - 1] = 1;
        permutation[length - 2] = 0;
        int i = length - 3;
        while (i >= 0) {
            permutation[i] = (byte)(index % (length - i));
            sum += permutation[i];
            index /= length - i;
            int j = i + 1;
            while (j < length) {
                if (permutation[j] >= permutation[i]) {
                    int n = j;
                    permutation[n] = (byte)(permutation[n] + 1);
                }
                ++j;
            }
            --i;
        }
        if (sum % 2 != 0) {
            byte temp = permutation[permutation.length - 1];
            permutation[permutation.length - 1] = permutation[permutation.length - 2];
            permutation[permutation.length - 2] = temp;
        }
        return permutation;
    }

    public static int orientationToIndex(byte[] orientation, int nValues) {
        int index = 0;
        int i = 0;
        while (i < orientation.length) {
            index = nValues * index + orientation[i];
            ++i;
        }
        return index;
    }

    public static byte[] indexToOrientation(int index, int nValues, int length) {
        byte[] orientation = new byte[length];
        int i = length - 1;
        while (i >= 0) {
            orientation[i] = (byte)(index % nValues);
            index /= nValues;
            --i;
        }
        return orientation;
    }

    public static int zeroSumOrientationToIndex(byte[] orientation, int nValues) {
        int index = 0;
        int i = 0;
        while (i < orientation.length - 1) {
            index = nValues * index + orientation[i];
            ++i;
        }
        return index;
    }

    public static byte[] indexToZeroSumOrientation(int index, int nValues, int length) {
        byte[] orientation = new byte[length];
        orientation[length - 1] = 0;
        int i = length - 2;
        while (i >= 0) {
            orientation[i] = (byte)(index % nValues);
            index /= nValues;
            int n = length - 1;
            orientation[n] = (byte)(orientation[n] + orientation[i]);
            --i;
        }
        orientation[length - 1] = (byte)((nValues - orientation[length - 1] % nValues) % nValues);
        return orientation;
    }

    private static int nChooseK(int n, int k) {
        int value = 1;
        int i = 0;
        while (i < k) {
            value *= n - i;
            ++i;
        }
        i = 0;
        while (i < k) {
            value /= k - i;
            ++i;
        }
        return value;
    }

    public static int combinationToIndex(boolean[] combination, int k) {
        int index = 0;
        int i = combination.length - 1;
        while (i >= 0 && k > 0) {
            if (combination[i]) {
                index += IndexMapping.nChooseK(i, k--);
            }
            --i;
        }
        return index;
    }

    public static boolean[] indexToCombination(int index, int k, int length) {
        boolean[] combination = new boolean[length];
        int i = length - 1;
        while (i >= 0 && k >= 0) {
            if (index >= IndexMapping.nChooseK(i, k)) {
                combination[i] = true;
                index -= IndexMapping.nChooseK(i, k--);
            }
            --i;
        }
        return combination;
    }
}

