/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.solvers;

import com.puzzletimer.solvers.IndexMapping;

public class PyraminxSolver {
    public static final int N_TIPS_ORIERNTATIONS = 81;
    public static final int N_VERTICES_ORIERNTATIONS = 81;
    public static final int N_EDGES_PERMUTATIONS = 360;
    public static final int N_EDGES_ORIENTATIONS = 32;
    public static final int N_MOVES = 8;
    private static State[] moves;
    private static int[][] verticesOrientationMove;
    private static int[][] edgesPermutationMove;
    private static int[][] edgesOrientationMove;
    private static byte[] verticesOrientationDistance;
    private static byte[] edgesPermutationDistance;
    private static byte[] edgesOrientationDistance;

    static {
        int next;
        int k;
        int i;
        int j;
        State state;
        byte[] byArray = new byte[4];
        byArray[0] = 1;
        byte[] byArray2 = new byte[6];
        byArray2[0] = 2;
        byArray2[2] = 1;
        byArray2[3] = 3;
        byArray2[4] = 4;
        byArray2[5] = 5;
        State moveU = new State(byArray, byArray2, new byte[6]);
        byte[] byArray3 = new byte[4];
        byArray3[1] = 1;
        byte[] byArray4 = new byte[6];
        byArray4[1] = 1;
        byArray4[2] = 5;
        byArray4[3] = 3;
        byArray4[4] = 2;
        byArray4[5] = 4;
        byte[] byArray5 = new byte[6];
        byArray5[2] = 1;
        byArray5[5] = 1;
        State moveL = new State(byArray3, byArray4, byArray5);
        byte[] byArray6 = new byte[4];
        byArray6[2] = 1;
        byte[] byArray7 = new byte[6];
        byArray7[1] = 4;
        byArray7[2] = 2;
        byArray7[3] = 1;
        byArray7[4] = 3;
        byArray7[5] = 5;
        byte[] byArray8 = new byte[6];
        byArray8[1] = 1;
        byArray8[4] = 1;
        State moveR = new State(byArray6, byArray7, byArray8);
        byte[] byArray9 = new byte[4];
        byArray9[3] = 1;
        byte[] byArray10 = new byte[6];
        byArray10[0] = 3;
        byArray10[1] = 1;
        byArray10[2] = 2;
        byArray10[3] = 5;
        byArray10[4] = 4;
        byte[] byArray11 = new byte[6];
        byArray11[0] = 1;
        byArray11[3] = 1;
        State moveB = new State(byArray9, byArray10, byArray11);
        moves = new State[]{moveU, moveU.multiply(moveU), moveL, moveL.multiply(moveL), moveR, moveR.multiply(moveR), moveB, moveB.multiply(moveB)};
        verticesOrientationMove = new int[81][8];
        int i2 = 0;
        while (i2 < 81) {
            state = new State(IndexMapping.indexToOrientation(i2, 3, 4), new byte[6], new byte[6]);
            j = 0;
            while (j < 8) {
                PyraminxSolver.verticesOrientationMove[i2][j] = IndexMapping.orientationToIndex(state.multiply((State)PyraminxSolver.moves[j]).verticesOrientation, 3);
                ++j;
            }
            ++i2;
        }
        edgesPermutationMove = new int[360][8];
        i2 = 0;
        while (i2 < 360) {
            state = new State(new byte[4], IndexMapping.indexToEvenPermutation(i2, 6), new byte[6]);
            j = 0;
            while (j < 8) {
                PyraminxSolver.edgesPermutationMove[i2][j] = IndexMapping.evenPermutationToIndex(state.multiply((State)PyraminxSolver.moves[j]).edgesPermutation);
                ++j;
            }
            ++i2;
        }
        edgesOrientationMove = new int[32][8];
        i2 = 0;
        while (i2 < 32) {
            state = new State(new byte[4], new byte[6], IndexMapping.indexToZeroSumOrientation(i2, 2, 6));
            j = 0;
            while (j < 8) {
                PyraminxSolver.edgesOrientationMove[i2][j] = IndexMapping.zeroSumOrientationToIndex(state.multiply((State)PyraminxSolver.moves[j]).edgesOrientation, 2);
                ++j;
            }
            ++i2;
        }
        verticesOrientationDistance = new byte[81];
        i2 = 0;
        while (i2 < verticesOrientationDistance.length) {
            PyraminxSolver.verticesOrientationDistance[i2] = -1;
            ++i2;
        }
        PyraminxSolver.verticesOrientationDistance[0] = 0;
        int distance = 0;
        int nVisited = 1;
        while (nVisited < 81) {
            i = 0;
            while (i < 81) {
                if (verticesOrientationDistance[i] == distance) {
                    k = 0;
                    while (k < 8) {
                        next = verticesOrientationMove[i][k];
                        if (verticesOrientationDistance[next] < 0) {
                            PyraminxSolver.verticesOrientationDistance[next] = (byte)(distance + 1);
                            ++nVisited;
                        }
                        ++k;
                    }
                }
                ++i;
            }
            ++distance;
        }
        edgesPermutationDistance = new byte[360];
        i = 0;
        while (i < edgesPermutationDistance.length) {
            PyraminxSolver.edgesPermutationDistance[i] = -1;
            ++i;
        }
        PyraminxSolver.edgesPermutationDistance[0] = 0;
        distance = 0;
        nVisited = 1;
        while (nVisited < 360) {
            i = 0;
            while (i < 360) {
                if (edgesPermutationDistance[i] == distance) {
                    k = 0;
                    while (k < 8) {
                        next = edgesPermutationMove[i][k];
                        if (edgesPermutationDistance[next] < 0) {
                            PyraminxSolver.edgesPermutationDistance[next] = (byte)(distance + 1);
                            ++nVisited;
                        }
                        ++k;
                    }
                }
                ++i;
            }
            ++distance;
        }
        edgesOrientationDistance = new byte[32];
        i = 0;
        while (i < edgesOrientationDistance.length) {
            PyraminxSolver.edgesOrientationDistance[i] = -1;
            ++i;
        }
        PyraminxSolver.edgesOrientationDistance[0] = 0;
        distance = 0;
        nVisited = 1;
        while (nVisited < 32) {
            i = 0;
            while (i < 32) {
                if (edgesOrientationDistance[i] == distance) {
                    k = 0;
                    while (k < 8) {
                        next = edgesOrientationMove[i][k];
                        if (edgesOrientationDistance[next] < 0) {
                            PyraminxSolver.edgesOrientationDistance[next] = (byte)(distance + 1);
                            ++nVisited;
                        }
                        ++k;
                    }
                }
                ++i;
            }
            ++distance;
        }
    }

    private static int[] solution(int verticesOrientation, int edgesPermutation, int edgesOrientation) {
        int depth = 0;
        int[] solution;
        while (!PyraminxSolver.search(verticesOrientation, edgesPermutation, edgesOrientation, depth, solution = new int[depth], 4)) {
            ++depth;
        }
        return solution;
    }

    private static boolean search(int verticesOrientation, int edgesPermutation, int edgesOrientation, int depth, int[] solution, int axis) {
        if (depth == 0) {
            return verticesOrientation == 0 && edgesPermutation == 0 && edgesOrientation == 0;
        }
        if (verticesOrientationDistance[verticesOrientation] <= depth && edgesPermutationDistance[edgesPermutation] <= depth && edgesOrientationDistance[edgesOrientation] <= depth) {
            int i = 0;
            while (i < 8) {
                if (i / 2 != axis) {
                    solution[depth - 1] = i;
                    if (PyraminxSolver.search(verticesOrientationMove[verticesOrientation][i], edgesPermutationMove[edgesPermutation][i], edgesOrientationMove[edgesOrientation][i], depth - 1, solution, i / 2)) {
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public static String[] generate(int tipsOrientation, int verticesOrientation, int edgesPermutation, int edgesOrientation) {
        byte[] tips = IndexMapping.indexToOrientation(tipsOrientation, 3, 4);
        byte[] vertices = IndexMapping.indexToOrientation(verticesOrientation, 3, 4);
        int nTipMoves = 0;
        int[] tipsSolution = new int[4];
        int i = 0;
        while (i < tipsSolution.length) {
            tipsSolution[i] = (tips[i] + vertices[i]) % 3;
            if (tipsSolution[i] != 0) {
                ++nTipMoves;
            }
            ++i;
        }
        int[] bodySolution = PyraminxSolver.solution(verticesOrientation, edgesPermutation, edgesOrientation);
        String[] sequence = new String[nTipMoves + bodySolution.length];
        String[] inverseTipMoveNames = new String[]{"u'", "u", "l'", "l", "r'", "r", "b'", "b"};
        int pSequence = 0;
        int i2 = 0;
        while (i2 < tipsSolution.length) {
            if (tipsSolution[i2] != 0) {
                sequence[pSequence++] = inverseTipMoveNames[2 * i2 + tipsSolution[i2] - 1];
            }
            ++i2;
        }
        String[] inverseMoveNames = new String[]{"U'", "U", "L'", "L", "R'", "R", "B'", "B"};
        int i3 = 0;
        while (i3 < bodySolution.length) {
            sequence[pSequence++] = inverseMoveNames[bodySolution[i3]];
            ++i3;
        }
        return sequence;
    }

    public static class State {
        public byte[] verticesOrientation;
        public byte[] edgesPermutation;
        public byte[] edgesOrientation;

        public State(byte[] verticesOrientation, byte[] edgesPermutation, byte[] edgesOrientation) {
            this.verticesOrientation = verticesOrientation;
            this.edgesPermutation = edgesPermutation;
            this.edgesOrientation = edgesOrientation;
        }

        public State multiply(State move) {
            byte[] resultVerticesOrientation = new byte[4];
            byte[] resultEdgesPermutation = new byte[6];
            byte[] resultEdgesOrientation = new byte[6];
            int i = 0;
            while (i < 4) {
                resultVerticesOrientation[i] = (byte)((this.verticesOrientation[i] + move.verticesOrientation[i]) % 3);
                ++i;
            }
            i = 0;
            while (i < 6) {
                resultEdgesPermutation[i] = this.edgesPermutation[move.edgesPermutation[i]];
                resultEdgesOrientation[i] = (byte)((this.edgesOrientation[move.edgesPermutation[i]] + move.edgesOrientation[i]) % 2);
                ++i;
            }
            return new State(resultVerticesOrientation, resultEdgesPermutation, resultEdgesOrientation);
        }
    }
}

