/*
 * Decompiled with CFR 0.152.
 */
package com.puzzletimer.solvers;

import com.puzzletimer.solvers.IndexMapping;

public class RubiksPocketCubeSolver {
    public static final int N_PERMUTATIONS = 40320;
    public static final int N_ORIENTATIONS = 2187;
    public static final int N_MOVES = 18;
    private static State[] moves;
    private static int[][] permutationMove;
    private static int[][] orientationMove;
    private static byte[] permutationDistance;
    private static byte[] orientationDistance;

    static {
        int next;
        int k;
        int i;
        int j;
        State state;
        State[] stateArray = new State[18];
        byte[] byArray = new byte[8];
        byArray[0] = 3;
        byArray[2] = 1;
        byArray[3] = 2;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        stateArray[0] = new State(byArray, new byte[8]);
        byte[] byArray2 = new byte[8];
        byArray2[0] = 2;
        byArray2[1] = 3;
        byArray2[3] = 1;
        byArray2[4] = 4;
        byArray2[5] = 5;
        byArray2[6] = 6;
        byArray2[7] = 7;
        stateArray[1] = new State(byArray2, new byte[8]);
        byte[] byArray3 = new byte[8];
        byArray3[0] = 1;
        byArray3[1] = 2;
        byArray3[2] = 3;
        byArray3[4] = 4;
        byArray3[5] = 5;
        byArray3[6] = 6;
        byArray3[7] = 7;
        stateArray[2] = new State(byArray3, new byte[8]);
        byte[] byArray4 = new byte[8];
        byArray4[1] = 1;
        byArray4[2] = 2;
        byArray4[3] = 3;
        byArray4[4] = 5;
        byArray4[5] = 6;
        byArray4[6] = 7;
        byArray4[7] = 4;
        stateArray[3] = new State(byArray4, new byte[8]);
        byte[] byArray5 = new byte[8];
        byArray5[1] = 1;
        byArray5[2] = 2;
        byArray5[3] = 3;
        byArray5[4] = 6;
        byArray5[5] = 7;
        byArray5[6] = 4;
        byArray5[7] = 5;
        stateArray[4] = new State(byArray5, new byte[8]);
        byte[] byArray6 = new byte[8];
        byArray6[1] = 1;
        byArray6[2] = 2;
        byArray6[3] = 3;
        byArray6[4] = 7;
        byArray6[5] = 4;
        byArray6[6] = 5;
        byArray6[7] = 6;
        stateArray[5] = new State(byArray6, new byte[8]);
        byte[] byArray7 = new byte[8];
        byArray7[0] = 4;
        byArray7[1] = 1;
        byArray7[2] = 2;
        byArray7[4] = 7;
        byArray7[5] = 5;
        byArray7[6] = 6;
        byArray7[7] = 3;
        byte[] byArray8 = new byte[8];
        byArray8[0] = 2;
        byArray8[3] = 1;
        byArray8[4] = 1;
        byArray8[7] = 2;
        stateArray[6] = new State(byArray7, byArray8);
        byte[] byArray9 = new byte[8];
        byArray9[0] = 7;
        byArray9[1] = 1;
        byArray9[2] = 2;
        byArray9[3] = 4;
        byArray9[4] = 3;
        byArray9[5] = 5;
        byArray9[6] = 6;
        stateArray[7] = new State(byArray9, new byte[8]);
        byte[] byArray10 = new byte[8];
        byArray10[0] = 3;
        byArray10[1] = 1;
        byArray10[2] = 2;
        byArray10[3] = 7;
        byArray10[5] = 5;
        byArray10[6] = 6;
        byArray10[7] = 4;
        byte[] byArray11 = new byte[8];
        byArray11[0] = 2;
        byArray11[3] = 1;
        byArray11[4] = 1;
        byArray11[7] = 2;
        stateArray[8] = new State(byArray10, byArray11);
        byte[] byArray12 = new byte[8];
        byArray12[1] = 2;
        byArray12[2] = 6;
        byArray12[3] = 3;
        byArray12[4] = 4;
        byArray12[5] = 1;
        byArray12[6] = 5;
        byArray12[7] = 7;
        byte[] byArray13 = new byte[8];
        byArray13[1] = 1;
        byArray13[2] = 2;
        byArray13[5] = 2;
        byArray13[6] = 1;
        stateArray[9] = new State(byArray12, byArray13);
        byte[] byArray14 = new byte[8];
        byArray14[1] = 6;
        byArray14[2] = 5;
        byArray14[3] = 3;
        byArray14[4] = 4;
        byArray14[5] = 2;
        byArray14[6] = 1;
        byArray14[7] = 7;
        stateArray[10] = new State(byArray14, new byte[8]);
        byte[] byArray15 = new byte[8];
        byArray15[1] = 5;
        byArray15[2] = 1;
        byArray15[3] = 3;
        byArray15[4] = 4;
        byArray15[5] = 6;
        byArray15[6] = 2;
        byArray15[7] = 7;
        byte[] byArray16 = new byte[8];
        byArray16[1] = 1;
        byArray16[2] = 2;
        byArray16[5] = 2;
        byArray16[6] = 1;
        stateArray[11] = new State(byArray15, byArray16);
        byte[] byArray17 = new byte[8];
        byArray17[1] = 1;
        byArray17[2] = 3;
        byArray17[3] = 7;
        byArray17[4] = 4;
        byArray17[5] = 5;
        byArray17[6] = 2;
        byArray17[7] = 6;
        byte[] byArray18 = new byte[8];
        byArray18[2] = 1;
        byArray18[3] = 2;
        byArray18[6] = 2;
        byArray18[7] = 1;
        stateArray[12] = new State(byArray17, byArray18);
        byte[] byArray19 = new byte[8];
        byArray19[1] = 1;
        byArray19[2] = 7;
        byArray19[3] = 6;
        byArray19[4] = 4;
        byArray19[5] = 5;
        byArray19[6] = 3;
        byArray19[7] = 2;
        stateArray[13] = new State(byArray19, new byte[8]);
        byte[] byArray20 = new byte[8];
        byArray20[1] = 1;
        byArray20[2] = 6;
        byArray20[3] = 2;
        byArray20[4] = 4;
        byArray20[5] = 5;
        byArray20[6] = 7;
        byArray20[7] = 3;
        byte[] byArray21 = new byte[8];
        byArray21[2] = 1;
        byArray21[3] = 2;
        byArray21[6] = 2;
        byArray21[7] = 1;
        stateArray[14] = new State(byArray20, byArray21);
        byte[] byArray22 = new byte[8];
        byArray22[0] = 1;
        byArray22[1] = 5;
        byArray22[2] = 2;
        byArray22[3] = 3;
        byArray22[5] = 4;
        byArray22[6] = 6;
        byArray22[7] = 7;
        byte[] byArray23 = new byte[8];
        byArray23[0] = 1;
        byArray23[1] = 2;
        byArray23[4] = 2;
        byArray23[5] = 1;
        stateArray[15] = new State(byArray22, byArray23);
        byte[] byArray24 = new byte[8];
        byArray24[0] = 5;
        byArray24[1] = 4;
        byArray24[2] = 2;
        byArray24[3] = 3;
        byArray24[4] = 1;
        byArray24[6] = 6;
        byArray24[7] = 7;
        stateArray[16] = new State(byArray24, new byte[8]);
        byte[] byArray25 = new byte[8];
        byArray25[0] = 4;
        byArray25[2] = 2;
        byArray25[3] = 3;
        byArray25[4] = 5;
        byArray25[5] = 1;
        byArray25[6] = 6;
        byArray25[7] = 7;
        byte[] byArray26 = new byte[8];
        byArray26[0] = 1;
        byArray26[1] = 2;
        byArray26[4] = 2;
        byArray26[5] = 1;
        stateArray[17] = new State(byArray25, byArray26);
        moves = stateArray;
        permutationMove = new int[40320][18];
        int i2 = 0;
        while (i2 < 40320) {
            state = new State(IndexMapping.indexToPermutation(i2, 8), new byte[8]);
            j = 0;
            while (j < 18) {
                RubiksPocketCubeSolver.permutationMove[i2][j] = IndexMapping.permutationToIndex(state.multiply((State)RubiksPocketCubeSolver.moves[j]).permutation);
                ++j;
            }
            ++i2;
        }
        orientationMove = new int[2187][18];
        i2 = 0;
        while (i2 < 2187) {
            state = new State(new byte[8], IndexMapping.indexToZeroSumOrientation(i2, 3, 8));
            j = 0;
            while (j < 18) {
                RubiksPocketCubeSolver.orientationMove[i2][j] = IndexMapping.zeroSumOrientationToIndex(state.multiply((State)RubiksPocketCubeSolver.moves[j]).orientation, 3);
                ++j;
            }
            ++i2;
        }
        permutationDistance = new byte[40320];
        i2 = 0;
        while (i2 < permutationDistance.length) {
            RubiksPocketCubeSolver.permutationDistance[i2] = -1;
            ++i2;
        }
        RubiksPocketCubeSolver.permutationDistance[0] = 0;
        int distance = 0;
        int nVisited = 1;
        while (nVisited < 40320) {
            i = 0;
            while (i < 40320) {
                if (permutationDistance[i] == distance) {
                    k = 0;
                    while (k < 18) {
                        next = permutationMove[i][k];
                        if (permutationDistance[next] < 0) {
                            RubiksPocketCubeSolver.permutationDistance[next] = (byte)(distance + 1);
                            ++nVisited;
                        }
                        ++k;
                    }
                }
                ++i;
            }
            ++distance;
        }
        orientationDistance = new byte[2187];
        i = 0;
        while (i < orientationDistance.length) {
            RubiksPocketCubeSolver.orientationDistance[i] = -1;
            ++i;
        }
        RubiksPocketCubeSolver.orientationDistance[0] = 0;
        distance = 0;
        nVisited = 1;
        while (nVisited < 2187) {
            i = 0;
            while (i < 2187) {
                if (orientationDistance[i] == distance) {
                    k = 0;
                    while (k < 18) {
                        next = orientationMove[i][k];
                        if (orientationDistance[next] < 0) {
                            RubiksPocketCubeSolver.orientationDistance[next] = (byte)(distance + 1);
                            ++nVisited;
                        }
                        ++k;
                    }
                }
                ++i;
            }
            ++distance;
        }
    }

    private static int[] solution(int permutation, int orientation) {
        int depth = 0;
        int[] solution;
        while (!RubiksPocketCubeSolver.search(permutation, orientation, depth, solution = new int[depth], 6)) {
            ++depth;
        }
        return solution;
    }

    private static boolean search(int permutation, int orientation, int depth, int[] solution, int axis) {
        if (depth == 0) {
            return permutation == 0 && orientation == 0;
        }
        if (permutationDistance[permutation] <= depth && orientationDistance[orientation] <= depth) {
            int i = 0;
            while (i < 18) {
                if (i / 3 != axis) {
                    solution[depth - 1] = i;
                    if (RubiksPocketCubeSolver.search(permutationMove[permutation][i], orientationMove[orientation][i], depth - 1, solution, i / 3)) {
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public static String[] generate(int permutation, int orientation) {
        String[] inverseMoveNames = new String[]{"U'", "U2", "U", "D'", "D2", "D", "L'", "L2", "L", "R'", "R2", "R", "F'", "F2", "F", "B'", "B2", "B"};
        int[] solution = RubiksPocketCubeSolver.solution(permutation, orientation);
        String[] sequence = new String[solution.length];
        int i = 0;
        while (i < sequence.length) {
            sequence[i] = inverseMoveNames[solution[i]];
            ++i;
        }
        return sequence;
    }

    public static class State {
        public byte[] permutation;
        public byte[] orientation;

        public State(byte[] permutation, byte[] orientation) {
            this.orientation = orientation;
            this.permutation = permutation;
        }

        public State multiply(State move) {
            byte[] resultPermutation = new byte[8];
            byte[] resultOrientation = new byte[8];
            int i = 0;
            while (i < 8) {
                resultPermutation[i] = this.permutation[move.permutation[i]];
                resultOrientation[i] = (byte)((this.orientation[move.permutation[i]] + move.orientation[i]) % 3);
                ++i;
            }
            return new State(resultPermutation, resultOrientation);
        }
    }
}

